/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.entity.model;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.http.annotation.Immutable;
import org.apache.rya.api.domain.RyaIRI;

@Immutable
@DefaultAnnotation(value={NonNull.class})
public class Type {
    private final RyaIRI id;
    private final ImmutableSet<RyaIRI> propertyNames;

    public Type(RyaIRI id, ImmutableSet<RyaIRI> propertyNames) {
        this.id = Objects.requireNonNull(id);
        this.propertyNames = Objects.requireNonNull(propertyNames);
    }

    public RyaIRI getId() {
        return this.id;
    }

    public ImmutableSet<RyaIRI> getPropertyNames() {
        return this.propertyNames;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.propertyNames);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Type) {
            Type type = (Type)o;
            return Objects.equals(this.id, type.id) && Objects.equals(this.propertyNames, type.propertyNames);
        }
        return false;
    }
}

