/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.entity.model;

import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.http.annotation.Immutable;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.api.domain.RyaType;

@Immutable
@DefaultAnnotation(value={NonNull.class})
public class Property {
    private final RyaIRI name;
    private final RyaType value;

    public Property(RyaIRI name, RyaType value) {
        this.name = Objects.requireNonNull(name);
        this.value = Objects.requireNonNull(value);
    }

    public RyaIRI getName() {
        return this.name;
    }

    public RyaType getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Property) {
            Property field = (Property)o;
            return Objects.equals(this.name, field.name) && Objects.equals(this.value, field.value);
        }
        return false;
    }
}

