/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.entity.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.http.annotation.Immutable;
import org.apache.log4j.Logger;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.indexing.entity.model.Property;
import org.apache.rya.indexing.entity.model.Type;
import org.apache.rya.indexing.entity.model.TypedEntity;
import org.apache.rya.indexing.smarturi.SmartUriAdapter;
import org.apache.rya.indexing.smarturi.SmartUriException;
import org.eclipse.rdf4j.model.IRI;

@Immutable
@DefaultAnnotation(value={NonNull.class})
public class Entity {
    private static final Logger log = Logger.getLogger(Entity.class);
    private final RyaIRI subject;
    private final ImmutableList<RyaIRI> explicitTypeIds;
    private final ImmutableMap<RyaIRI, ImmutableMap<RyaIRI, Property>> properties;
    private final int version;
    private IRI smartUri = null;

    private Entity(RyaIRI subject, ImmutableList<RyaIRI> explicitTypeIds, ImmutableMap<RyaIRI, ImmutableMap<RyaIRI, Property>> typeProperties, int version, IRI smartUri) {
        this.subject = Objects.requireNonNull(subject);
        this.explicitTypeIds = Objects.requireNonNull(explicitTypeIds);
        this.properties = Objects.requireNonNull(typeProperties);
        this.version = version;
        if (smartUri != null) {
            this.smartUri = smartUri;
        } else {
            try {
                this.smartUri = SmartUriAdapter.serializeUriEntity(this);
            }
            catch (SmartUriException e) {
                log.error((Object)"Unable to create a Smart URI for the entity", (Throwable)e);
            }
        }
    }

    private Entity(RyaIRI subject, ImmutableList<RyaIRI> explicitTypeIds, ImmutableMap<RyaIRI, ImmutableMap<RyaIRI, Property>> typeProperties, int version) {
        this(subject, explicitTypeIds, typeProperties, version, null);
    }

    public RyaIRI getSubject() {
        return this.subject;
    }

    public ImmutableList<RyaIRI> getExplicitTypeIds() {
        return this.explicitTypeIds;
    }

    public ImmutableMap<RyaIRI, ImmutableMap<RyaIRI, Property>> getProperties() {
        return this.properties;
    }

    public int getVersion() {
        return this.version;
    }

    public IRI getSmartUri() {
        return this.smartUri;
    }

    public Optional<Property> lookupTypeProperty(Type type, RyaIRI propertyRyaIri) {
        Objects.requireNonNull(type);
        return this.lookupTypeProperty(type.getId(), propertyRyaIri);
    }

    public Optional<Property> lookupTypeProperty(RyaIRI typeRyaIri, RyaIRI propertyRyaIri) {
        Objects.requireNonNull(typeRyaIri);
        Objects.requireNonNull(propertyRyaIri);
        ImmutableMap typePropertyMap = (ImmutableMap)this.properties.get((Object)typeRyaIri);
        Optional<Object> property = Optional.empty();
        if (typePropertyMap != null) {
            property = Optional.ofNullable(typePropertyMap.get((Object)propertyRyaIri));
        }
        return property;
    }

    public int hashCode() {
        return Objects.hash(this.subject, this.explicitTypeIds, this.properties, this.version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Entity) {
            Entity entity = (Entity)o;
            return Objects.equals(this.subject, entity.subject) && Objects.equals(this.explicitTypeIds, entity.explicitTypeIds) && Objects.equals(this.properties, entity.properties) && this.version == entity.version;
        }
        return false;
    }

    public Optional<TypedEntity> makeTypedEntity(RyaIRI typeId) {
        Objects.requireNonNull(typeId);
        boolean explicitlyHasType = this.explicitTypeIds.contains((Object)typeId);
        boolean hasTypesProperties = this.properties.containsKey((Object)typeId);
        if (explicitlyHasType || hasTypesProperties) {
            TypedEntity.Builder builder = TypedEntity.builder().setId(this.subject).setTypeId(typeId).setExplicitelyTyped(this.explicitTypeIds.contains((Object)typeId));
            if (this.properties.containsKey((Object)typeId)) {
                ((ImmutableMap)this.properties.get((Object)typeId)).forEach((propertyName, property) -> builder.setProperty((Property)property));
            }
            return Optional.of(builder.build());
        }
        return Optional.empty();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Entity entity) {
        return new Builder(entity);
    }

    @DefaultAnnotation(value={NonNull.class})
    public static class Builder {
        private RyaIRI subject = null;
        private final List<RyaIRI> explicitTypes = new ArrayList<RyaIRI>();
        private final Map<RyaIRI, Map<RyaIRI, Property>> properties = new HashMap<RyaIRI, Map<RyaIRI, Property>>();
        private IRI smartUri = null;
        private int version = 0;

        public Builder() {
        }

        public Builder(Entity entity) {
            Objects.requireNonNull(entity);
            this.subject = entity.getSubject();
            this.explicitTypes.addAll((Collection<RyaIRI>)entity.getExplicitTypeIds());
            for (Map.Entry entry : entity.getProperties().entrySet()) {
                this.properties.put((RyaIRI)entry.getKey(), Maps.newHashMap((Map)((Map)entry.getValue())));
            }
            this.version = entity.getVersion();
            this.smartUri = entity.getSmartUri();
        }

        public Builder setSubject(@Nullable RyaIRI subject) {
            this.subject = subject;
            return this;
        }

        public Builder setExplicitType(@Nullable RyaIRI typeId) {
            if (typeId != null) {
                this.explicitTypes.add(typeId);
            }
            return this;
        }

        public Builder unsetExplicitType(@Nullable RyaIRI typeId) {
            if (typeId != null) {
                this.explicitTypes.remove(typeId);
            }
            return this;
        }

        public Builder setProperty(@Nullable RyaIRI typeId, @Nullable Property property) {
            if (typeId != null && property != null) {
                if (!this.properties.containsKey(typeId)) {
                    this.properties.put(typeId, new HashMap());
                }
                this.properties.get(typeId).put(property.getName(), property);
            }
            return this;
        }

        public Builder unsetProperty(@Nullable RyaIRI typeId, @Nullable RyaIRI propertyName) {
            Map<RyaIRI, Property> typedProperties;
            if (typeId != null && propertyName != null && this.properties.containsKey(typeId) && (typedProperties = this.properties.get(typeId)).containsKey(propertyName)) {
                typedProperties.remove(propertyName);
            }
            return this;
        }

        public Builder setSmartUri(IRI smartUri) {
            this.smartUri = smartUri;
            return this;
        }

        public Builder rebuildSmartUri() {
            this.setSmartUri(null);
            return this;
        }

        public Builder setVersion(int version) {
            this.version = version;
            return this;
        }

        public Entity build() {
            ImmutableMap.Builder propertiesBuilder = ImmutableMap.builder();
            for (Map.Entry<RyaIRI, Map<RyaIRI, Property>> entry : this.properties.entrySet()) {
                propertiesBuilder.put((Object)entry.getKey(), (Object)ImmutableMap.copyOf(entry.getValue()));
            }
            return new Entity(this.subject, ImmutableList.copyOf(this.explicitTypes), propertiesBuilder.build(), this.version, this.smartUri);
        }
    }
}

