/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.entity;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.indexing.entity.model.Type;
import org.apache.rya.indexing.entity.query.EntityQueryNode;
import org.apache.rya.indexing.entity.storage.EntityStorage;
import org.apache.rya.indexing.entity.storage.TypeStorage;
import org.apache.rya.indexing.external.matching.ExternalSetProvider;
import org.apache.rya.indexing.external.matching.QuerySegment;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;

public class EntityIndexSetProvider
implements ExternalSetProvider<EntityQueryNode> {
    private static final ValueFactory VF = SimpleValueFactory.getInstance();
    private Multimap<Type, StatementPattern> typeMap;
    private Map<String, Type> subjectTypeMap;
    private final TypeStorage typeStorage;
    private final EntityStorage entityStorage;

    public EntityIndexSetProvider(TypeStorage typeStorage, EntityStorage entityStorage) {
        this.typeStorage = Objects.requireNonNull(typeStorage);
        this.entityStorage = Objects.requireNonNull(entityStorage);
    }

    private Var getTypeSubject(Type type) {
        StatementPattern pattern = (StatementPattern)this.typeMap.get((Object)type).iterator().next();
        return pattern.getSubjectVar();
    }

    private RyaIRI getPredIRI(StatementPattern pattern) {
        Var pred = pattern.getPredicateVar();
        return new RyaIRI(pred.getValue().stringValue());
    }

    @Override
    public List<EntityQueryNode> getExternalSets(QuerySegment<EntityQueryNode> node) {
        this.typeMap = HashMultimap.create();
        this.subjectTypeMap = new HashMap<String, Type>();
        ArrayList<StatementPattern> unused = new ArrayList<StatementPattern>();
        for (QueryModelNode pattern : node.getOrderedNodes()) {
            if (!(pattern instanceof StatementPattern)) continue;
            this.discoverEntities((StatementPattern)pattern, unused);
        }
        ArrayList<EntityQueryNode> nodes = new ArrayList<EntityQueryNode>();
        for (Type type : this.typeMap.keySet()) {
            EntityQueryNode entity = new EntityQueryNode(type, this.typeMap.get((Object)type), this.entityStorage);
            nodes.add(entity);
        }
        return nodes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void discoverEntities(StatementPattern pattern, List<StatementPattern> unmatched) {
        Var subj = pattern.getSubjectVar();
        String subjStr = subj.getName();
        RyaIRI predIRI = this.getPredIRI(pattern);
        if (VF.createIRI(predIRI.getData()).equals((Object)RDF.TYPE)) {
            Var obj = pattern.getObjectVar();
            RyaIRI objURI = new RyaIRI(obj.getValue().stringValue());
            try {
                Optional<Type> optType = this.typeStorage.get(objURI);
                if (!optType.isPresent()) return;
                Type type = optType.get();
                this.typeMap.put((Object)type, (Object)pattern);
                this.subjectTypeMap.put(subjStr, type);
                for (StatementPattern propertyPattern : unmatched) {
                    RyaIRI property = this.getPredIRI(propertyPattern);
                    Var typeSubVar = this.getTypeSubject(type);
                    Var patternSubVar = propertyPattern.getSubjectVar();
                    if (!type.getPropertyNames().contains((Object)property) || !typeSubVar.equals((Object)patternSubVar)) continue;
                    this.typeMap.put((Object)type, (Object)propertyPattern);
                }
                return;
            }
            catch (TypeStorage.TypeStorageException e) {
                e.printStackTrace();
                return;
            }
        } else if (this.subjectTypeMap.containsKey(subjStr)) {
            Type type = this.subjectTypeMap.get(subjStr);
            if (type.getPropertyNames().contains((Object)predIRI)) {
                if (this.typeMap.containsKey((Object)type)) return;
                this.typeMap.put((Object)type, (Object)pattern);
                return;
            } else {
                unmatched.add(pattern);
            }
            return;
        } else {
            unmatched.add(pattern);
        }
    }

    @Override
    public Iterator<List<EntityQueryNode>> getExternalSetCombos(QuerySegment<EntityQueryNode> segment) {
        ArrayList<List<EntityQueryNode>> comboList = new ArrayList<List<EntityQueryNode>>();
        comboList.add(this.getExternalSets(segment));
        return comboList.iterator();
    }
}

