/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.entity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import org.apache.rya.indexing.entity.EntityExternalSetMatcherFactory;
import org.apache.rya.indexing.entity.EntityIndexSetProvider;
import org.apache.rya.indexing.entity.query.EntityQueryNode;
import org.apache.rya.indexing.entity.storage.EntityStorage;
import org.apache.rya.indexing.entity.storage.TypeStorage;
import org.apache.rya.indexing.entity.update.mongo.MongoEntityIndexer;
import org.apache.rya.indexing.external.matching.AbstractExternalSetOptimizer;
import org.apache.rya.indexing.external.matching.ExternalSetMatcher;
import org.apache.rya.indexing.external.matching.ExternalSetProvider;
import org.apache.rya.indexing.external.matching.QueryNodeListRater;
import org.apache.rya.indexing.external.matching.QuerySegment;
import org.apache.rya.indexing.external.matching.TopOfQueryFilterRelocator;
import org.apache.rya.mongodb.StatefulMongoDBRdfConfiguration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.TupleExpr;

public class EntityIndexOptimizer
extends AbstractExternalSetOptimizer<EntityQueryNode>
implements Configurable {
    private static final Logger log = Logger.getLogger(EntityIndexOptimizer.class);
    private static final EntityExternalSetMatcherFactory MATCHER_FACTORY = new EntityExternalSetMatcherFactory();
    private final MongoEntityIndexer indexer = new MongoEntityIndexer();
    private EntityIndexSetProvider provider;
    private Configuration conf;
    private EntityStorage entityStorage;
    private TypeStorage typeStorage;

    public EntityIndexOptimizer() {
        this.useOptimal = false;
    }

    public void setConf(Configuration conf) {
        Preconditions.checkState((boolean)(conf instanceof StatefulMongoDBRdfConfiguration), (Object)("The provided Configuration must be of type StatefulMongoDBRdfConfiguration, but was " + conf.getClass().getName()));
        this.conf = conf;
        this.indexer.setConf(conf);
        this.indexer.init();
        this.typeStorage = this.indexer.getTypeStorage();
        try {
            this.entityStorage = this.indexer.getEntityStorage();
        }
        catch (EntityStorage.EntityStorageException e) {
            log.error((Object)"Error getting entity storage", (Throwable)e);
        }
        this.provider = new EntityIndexSetProvider(this.typeStorage, this.entityStorage);
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        Preconditions.checkNotNull((Object)tupleExpr);
        Preconditions.checkNotNull((Object)this.indexer);
        tupleExpr = TopOfQueryFilterRelocator.moveFiltersToTop(tupleExpr);
        super.optimize(tupleExpr, null, null);
    }

    @VisibleForTesting
    public EntityStorage getEntityStorage() {
        return this.entityStorage;
    }

    @VisibleForTesting
    public TypeStorage getTypeStorage() {
        return this.typeStorage;
    }

    @Override
    protected ExternalSetMatcher<EntityQueryNode> getMatcher(QuerySegment<EntityQueryNode> segment) {
        return MATCHER_FACTORY.getMatcher(segment);
    }

    @Override
    protected ExternalSetProvider<EntityQueryNode> getProvider() {
        return this.provider;
    }

    @Override
    protected Optional<QueryNodeListRater> getNodeListRater(QuerySegment<EntityQueryNode> segment) {
        return Optional.absent();
    }
}

