/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.accumulo.temporal;

import java.io.IOException;
import java.nio.charset.CharacterCodingException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.MultiTableBatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;
import org.apache.rya.accumulo.experimental.AbstractAccumuloIndexer;
import org.apache.rya.api.RdfCloudTripleStoreConfiguration;
import org.apache.rya.api.client.RyaClientException;
import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.api.resolver.RyaToRdfConversions;
import org.apache.rya.indexing.KeyParts;
import org.apache.rya.indexing.StatementConstraints;
import org.apache.rya.indexing.StatementSerializer;
import org.apache.rya.indexing.TemporalIndexer;
import org.apache.rya.indexing.TemporalInstant;
import org.apache.rya.indexing.TemporalInstantRfc3339;
import org.apache.rya.indexing.TemporalInterval;
import org.apache.rya.indexing.accumulo.ConfigUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.joda.time.DateTime;

public class AccumuloTemporalIndexer
extends AbstractAccumuloIndexer
implements TemporalIndexer {
    private static final String TABLE_SUFFIX = "temporal";
    private static final Logger logger = Logger.getLogger(AccumuloTemporalIndexer.class);
    private static final String CF_INTERVAL = "interval";
    private Configuration conf;
    private MultiTableBatchWriter mtbw;
    private BatchWriter temporalIndexBatchWriter;
    private Set<IRI> validPredicates;
    private String temporalIndexTableName;
    private boolean isInit = false;

    public void init() {
        if (!this.isInit) {
            try {
                this.initReadWrite();
                this.isInit = true;
            }
            catch (AccumuloException | AccumuloSecurityException | TableExistsException | TableNotFoundException | RyaClientException e) {
                logger.error((Object)"Unable to initialize index.  Throwing Runtime Exception. ", e);
                throw new RuntimeException(e);
            }
        }
    }

    private void initReadWrite() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TableExistsException, RyaClientException {
        if (this.mtbw == null) {
            throw new RyaClientException("Failed to initialize temporal index, setMultiTableBatchWriter() was not set.");
        }
        if (this.conf == null) {
            throw new RyaClientException("Failed to initialize temporal index, setConf() was not set.");
        }
        if (this.temporalIndexTableName == null) {
            throw new RyaClientException("Failed to set temporalIndexTableName==null.");
        }
        Boolean isCreated = ConfigUtils.createTableIfNotExists(this.conf, this.temporalIndexTableName);
        if (isCreated.booleanValue()) {
            logger.info((Object)("First run, created temporal index table: " + this.temporalIndexTableName));
        }
        this.temporalIndexBatchWriter = this.mtbw.getBatchWriter(this.temporalIndexTableName);
    }

    private void initReadOnly() {
        if (this.conf == null) {
            throw new Error("Failed to initialize temporal index, setConf() was not set.");
        }
        this.temporalIndexTableName = this.getTableName();
        this.validPredicates = ConfigUtils.getTemporalPredicates(this.conf);
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.initReadOnly();
    }

    public Configuration getConf() {
        return this.conf;
    }

    private void storeStatement(Statement statement) throws IOException, IllegalArgumentException {
        boolean isValidPredicate;
        Objects.requireNonNull(this.temporalIndexBatchWriter, "This is not initialized for writing.  Must call setMultiTableBatchWriter() and init().");
        boolean bl = isValidPredicate = this.validPredicates == null || this.validPredicates.isEmpty() || this.validPredicates.contains(statement.getPredicate());
        if (!isValidPredicate || !(statement.getObject() instanceof Literal)) {
            return;
        }
        DateTime[] indexDateTimes = new DateTime[2];
        this.extractDateTime(statement, indexDateTimes);
        if (indexDateTimes[0] == null) {
            return;
        }
        if (!this.isInit) {
            throw new RuntimeException("Method .init() was not called (or failed) before attempting to store statements.");
        }
        try {
            if (indexDateTimes[1] != null) {
                TemporalInterval interval = new TemporalInterval(new TemporalInstantRfc3339(indexDateTimes[0]), new TemporalInstantRfc3339(indexDateTimes[1]));
                this.addInterval(this.temporalIndexBatchWriter, interval, statement);
            } else {
                TemporalInstantRfc3339 instant = new TemporalInstantRfc3339(indexDateTimes[0]);
                this.addInstant(this.temporalIndexBatchWriter, instant, statement);
            }
        }
        catch (MutationsRejectedException e) {
            throw new IOException("While adding interval/instant for statement =" + statement, e);
        }
    }

    public void storeStatement(RyaStatement statement) throws IllegalArgumentException, IOException {
        this.storeStatement(RyaToRdfConversions.convertStatement((RyaStatement)statement));
    }

    private void extractDateTime(Statement statement, DateTime[] outputDateTimes) {
        if (!(statement.getObject() instanceof Literal)) {
            throw new RuntimeException("Statement's object must be a literal: " + statement);
        }
        String logThis = null;
        Literal literalValue = (Literal)statement.getObject();
        Matcher matcher = Pattern.compile("\\[(.*)\\,(.*)\\].*").matcher(literalValue.stringValue());
        if (matcher.find()) {
            try {
                outputDateTimes[0] = new DateTime((Object)matcher.group(1));
                outputDateTimes[1] = new DateTime((Object)matcher.group(2));
                return;
            }
            catch (IllegalArgumentException e) {
                logThis = e.getMessage() + " " + logThis;
                outputDateTimes[0] = null;
                outputDateTimes[1] = null;
            }
        }
        try {
            XMLGregorianCalendar calendarValue = literalValue.calendarValue();
            outputDateTimes[0] = new DateTime((Object)calendarValue.toGregorianCalendar());
            outputDateTimes[1] = null;
            return;
        }
        catch (IllegalArgumentException e) {
            logThis = e.getMessage();
            try {
                outputDateTimes[0] = DateTime.parse((String)literalValue.stringValue());
                outputDateTimes[1] = null;
                return;
            }
            catch (IllegalArgumentException e2) {
                logThis = e2.getMessage() + " " + logThis;
                logger.warn((Object)("TemporalIndexer is unable to parse the date/time from statement=" + statement.toString() + " " + logThis));
                return;
            }
        }
    }

    public void removeInterval(BatchWriter writer, TemporalInterval interval, Statement statement) throws MutationsRejectedException {
        Text cf = new Text(StatementSerializer.writeContext(statement));
        Text cqBegin = new Text("begin");
        Text cqEnd = new Text("end");
        Text keyText = new Text(interval.getAsKeyBeginning());
        KeyParts.appendUniqueness(statement, keyText);
        Mutation m = new Mutation(keyText);
        m.putDelete(cf, cqBegin);
        writer.addMutation(m);
        keyText = new Text(interval.getAsKeyEnd());
        KeyParts.appendUniqueness(statement, keyText);
        m = new Mutation(keyText);
        m.putDelete(cf, cqEnd);
        writer.addMutation(m);
    }

    public void removeInstant(BatchWriter writer, TemporalInstant instant, Statement statement) throws MutationsRejectedException {
        KeyParts keyParts = new KeyParts(statement, instant);
        for (KeyParts k : keyParts) {
            Mutation m = new Mutation(k.getStoreKey());
            m.putDelete(k.cf, k.cq);
            writer.addMutation(m);
        }
    }

    public void addInterval(BatchWriter writer, TemporalInterval interval, Statement statement) throws MutationsRejectedException {
        Value statementValue = new Value(StringUtils.getBytesUtf8((String)StatementSerializer.writeStatement(statement)));
        Text cf = new Text(StatementSerializer.writeContext(statement));
        Text cqBegin = new Text("begin");
        Text cqEnd = new Text("end");
        Text keyText = new Text(interval.getAsKeyBeginning());
        KeyParts.appendUniqueness(statement, keyText);
        Mutation m = new Mutation(keyText);
        m.put(cf, cqBegin, statementValue);
        writer.addMutation(m);
        keyText = new Text(interval.getAsKeyEnd());
        KeyParts.appendUniqueness(statement, keyText);
        m = new Mutation(keyText);
        m.put(cf, cqEnd, new Value(statementValue));
        writer.addMutation(m);
    }

    public void addInstant(BatchWriter writer, TemporalInstant instant, Statement statement) throws MutationsRejectedException {
        KeyParts keyParts = new KeyParts(statement, instant);
        for (KeyParts k : keyParts) {
            Mutation m = new Mutation(k.getStoreKey());
            m.put(k.cf, k.cq, k.getValue());
            writer.addMutation(m);
        }
    }

    private Scanner getScanner() throws QueryEvaluationException {
        String whileDoing = "While creating a scanner for a temporal query. table name=" + this.temporalIndexTableName;
        Scanner scanner = null;
        try {
            scanner = ConfigUtils.createScanner(this.temporalIndexTableName, this.conf);
        }
        catch (AccumuloException e) {
            logger.error((Object)whileDoing, (Throwable)e);
            throw new QueryEvaluationException(whileDoing, (Throwable)e);
        }
        catch (AccumuloSecurityException e) {
            throw new QueryEvaluationException(whileDoing, (Throwable)e);
        }
        catch (TableNotFoundException e) {
            logger.error((Object)whileDoing, (Throwable)e);
            throw new QueryEvaluationException(whileDoing + " The temporal index table should have been created by this constructor, if found missing.", (Throwable)e);
        }
        return scanner;
    }

    private BatchScanner getBatchScanner() throws QueryEvaluationException {
        String whileDoing = "While creating a Batch scanner for a temporal query. table name=" + this.temporalIndexTableName;
        try {
            return ConfigUtils.createBatchScanner(this.temporalIndexTableName, this.conf);
        }
        catch (AccumuloException e) {
            logger.error((Object)whileDoing, (Throwable)e);
            throw new QueryEvaluationException(whileDoing, (Throwable)e);
        }
        catch (AccumuloSecurityException e) {
            throw new QueryEvaluationException(whileDoing, (Throwable)e);
        }
        catch (TableNotFoundException e) {
            logger.error((Object)whileDoing, (Throwable)e);
            throw new QueryEvaluationException(whileDoing + " The temporal index table should have been created by this constructor, if found missing. ", (Throwable)e);
        }
    }

    @Override
    public CloseableIteration<Statement, QueryEvaluationException> queryInstantEqualsInstant(TemporalInstant queryInstant, StatementConstraints constraints) throws QueryEvaluationException {
        Query query = new Query(){

            @Override
            public Range getRange(KeyParts keyParts) {
                return Range.prefix((Text)keyParts.getQueryKey());
            }
        };
        ScannerBase scanner = query.doQuery(queryInstant, constraints);
        return AccumuloTemporalIndexer.getContextIteratorWrapper(scanner, constraints.getContext());
    }

    @Override
    public CloseableIteration<Statement, QueryEvaluationException> queryInstantBeforeInstant(TemporalInstant queryInstant, StatementConstraints constraints) throws QueryEvaluationException {
        Query query = new Query(){

            @Override
            public Range getRange(KeyParts keyParts) {
                Text start = null;
                start = keyParts.constraintPrefix != null ? keyParts.constraintPrefix : new Text(KeyParts.HASH_PREFIX_FOLLOWING);
                Text endAt = keyParts.getQueryKey();
                return new Range(start, true, endAt, false);
            }
        };
        ScannerBase scanner = query.doQuery(queryInstant, constraints);
        return AccumuloTemporalIndexer.getContextIteratorWrapper(scanner, constraints.getContext());
    }

    @Override
    public CloseableIteration<Statement, QueryEvaluationException> queryInstantAfterInstant(TemporalInstant queryInstant, StatementConstraints constraints) throws QueryEvaluationException {
        Query query = new Query(){

            @Override
            public Range getRange(KeyParts keyParts) {
                Text start = Range.followingPrefix((Text)keyParts.getQueryKey());
                Text endAt = null;
                if (keyParts.constraintPrefix != null) {
                    endAt = Range.followingPrefix((Text)keyParts.constraintPrefix);
                }
                return new Range(start, true, endAt, false);
            }
        };
        ScannerBase scanner = query.doQuery(queryInstant, constraints);
        return AccumuloTemporalIndexer.getContextIteratorWrapper(scanner, constraints.getContext());
    }

    @Override
    public CloseableIteration<Statement, QueryEvaluationException> queryInstantBeforeInterval(TemporalInterval givenInterval, StatementConstraints contraints) throws QueryEvaluationException {
        return this.queryInstantBeforeInstant(givenInterval.getHasBeginning(), contraints);
    }

    @Override
    public CloseableIteration<Statement, QueryEvaluationException> queryInstantAfterInterval(TemporalInterval givenInterval, StatementConstraints contraints) throws QueryEvaluationException {
        return this.queryInstantAfterInstant(givenInterval.getHasEnd(), contraints);
    }

    @Override
    public CloseableIteration<Statement, QueryEvaluationException> queryInstantInsideInterval(TemporalInterval queryInterval, StatementConstraints constraints) throws QueryEvaluationException {
        final TemporalInterval theQueryInterval = queryInterval;
        Query query = new Query(){
            private final TemporalInterval queryInterval;
            {
                this.queryInterval = theQueryInterval;
            }

            @Override
            public Range getRange(KeyParts keyParts) {
                Text start = Range.followingPrefix((Text)new Text(keyParts.getQueryKey(this.queryInterval.getHasBeginning())));
                Text endAt = new Text(keyParts.getQueryKey(this.queryInterval.getHasEnd()));
                return new Range(start, false, endAt, false);
            }
        };
        ScannerBase scanner = query.doQuery(queryInterval.getHasBeginning(), constraints);
        return AccumuloTemporalIndexer.getContextIteratorWrapper(scanner, constraints.getContext());
    }

    @Override
    public CloseableIteration<Statement, QueryEvaluationException> queryInstantHasBeginningInterval(TemporalInterval queryInterval, StatementConstraints contraints) throws QueryEvaluationException {
        return this.queryInstantEqualsInstant(queryInterval.getHasBeginning(), contraints);
    }

    @Override
    public CloseableIteration<Statement, QueryEvaluationException> queryInstantHasEndInterval(TemporalInterval queryInterval, StatementConstraints contraints) throws QueryEvaluationException {
        return this.queryInstantEqualsInstant(queryInterval.getHasEnd(), contraints);
    }

    @Override
    public CloseableIteration<Statement, QueryEvaluationException> queryIntervalEquals(TemporalInterval query, StatementConstraints contraints) throws QueryEvaluationException {
        Scanner scanner = this.getScanner();
        if (scanner != null) {
            Range range = Range.prefix((Text)new Text(query.getAsKeyBeginning()));
            scanner.setRange(range);
            if (contraints.hasContext()) {
                scanner.fetchColumn(new Text(contraints.getContext().toString()), new Text("begin"));
            } else {
                scanner.fetchColumn(new Text(""), new Text("begin"));
            }
        }
        return AccumuloTemporalIndexer.getIteratorWrapper((ScannerBase)scanner);
    }

    @Override
    public CloseableIteration<Statement, QueryEvaluationException> queryIntervalBefore(TemporalInterval queryInterval, StatementConstraints constraints) throws QueryEvaluationException {
        Scanner scanner = this.getScanner();
        if (scanner != null) {
            Range range = new Range(null, false, new Key(new Text(queryInterval.getHasBeginning().getAsKeyBytes())), false);
            scanner.setRange(range);
            if (constraints.hasContext()) {
                scanner.fetchColumn(new Text(constraints.getContext().toString()), new Text("end"));
            } else {
                scanner.fetchColumn(new Text(""), new Text("end"));
            }
        }
        return AccumuloTemporalIndexer.getIteratorWrapper((ScannerBase)scanner);
    }

    @Override
    public CloseableIteration<Statement, QueryEvaluationException> queryIntervalAfter(TemporalInterval queryInterval, StatementConstraints constraints) throws QueryEvaluationException {
        Scanner scanner = this.getScanner();
        if (scanner != null) {
            Range range = new Range(new Key(Range.followingPrefix((Text)new Text(queryInterval.getHasEnd().getAsKeyBytes()))), false, null, true);
            scanner.setRange(range);
            if (constraints.hasContext()) {
                scanner.fetchColumn(new Text(constraints.getContext().toString()), new Text("begin"));
            } else {
                scanner.fetchColumn(new Text(""), new Text("begin"));
            }
        }
        return AccumuloTemporalIndexer.getIteratorWrapper((ScannerBase)scanner);
    }

    private static CloseableIteration<Statement, QueryEvaluationException> getIteratorWrapper(final ScannerBase scanner) {
        final Iterator i = scanner.iterator();
        return new CloseableIteration<Statement, QueryEvaluationException>(){

            public boolean hasNext() {
                return i.hasNext();
            }

            public Statement next() throws QueryEvaluationException {
                Map.Entry entry = (Map.Entry)i.next();
                Value v = (Value)entry.getValue();
                try {
                    String dataString = Text.decode((byte[])v.get(), (int)0, (int)v.getSize());
                    Statement s = StatementSerializer.readStatement(dataString);
                    return s;
                }
                catch (CharacterCodingException e) {
                    logger.error((Object)("Error decoding value=" + Arrays.toString(v.get())), (Throwable)e);
                    throw new QueryEvaluationException((Throwable)e);
                }
                catch (IOException e) {
                    logger.error((Object)("Error de-serializing statement, string=" + v.get()), (Throwable)e);
                    throw new QueryEvaluationException((Throwable)e);
                }
            }

            public void remove() {
                throw new UnsupportedOperationException("Remove not implemented");
            }

            public void close() throws QueryEvaluationException {
                scanner.close();
            }
        };
    }

    private static CloseableIteration<Statement, QueryEvaluationException> getConstrainedIteratorWrapper(Scanner scanner, final StatementConstraints constraints) {
        if (!(constraints.hasContext() || constraints.hasSubject() || constraints.hasPredicates())) {
            return AccumuloTemporalIndexer.getIteratorWrapper((ScannerBase)scanner);
        }
        return new ConstrainedIteratorWrapper((ScannerBase)scanner){

            @Override
            public boolean allowedBy(Statement statement) {
                return AccumuloTemporalIndexer.allowedByConstraints(statement, constraints);
            }
        };
    }

    private static CloseableIteration<Statement, QueryEvaluationException> getContextIteratorWrapper(ScannerBase scanner, final Resource context) {
        if (context == null) {
            return AccumuloTemporalIndexer.getIteratorWrapper(scanner);
        }
        return new ConstrainedIteratorWrapper(scanner){

            @Override
            public boolean allowedBy(Statement statement) {
                return AccumuloTemporalIndexer.allowedByContext(statement, context);
            }
        };
    }

    protected static boolean allowedByConstraints(Statement statement, StatementConstraints constraints) {
        if (constraints.hasSubject() && !constraints.getSubject().toString().equals(statement.getSubject().toString())) {
            System.out.println("Constrain subject: " + constraints.getSubject() + " != " + statement.getSubject());
            return false;
        }
        if (!AccumuloTemporalIndexer.allowedByContext(statement, constraints.getContext())) {
            return false;
        }
        if (constraints.hasPredicates() && !constraints.getPredicates().contains(statement.getPredicate())) {
            return false;
        }
        System.out.println("allow statement: " + statement.toString());
        return true;
    }

    protected static boolean allowedByContext(Statement statement, Resource context) {
        return context == null || context.equals(statement.getContext());
    }

    public Set<IRI> getIndexablePredicates() {
        return this.validPredicates;
    }

    public void flush() throws IOException {
        try {
            this.mtbw.flush();
        }
        catch (MutationsRejectedException e) {
            String msg = "Error while flushing the batch writer.";
            logger.error((Object)"Error while flushing the batch writer.", (Throwable)e);
            throw new IOException("Error while flushing the batch writer.", e);
        }
    }

    public void close() throws IOException {
        try {
            if (this.mtbw != null) {
                this.mtbw.close();
            }
        }
        catch (MutationsRejectedException e) {
            String msg = "Error while closing the batch writer.";
            logger.error((Object)"Error while closing the batch writer.", (Throwable)e);
            throw new IOException("Error while closing the batch writer.", e);
        }
    }

    public String getTableName() {
        return AccumuloTemporalIndexer.makeTableName(ConfigUtils.getTablePrefix(this.conf));
    }

    public static String makeTableName(String ryaInstanceName) {
        Objects.requireNonNull(ryaInstanceName);
        return ryaInstanceName + TABLE_SUFFIX;
    }

    private void deleteStatement(Statement statement) throws IOException, IllegalArgumentException {
        boolean isValidPredicate;
        Objects.requireNonNull(this.temporalIndexBatchWriter, "This is not initialized for writing.  Must call setMultiTableBatchWriter() and init().");
        boolean bl = isValidPredicate = this.validPredicates.isEmpty() || this.validPredicates.contains(statement.getPredicate());
        if (!isValidPredicate || !(statement.getObject() instanceof Literal)) {
            return;
        }
        DateTime[] indexDateTimes = new DateTime[2];
        this.extractDateTime(statement, indexDateTimes);
        if (indexDateTimes[0] == null) {
            return;
        }
        try {
            if (indexDateTimes[1] != null) {
                TemporalInterval interval = new TemporalInterval(new TemporalInstantRfc3339(indexDateTimes[0]), new TemporalInstantRfc3339(indexDateTimes[1]));
                this.removeInterval(this.temporalIndexBatchWriter, interval, statement);
            } else {
                TemporalInstantRfc3339 instant = new TemporalInstantRfc3339(indexDateTimes[0]);
                this.removeInstant(this.temporalIndexBatchWriter, instant, statement);
            }
        }
        catch (MutationsRejectedException e) {
            throw new IOException("While adding interval/instant for statement =" + statement, e);
        }
    }

    public void deleteStatement(RyaStatement statement) throws IllegalArgumentException, IOException {
        this.deleteStatement(RyaToRdfConversions.convertStatement((RyaStatement)statement));
    }

    public void setConnector(Connector connector) {
    }

    public void destroy() {
    }

    public void purge(RdfCloudTripleStoreConfiguration configuration) {
    }

    public void dropAndDestroy() {
    }

    public void setMultiTableBatchWriter(MultiTableBatchWriter writer) throws IOException {
        this.mtbw = writer;
    }

    static abstract class ConstrainedIteratorWrapper
    implements CloseableIteration<Statement, QueryEvaluationException> {
        private Statement nextStatement = null;
        private boolean isInitialized = false;
        private final Iterator<Map.Entry<Key, Value>> i;
        private final ScannerBase scanner;

        ConstrainedIteratorWrapper(ScannerBase scanner) {
            this.scanner = scanner;
            this.i = scanner.iterator();
        }

        public boolean hasNext() throws QueryEvaluationException {
            if (!this.isInitialized) {
                this.internalGetNext();
            }
            return this.nextStatement != null;
        }

        public Statement next() throws QueryEvaluationException {
            if (this.nextStatement == null) {
                if (!this.isInitialized) {
                    this.internalGetNext();
                }
                if (this.nextStatement == null) {
                    throw new NoSuchElementException();
                }
            }
            Statement thisStatement = this.nextStatement;
            this.internalGetNext();
            return thisStatement;
        }

        private void internalGetNext() throws QueryEvaluationException {
            this.isInitialized = true;
            this.nextStatement = null;
            Statement statement = null;
            while (this.i.hasNext()) {
                Map.Entry<Key, Value> entry = this.i.next();
                Value v = entry.getValue();
                try {
                    String dataString = Text.decode((byte[])v.get(), (int)0, (int)v.getSize());
                    statement = StatementSerializer.readStatement(dataString);
                }
                catch (CharacterCodingException e) {
                    logger.error((Object)("Error decoding value=" + Arrays.toString(v.get())), (Throwable)e);
                    throw new QueryEvaluationException((Throwable)e);
                }
                catch (IOException e) {
                    logger.error((Object)("Error de-serializing statement, string=" + v.get()), (Throwable)e);
                    throw new QueryEvaluationException((Throwable)e);
                }
                if (!this.allowedBy(statement)) continue;
                this.nextStatement = statement;
                return;
            }
        }

        public abstract boolean allowedBy(Statement var1);

        public void remove() {
            throw new UnsupportedOperationException("Remove not implemented");
        }

        public void close() throws QueryEvaluationException {
            this.scanner.close();
        }
    }

    abstract class Query {
        Query() {
        }

        protected abstract Range getRange(KeyParts var1);

        public ScannerBase doQuery(TemporalInstant queryInstant, StatementConstraints constraints) throws QueryEvaluationException {
            List<KeyParts> keyParts = KeyParts.keyPartsForQuery(queryInstant, constraints);
            Object scanner = null;
            scanner = keyParts.size() > 1 ? AccumuloTemporalIndexer.this.getBatchScanner() : AccumuloTemporalIndexer.this.getScanner();
            HashSet<Range> ranges = new HashSet<Range>();
            KeyParts lastKeyParts = null;
            Range range = null;
            for (KeyParts thisKeyParts : keyParts) {
                range = this.getRange(thisKeyParts);
                ranges.add(range);
                lastKeyParts = thisKeyParts;
            }
            if (lastKeyParts == null || scanner == null) {
                throw new NullPointerException("lastkeyParts or scanner is null, impossible! keyParts.size()= " + keyParts.size() + " scanner= " + scanner);
            }
            scanner.fetchColumn(new Text(lastKeyParts.cf), new Text(lastKeyParts.cq));
            if (scanner instanceof BatchScanner) {
                scanner.setRanges(ranges);
            } else if (range != null) {
                ((Scanner)scanner).setRange(range);
            }
            return scanner;
        }
    }
}

