/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.accumulo.freetext.query;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.rya.indexing.accumulo.freetext.query.ASTExpression;
import org.apache.rya.indexing.accumulo.freetext.query.ASTTerm;
import org.apache.rya.indexing.accumulo.freetext.query.Node;
import org.apache.rya.indexing.accumulo.freetext.query.SimpleNode;

public class ASTNodeUtils {
    public static String serializeExpression(Node s) {
        if (s instanceof ASTTerm) {
            ASTTerm a = (ASTTerm)s;
            return (a.isNotFlag() ? "!" : "") + " " + a.getTerm();
        }
        String prefix = "";
        String suffix = "";
        String join = " ";
        if (s instanceof ASTExpression) {
            ASTExpression a = (ASTExpression)s;
            prefix = (a.isNotFlag() ? "!" : "") + "(";
            suffix = ")";
            join = " " + a.getType() + " ";
        }
        ArrayList<String> children = new ArrayList<String>();
        for (int i = 0; i < s.jjtGetNumChildren(); ++i) {
            children.add(ASTNodeUtils.serializeExpression(s.jjtGetChild(i)));
        }
        return prefix + StringUtils.join(children, (String)join) + suffix;
    }

    public static int termCount(Node node) {
        if (node instanceof SimpleNode) {
            int count = 0;
            for (SimpleNode n : ASTNodeUtils.getNodeIterator((SimpleNode)node)) {
                count += ASTNodeUtils.termCount(n);
            }
            return count;
        }
        if (node instanceof ASTTerm) {
            return 1;
        }
        throw new IllegalArgumentException("Node is of unknown type: " + node.getClass().getName());
    }

    public static void pushChild(SimpleNode parent, SimpleNode child) {
        int parentSize = parent.jjtGetNumChildren();
        parent.jjtAddChild(null, parentSize);
        Node currentHeadChild = parent.jjtGetChild(0);
        parent.jjtAddChild(child, 0);
        if (currentHeadChild != null) {
            parent.jjtAddChild(currentHeadChild, parentSize);
        }
        child.jjtSetParent(parent);
    }

    public static int getChildIndex(SimpleNode parent, SimpleNode child) {
        int parentSize = parent.jjtGetNumChildren();
        for (int i = 0; i < parentSize; ++i) {
            if (!child.equals(parent.jjtGetChild(i))) continue;
            return i;
        }
        return -1;
    }

    public static boolean allChildrenAreNot(ASTExpression node) {
        for (SimpleNode child : ASTNodeUtils.getNodeIterator(node)) {
            if (ASTNodeUtils.isNotFlag(child)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotFlag(Node node) {
        if (node instanceof ASTExpression) {
            return ((ASTExpression)node).isNotFlag();
        }
        if (node instanceof ASTTerm) {
            return ((ASTTerm)node).isNotFlag();
        }
        throw new IllegalArgumentException("Node is of unknown type: " + node.getClass().getName());
    }

    public static Iterable<SimpleNode> getNodeIterator(final SimpleNode n) {
        return new Iterable<SimpleNode>(){

            @Override
            public Iterator<SimpleNode> iterator() {
                return new Iterator<SimpleNode>(){
                    int pointer = 0;

                    @Override
                    public boolean hasNext() {
                        return this.pointer < n.jjtGetNumChildren();
                    }

                    @Override
                    public SimpleNode next() {
                        Node rtn = n.jjtGetChild(this.pointer);
                        ++this.pointer;
                        return (SimpleNode)rtn;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static void swapChildren(ASTExpression parent, int childOneIndex, int childTwoIndex) {
        Validate.isTrue((childOneIndex > -1 && childOneIndex < parent.jjtGetNumChildren() ? 1 : 0) != 0);
        Validate.isTrue((childTwoIndex > -1 && childTwoIndex < parent.jjtGetNumChildren() ? 1 : 0) != 0);
        Node childOne = parent.jjtGetChild(childOneIndex);
        Node childTwo = parent.jjtGetChild(childTwoIndex);
        parent.jjtAddChild(childOne, childTwoIndex);
        parent.jjtAddChild(childTwo, childOneIndex);
    }

    public static int findFirstNonNotChild(ASTExpression expression) {
        for (int i = 0; i < expression.jjtGetNumChildren(); ++i) {
            if (ASTNodeUtils.isNotFlag(expression.jjtGetChild(i))) continue;
            return i;
        }
        return -1;
    }
}

