/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.accumulo.freetext.iterators;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.OptionDescriber;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.system.MultiIterator;
import org.apache.commons.lang.Validate;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;
import org.apache.rya.indexing.accumulo.freetext.ColumnPrefixes;
import org.apache.rya.indexing.accumulo.freetext.iterators.AndingIterator;
import org.apache.rya.indexing.accumulo.freetext.query.ASTExpression;
import org.apache.rya.indexing.accumulo.freetext.query.ASTNodeUtils;
import org.apache.rya.indexing.accumulo.freetext.query.ASTTerm;
import org.apache.rya.indexing.accumulo.freetext.query.ParseException;
import org.apache.rya.indexing.accumulo.freetext.query.QueryParser;
import org.apache.rya.indexing.accumulo.freetext.query.SimpleNode;
import org.apache.rya.indexing.accumulo.freetext.query.TokenMgrError;

public class BooleanTreeIterator
implements SortedKeyValueIterator<Key, Value>,
OptionDescriber {
    private static Logger logger = Logger.getLogger(BooleanTreeIterator.class);
    private static String queryOptionName = "query";
    private SortedKeyValueIterator<Key, Value> iter;
    private SortedKeyValueIterator<Key, Value> docSource;

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        SimpleNode root;
        String query = options.get(queryOptionName);
        try {
            root = QueryParser.parse(query);
        }
        catch (ParseException e) {
            logger.error((Object)("ParseException encountered while parsing: " + query), (Throwable)e);
            throw new IOException(e);
        }
        catch (TokenMgrError e) {
            logger.error((Object)("TokenMgrError encountered while parsing: " + query), (Throwable)e);
            throw new IOException(e);
        }
        this.docSource = source.deepCopy(env);
        this.iter = this.createIterator((SimpleNode)root.jjtGetChild(0), source, env);
    }

    private SortedKeyValueIterator<Key, Value> createIterator(SimpleNode root, SortedKeyValueIterator<Key, Value> source, IteratorEnvironment env) {
        if (root instanceof ASTTerm) {
            ASTExpression expression = new ASTExpression(1);
            expression.setNotFlag(false);
            expression.setType("AND");
            ASTNodeUtils.pushChild(expression, root);
            root.jjtSetParent(expression);
            root = expression;
        }
        BooleanTreeIterator.preProcessTree(root);
        return this.createIteratorRecursive(root, source, env);
    }

    private SortedKeyValueIterator<Key, Value> createIteratorRecursive(SimpleNode node, SortedKeyValueIterator<Key, Value> source, IteratorEnvironment env) {
        Validate.isTrue((boolean)(node instanceof ASTExpression), (String)("node must be of type ASTExpression.  Node is instance of " + node.getClass().getName()));
        ASTExpression expression = (ASTExpression)node;
        if (expression.getType().equals("AND")) {
            return this.getAndIterator(node, source, env);
        }
        if (expression.getType().equals("OR")) {
            return this.getOrIterator(node, source, env);
        }
        throw new IllegalArgumentException("Expression is of unknown type: " + expression.getType());
    }

    private MultiIterator getOrIterator(SimpleNode node, SortedKeyValueIterator<Key, Value> source, IteratorEnvironment env) {
        ArrayList<SortedKeyValueIterator<Key, Value>> iters = new ArrayList<SortedKeyValueIterator<Key, Value>>();
        for (SimpleNode n : ASTNodeUtils.getNodeIterator(node)) {
            if (n instanceof ASTExpression) {
                iters.add(this.createIteratorRecursive(n, source, env));
                continue;
            }
            if (n instanceof ASTTerm) {
                iters.add(this.getSimpleAndingIterator((ASTTerm)n, source, env));
                continue;
            }
            throw new IllegalArgumentException("Node is of unknown type: " + n.getClass().getName());
        }
        return new MultiIterator(iters, new Range());
    }

    private AndingIterator getAndIterator(SimpleNode node, SortedKeyValueIterator<Key, Value> source, IteratorEnvironment env) {
        AndingIterator anding = new AndingIterator();
        for (SimpleNode n : ASTNodeUtils.getNodeIterator(node)) {
            boolean isNotFlag = ASTNodeUtils.isNotFlag(n);
            if (n instanceof ASTExpression) {
                anding.addSource(this.createIteratorRecursive(n, source, env), env, null, isNotFlag);
                continue;
            }
            if (n instanceof ASTTerm) {
                ASTTerm term = (ASTTerm)n;
                anding.addSource(source, env, BooleanTreeIterator.getTermColFam(term), isNotFlag);
                continue;
            }
            throw new IllegalArgumentException("Node is of unknown type: " + n.getClass().getName());
        }
        return anding;
    }

    private static Text getTermColFam(ASTTerm termnode) {
        String term = termnode.getTerm();
        if (term == null) {
            return ColumnPrefixes.DOCS_CF_PREFIX;
        }
        if (term.contains("\u0000")) {
            return new Text(term);
        }
        return ColumnPrefixes.getTermColFam(term.toLowerCase());
    }

    private AndingIterator getSimpleAndingIterator(ASTTerm node, SortedKeyValueIterator<Key, Value> source, IteratorEnvironment env) {
        Validate.isTrue((!node.isNotFlag() ? 1 : 0) != 0, (String)"Simple Anding node must not have \"not\" flag set");
        AndingIterator anding = new AndingIterator();
        anding.addSource(source, env, BooleanTreeIterator.getTermColFam(node), false);
        return anding;
    }

    public static void preProcessTree(SimpleNode s) {
        for (SimpleNode child : ASTNodeUtils.getNodeIterator(s)) {
            BooleanTreeIterator.preProcessTree(child);
        }
        if (s instanceof ASTExpression) {
            ASTExpression expression = (ASTExpression)s;
            if (expression.getType().equals("AND")) {
                if (ASTNodeUtils.allChildrenAreNot(expression)) {
                    ASTTerm allDocsTerm = BooleanTreeIterator.createAllDocTermNode();
                    ASTNodeUtils.pushChild(expression, allDocsTerm);
                } else if (ASTNodeUtils.isNotFlag(expression.jjtGetChild(0))) {
                    int firstNonNotChild = ASTNodeUtils.findFirstNonNotChild(expression);
                    ASTNodeUtils.swapChildren(expression, 0, firstNonNotChild);
                }
            }
            if (expression.getType().equals("OR")) {
                for (int i = 0; i < expression.jjtGetNumChildren(); ++i) {
                    SimpleNode child = (SimpleNode)expression.jjtGetChild(i);
                    if (!ASTNodeUtils.isNotFlag(child)) continue;
                    ASTExpression newExpression = new ASTExpression(1);
                    newExpression.setNotFlag(false);
                    newExpression.setType("AND");
                    ASTNodeUtils.pushChild(newExpression, child);
                    ASTNodeUtils.pushChild(newExpression, BooleanTreeIterator.createAllDocTermNode());
                    newExpression.jjtSetParent(expression);
                    expression.jjtAddChild(newExpression, i);
                }
            }
        }
    }

    public static ASTTerm createAllDocTermNode() {
        ASTTerm t = new ASTTerm(3);
        t.setNotFlag(false);
        t.setType("TERM");
        t.setTerm(null);
        return t;
    }

    public boolean hasTop() {
        return this.iter.hasTop();
    }

    public void next() throws IOException {
        this.iter.next();
        if (this.iter.hasTop()) {
            this.seekDocSource((Key)this.iter.getTopKey());
        }
    }

    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        this.iter.seek(range, columnFamilies, inclusive);
        if (this.iter.hasTop()) {
            this.seekDocSource((Key)this.iter.getTopKey());
        }
    }

    private void seekDocSource(Key key) throws IOException {
        Key docKey = new Key(key.getRow(), ColumnPrefixes.DOCS_CF_PREFIX, key.getColumnQualifier());
        this.docSource.seek(new Range(docKey, true, null, false), Collections.emptyList(), false);
    }

    public Key getTopKey() {
        return (Key)this.iter.getTopKey();
    }

    public Value getTopValue() {
        if (!this.iter.hasTop()) {
            throw new NoSuchElementException();
        }
        return (Value)this.docSource.getTopValue();
    }

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        throw new UnsupportedOperationException();
    }

    public static void setQuery(IteratorSetting cfg, String query) {
        cfg.addOption(queryOptionName, query);
    }

    public OptionDescriber.IteratorOptions describeOptions() {
        return new OptionDescriber.IteratorOptions("FreeTextBooleanTree", "Perform a FreeText Query on properly formated table", Collections.singletonMap(queryOptionName, "the free text query"), null);
    }

    public boolean validateOptions(Map<String, String> options) {
        String q = options.get(queryOptionName);
        if (q == null || q.isEmpty()) {
            throw new IllegalArgumentException(queryOptionName + " must not be empty");
        }
        return true;
    }
}

