/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.accumulo.freetext.iterators;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;

public class AndingIterator
implements SortedKeyValueIterator<Key, Value> {
    protected Text nullText = new Text();
    protected static final Logger log = Logger.getLogger(AndingIterator.class);
    TermSource[] sources;
    int sourcesCount = 0;
    Range overallRange;
    protected Text currentPartition = null;
    protected Text currentDocID = new Text(emptyByteArray);
    static final byte[] emptyByteArray = new byte[0];
    protected Key topKey = null;
    protected Value value = new Value(emptyByteArray);
    private static final String columnFamiliesOptionName = "columnFamilies";
    private static final String notFlagOptionName = "notFlag";

    protected Text getPartition(Key key) {
        return key.getRow();
    }

    protected Text getTerm(Key key) {
        return key.getColumnFamily();
    }

    protected Text getDocID(Key key) {
        return key.getColumnQualifier();
    }

    protected Key buildKey(Text partition, Text term) {
        return new Key(partition, term == null ? this.nullText : term);
    }

    protected Key buildKey(Text partition, Text term, Text docID) {
        return new Key(partition, term == null ? this.nullText : term, docID);
    }

    protected Key buildFollowingPartitionKey(Key key) {
        return key.followingKey(PartialKey.ROW);
    }

    public AndingIterator() {
    }

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        return new AndingIterator(this, env);
    }

    private AndingIterator(AndingIterator other, IteratorEnvironment env) {
        if (other.sources != null) {
            this.sourcesCount = other.sourcesCount;
            this.sources = new TermSource[this.sourcesCount];
            for (int i = 0; i < this.sourcesCount; ++i) {
                this.sources[i] = new TermSource((SortedKeyValueIterator<Key, Value>)other.sources[i].iter.deepCopy(env), other.sources[i].term);
            }
        }
    }

    public Key getTopKey() {
        return this.topKey;
    }

    public Value getTopValue() {
        return this.value;
    }

    public boolean hasTop() {
        return this.currentPartition != null;
    }

    private boolean seekOneSource(int sourceID) throws IOException {
        boolean advancedCursor = false;
        if (this.sources[sourceID].notFlag) {
            while (this.sources[sourceID].iter.hasTop()) {
                Text docID;
                int docIDCompare;
                int partitionCompare;
                int endCompare = -1;
                if (this.overallRange.getEndKey() != null) {
                    endCompare = this.overallRange.getEndKey().getRow().compareTo((BinaryComparable)((Key)this.sources[sourceID].iter.getTopKey()).getRow());
                    if (!this.overallRange.isEndKeyInclusive() && endCompare <= 0 || endCompare < 0) break;
                }
                if ((partitionCompare = this.currentPartition.compareTo((BinaryComparable)this.getPartition((Key)this.sources[sourceID].iter.getTopKey()))) > 0) {
                    Key seekKey = this.buildKey(this.currentPartition, this.sources[sourceID].term);
                    this.sources[sourceID].iter.seek(new Range(seekKey, true, null, false), this.sources[sourceID].seekColfams, true);
                    continue;
                }
                if (partitionCompare < 0) break;
                if (this.sources[sourceID].term != null) {
                    int termCompare = this.sources[sourceID].term.compareTo((BinaryComparable)this.getTerm((Key)this.sources[sourceID].iter.getTopKey()));
                    if (termCompare > 0) {
                        Key seekKey = this.buildKey(this.currentPartition, this.sources[sourceID].term, this.currentDocID);
                        this.sources[sourceID].iter.seek(new Range(seekKey, true, null, false), this.sources[sourceID].seekColfams, true);
                        continue;
                    }
                    if (termCompare < 0) break;
                }
                if ((docIDCompare = this.currentDocID.compareTo((BinaryComparable)(docID = this.getDocID((Key)this.sources[sourceID].iter.getTopKey())))) >= 0) {
                    if (docIDCompare > 0) {
                        Key seekKey = this.buildKey(this.currentPartition, this.sources[sourceID].term, this.currentDocID);
                        this.sources[sourceID].iter.seek(new Range(seekKey, true, null, false), this.sources[sourceID].seekColfams, true);
                        continue;
                    }
                    if (docIDCompare != 0) continue;
                    this.sources[0].iter.next();
                    advancedCursor = true;
                }
                break;
            }
        } else {
            while (true) {
                Text docID;
                int docIDCompare;
                int partitionCompare;
                if (!this.sources[sourceID].iter.hasTop()) {
                    this.currentPartition = null;
                    return true;
                }
                int endCompare = -1;
                if (this.overallRange.getEndKey() != null) {
                    endCompare = this.overallRange.getEndKey().getRow().compareTo((BinaryComparable)((Key)this.sources[sourceID].iter.getTopKey()).getRow());
                    if (!this.overallRange.isEndKeyInclusive() && endCompare <= 0 || endCompare < 0) {
                        this.currentPartition = null;
                        return true;
                    }
                }
                if ((partitionCompare = this.currentPartition.compareTo((BinaryComparable)this.getPartition((Key)this.sources[sourceID].iter.getTopKey()))) > 0) {
                    Key seekKey = this.buildKey(this.currentPartition, this.sources[sourceID].term);
                    this.sources[sourceID].iter.seek(new Range(seekKey, true, null, false), this.sources[sourceID].seekColfams, true);
                    continue;
                }
                if (partitionCompare < 0) {
                    this.currentPartition.set(this.getPartition((Key)this.sources[sourceID].iter.getTopKey()));
                    this.currentDocID.set(emptyByteArray);
                    advancedCursor = true;
                    continue;
                }
                if (this.sources[sourceID].term != null) {
                    int termCompare = this.sources[sourceID].term.compareTo((BinaryComparable)this.getTerm((Key)this.sources[sourceID].iter.getTopKey()));
                    if (termCompare > 0) {
                        Key seekKey = this.buildKey(this.currentPartition, this.sources[sourceID].term, this.currentDocID);
                        this.sources[sourceID].iter.seek(new Range(seekKey, true, null, false), this.sources[sourceID].seekColfams, true);
                        continue;
                    }
                    if (termCompare < 0) {
                        if (endCompare == 0) {
                            this.currentPartition = null;
                            return true;
                        }
                        Key seekKey = this.buildFollowingPartitionKey((Key)this.sources[sourceID].iter.getTopKey());
                        this.sources[sourceID].iter.seek(new Range(seekKey, true, null, false), this.sources[sourceID].seekColfams, true);
                        continue;
                    }
                }
                if ((docIDCompare = this.currentDocID.compareTo((BinaryComparable)(docID = this.getDocID((Key)this.sources[sourceID].iter.getTopKey())))) < 0) {
                    this.currentDocID.set(docID);
                    advancedCursor = true;
                    break;
                }
                if (docIDCompare <= 0) break;
                Key seekKey = this.buildKey(this.currentPartition, this.sources[sourceID].term, this.currentDocID);
                this.sources[sourceID].iter.seek(new Range(seekKey, true, null, false), this.sources[sourceID].seekColfams, true);
            }
        }
        return advancedCursor;
    }

    public void next() throws IOException {
        if (this.currentPartition == null) {
            return;
        }
        this.sources[0].iter.next();
        this.advanceToIntersection();
    }

    protected void advanceToIntersection() throws IOException {
        boolean cursorChanged = true;
        block0: while (cursorChanged) {
            cursorChanged = false;
            for (int i = 0; i < this.sourcesCount; ++i) {
                if (this.currentPartition == null) {
                    this.topKey = null;
                    return;
                }
                if (!this.seekOneSource(i)) continue;
                cursorChanged = true;
                continue block0;
            }
        }
        this.topKey = this.buildKey(this.currentPartition, this.nullText, this.currentDocID);
    }

    public static String stringTopKey(SortedKeyValueIterator<Key, Value> iter) {
        if (iter.hasTop()) {
            return ((Key)iter.getTopKey()).toString();
        }
        return "";
    }

    @Deprecated
    public static String encodeColumns(Text[] columns) {
        StringBuilder sb = new StringBuilder();
        for (Text column : columns) {
            sb.append(new String(Base64.encodeBase64((byte[])TextUtil.getBytes((Text)column)), StandardCharsets.UTF_8));
            sb.append('\n');
        }
        return sb.toString();
    }

    @Deprecated
    public static String encodeBooleans(boolean[] flags) {
        byte[] bytes = new byte[flags.length];
        for (int i = 0; i < flags.length; ++i) {
            bytes[i] = flags[i] ? (byte)1 : 0;
        }
        return new String(Base64.encodeBase64((byte[])bytes), StandardCharsets.UTF_8);
    }

    protected static Text[] decodeColumns(String columns) {
        String[] columnStrings = columns.split("\n");
        Text[] columnTexts = new Text[columnStrings.length];
        for (int i = 0; i < columnStrings.length; ++i) {
            columnTexts[i] = new Text(Base64.decodeBase64((byte[])columnStrings[i].getBytes(StandardCharsets.UTF_8)));
        }
        return columnTexts;
    }

    @Deprecated
    public static boolean[] decodeBooleans(String flags) {
        if (flags == null) {
            return null;
        }
        byte[] bytes = Base64.decodeBase64((byte[])flags.getBytes(StandardCharsets.UTF_8));
        boolean[] bFlags = new boolean[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            bFlags[i] = bytes[i] == 1;
        }
        return bFlags;
    }

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        int i;
        Text[] terms = AndingIterator.decodeColumns(options.get(columnFamiliesOptionName));
        boolean[] notFlag = AndingIterator.decodeBooleans(options.get(notFlagOptionName));
        if (terms.length < 2) {
            throw new IllegalArgumentException("IntersectionIterator requires two or more columns families");
        }
        if (notFlag == null) {
            notFlag = new boolean[terms.length];
            for (i = 0; i < terms.length; ++i) {
                notFlag[i] = false;
            }
        }
        if (notFlag[0]) {
            for (i = 1; i < notFlag.length; ++i) {
                if (notFlag[i]) continue;
                Text swapFamily = new Text(terms[0]);
                terms[0].set(terms[i]);
                terms[i].set(swapFamily);
                notFlag[0] = false;
                notFlag[i] = true;
                break;
            }
            if (notFlag[0]) {
                throw new IllegalArgumentException("IntersectionIterator requires at lest one column family without not");
            }
        }
        this.sources = new TermSource[terms.length];
        this.sources[0] = new TermSource(source, terms[0]);
        for (i = 1; i < terms.length; ++i) {
            this.sources[i] = new TermSource((SortedKeyValueIterator<Key, Value>)source.deepCopy(env), terms[i], notFlag[i]);
        }
        this.sourcesCount = terms.length;
    }

    public void seek(Range range, Collection<ByteSequence> seekColumnFamilies, boolean inclusive) throws IOException {
        this.overallRange = new Range(range);
        this.currentPartition = new Text();
        this.currentDocID.set(emptyByteArray);
        for (int i = 0; i < this.sourcesCount; ++i) {
            if (range.getStartKey() != null) {
                Key sourceKey = range.getStartKey().getColumnQualifier() != null ? this.buildKey(this.getPartition(range.getStartKey()), this.sources[i].term, range.getStartKey().getColumnQualifier()) : this.buildKey(this.getPartition(range.getStartKey()), this.sources[i].term);
                this.sources[i].iter.seek(new Range(sourceKey, true, null, false), this.sources[i].seekColfams, true);
                continue;
            }
            this.sources[i].iter.seek(range, this.sources[i].seekColfams, true);
        }
        this.advanceToIntersection();
    }

    public void addSource(SortedKeyValueIterator<Key, Value> source, IteratorEnvironment env, Text term, boolean notFlag) {
        if (this.sources == null) {
            this.sources = new TermSource[1];
        } else {
            TermSource[] localSources = new TermSource[this.sources.length + 1];
            int currSource = 0;
            for (TermSource myTerm : this.sources) {
                localSources[currSource] = new TermSource(myTerm);
                ++currSource;
            }
            this.sources = localSources;
        }
        this.sources[this.sourcesCount] = new TermSource((SortedKeyValueIterator<Key, Value>)source.deepCopy(env), term, notFlag);
        ++this.sourcesCount;
    }

    public static void setColumnFamilies(IteratorSetting cfg, Text[] columns) {
        if (columns.length < 2) {
            throw new IllegalArgumentException("Must supply at least two terms to intersect");
        }
        cfg.addOption(columnFamiliesOptionName, AndingIterator.encodeColumns(columns));
    }

    public static void setColumnFamilies(IteratorSetting cfg, Text[] columns, boolean[] notFlags) {
        if (columns.length < 2) {
            throw new IllegalArgumentException("Must supply at least two terms to intersect");
        }
        if (columns.length != notFlags.length) {
            throw new IllegalArgumentException("columns and notFlags arrays must be the same length");
        }
        AndingIterator.setColumnFamilies(cfg, columns);
        cfg.addOption(notFlagOptionName, AndingIterator.encodeBooleans(notFlags));
    }

    protected static class TermSource {
        public SortedKeyValueIterator<Key, Value> iter;
        public Text term;
        public Collection<ByteSequence> seekColfams;
        public boolean notFlag;

        public TermSource(TermSource other) {
            this.iter = other.iter;
            this.term = other.term;
            this.notFlag = other.notFlag;
            this.seekColfams = other.seekColfams;
        }

        public TermSource(SortedKeyValueIterator<Key, Value> iter, Text term) {
            this(iter, term, false);
        }

        public TermSource(SortedKeyValueIterator<Key, Value> iter, Text term, boolean notFlag) {
            this.iter = iter;
            this.term = term;
            this.notFlag = notFlag;
            this.seekColfams = term == null ? Collections.emptyList() : Collections.singletonList(new ArrayByteSequence(term.getBytes(), 0, term.getLength()));
        }

        public String getTermString() {
            return this.term == null ? new String("Iterator") : this.term.toString();
        }
    }
}

