/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.accumulo.freetext;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.rya.indexing.FreeTextIndexer;
import org.apache.rya.indexing.IndexingExpr;
import org.apache.rya.indexing.IteratorFactory;
import org.apache.rya.indexing.SearchFunction;
import org.apache.rya.indexing.StatementConstraints;
import org.apache.rya.indexing.external.tupleSet.ExternalTupleSet;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;

public class FreeTextTupleSet
extends ExternalTupleSet {
    private Configuration conf;
    private FreeTextIndexer freeTextIndexer;
    private IndexingExpr filterInfo;

    public FreeTextTupleSet(IndexingExpr filterInfo, FreeTextIndexer freeTextIndexer) {
        this.filterInfo = filterInfo;
        this.freeTextIndexer = freeTextIndexer;
        this.conf = freeTextIndexer.getConf();
    }

    @Override
    public Set<String> getBindingNames() {
        return this.filterInfo.getBindingNames();
    }

    @Override
    public FreeTextTupleSet clone() {
        return new FreeTextTupleSet(this.filterInfo, this.freeTextIndexer);
    }

    public double cardinality() {
        return 0.0;
    }

    @Override
    public String getSignature() {
        return "(FreeTextTuple Projection) variables: " + Joiner.on((String)", ").join(this.getBindingNames()).replaceAll("\\s+", " ");
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FreeTextTupleSet)) {
            return false;
        }
        FreeTextTupleSet arg = (FreeTextTupleSet)((Object)other);
        return this.filterInfo.equals(arg.filterInfo);
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 31 * result + this.filterInfo.hashCode();
        return result;
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bindings) throws QueryEvaluationException {
        IRI funcIRI = this.filterInfo.getFunction();
        SearchFunction searchFunction = new SearchFunction(){

            @Override
            public CloseableIteration<Statement, QueryEvaluationException> performSearch(String queryText, StatementConstraints contraints) throws QueryEvaluationException {
                try {
                    CloseableIteration<Statement, QueryEvaluationException> statements = FreeTextTupleSet.this.freeTextIndexer.queryText(queryText, contraints);
                    return statements;
                }
                catch (IOException e) {
                    throw new QueryEvaluationException((Throwable)e);
                }
            }

            public String toString() {
                return "TEXT";
            }
        };
        if (this.filterInfo.getArguments().length > 1) {
            throw new IllegalArgumentException("Index functions do not support more than two arguments.");
        }
        String queryText = ((Value)this.filterInfo.getArguments()[0]).stringValue();
        return IteratorFactory.getIterator(this.filterInfo.getSpConstraint(), bindings, queryText, searchFunction);
    }
}

