/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.accumulo.freetext;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.io.Text;
import org.apache.rya.indexing.StatementSerializer;
import org.eclipse.rdf4j.model.Statement;

public class ColumnPrefixes {
    public static final Text DOCS_CF_PREFIX = new Text("d\u0000");
    public static final Text TERM_CF_PREFIX = new Text("t\u0000");
    public static final Text TERM_LIST_CF_PREFIX = new Text("l\u0000");
    public static final Text REVERSE_TERM_LIST_CF_PREFIX = new Text("r\u0000");
    public static final Text SUBJECT_CF_PREFIX = new Text("s\u0000");
    public static final Text PREDICATE_CF_PREFIX = new Text("p\u0000");
    public static final Text OBJECT_CF_PREFIX = new Text("o\u0000");
    public static final Text CONTEXT_CF_PREFIX = new Text("c\u0000");

    private static Text concat(Text prefix, String str) {
        Text temp = new Text(prefix);
        try {
            ByteBuffer buffer = Text.encode((String)str, (boolean)false);
            temp.append(buffer.array(), 0, buffer.limit());
        }
        catch (CharacterCodingException cce) {
            throw new IllegalArgumentException(cce);
        }
        return temp;
    }

    public static Text getTermColFam(String term) {
        return ColumnPrefixes.concat(TERM_CF_PREFIX, term);
    }

    public static Text getTermListColFam(String term) {
        return ColumnPrefixes.concat(TERM_LIST_CF_PREFIX, term);
    }

    public static Text getRevTermListColFam(String term) {
        return ColumnPrefixes.concat(REVERSE_TERM_LIST_CF_PREFIX, StringUtils.reverse((String)term));
    }

    public static Text getDocColFam(String term) {
        return ColumnPrefixes.concat(DOCS_CF_PREFIX, term);
    }

    public static Text getSubjColFam(String term) {
        return ColumnPrefixes.concat(SUBJECT_CF_PREFIX, term);
    }

    public static Text getSubjColFam(Statement statement) {
        String subj = StatementSerializer.writeSubject(statement);
        return ColumnPrefixes.getSubjColFam(subj);
    }

    public static Text getPredColFam(String term) {
        return ColumnPrefixes.concat(PREDICATE_CF_PREFIX, term);
    }

    public static Text getPredColFam(Statement statement) {
        String pred = StatementSerializer.writePredicate(statement);
        return ColumnPrefixes.getPredColFam(pred);
    }

    public static Text getObjColFam(String term) {
        return ColumnPrefixes.concat(OBJECT_CF_PREFIX, term);
    }

    public static Text getObjColFam(Statement statement) {
        String obj = StatementSerializer.writeObject(statement);
        return ColumnPrefixes.getObjColFam(obj);
    }

    public static Text getContextColFam(String term) {
        return ColumnPrefixes.concat(CONTEXT_CF_PREFIX, term);
    }

    public static Text getContextColFam(Statement statement) {
        String cont = StatementSerializer.writeContext(statement);
        return ColumnPrefixes.getContextColFam(cont);
    }

    public static Text removePrefix(Text termWithPrefix) {
        Text temp = new Text();
        temp.set(termWithPrefix.getBytes(), 2, termWithPrefix.getLength() - 2);
        return temp;
    }
}

