/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.accumulo.freetext;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.MultiTableBatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.keyfunctor.ColumnFamilyFunctor;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;
import org.apache.rya.accumulo.experimental.AbstractAccumuloIndexer;
import org.apache.rya.api.RdfCloudTripleStoreConfiguration;
import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.api.resolver.RyaToRdfConversions;
import org.apache.rya.indexing.FreeTextIndexer;
import org.apache.rya.indexing.Md5Hash;
import org.apache.rya.indexing.StatementConstraints;
import org.apache.rya.indexing.StatementSerializer;
import org.apache.rya.indexing.accumulo.ConfigUtils;
import org.apache.rya.indexing.accumulo.freetext.ColumnPrefixes;
import org.apache.rya.indexing.accumulo.freetext.Tokenizer;
import org.apache.rya.indexing.accumulo.freetext.iterators.BooleanTreeIterator;
import org.apache.rya.indexing.accumulo.freetext.query.ASTExpression;
import org.apache.rya.indexing.accumulo.freetext.query.ASTNodeUtils;
import org.apache.rya.indexing.accumulo.freetext.query.ASTSimpleNode;
import org.apache.rya.indexing.accumulo.freetext.query.ASTTerm;
import org.apache.rya.indexing.accumulo.freetext.query.ParseException;
import org.apache.rya.indexing.accumulo.freetext.query.QueryParser;
import org.apache.rya.indexing.accumulo.freetext.query.SimpleNode;
import org.apache.rya.indexing.accumulo.freetext.query.TokenMgrError;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.query.QueryEvaluationException;

public class AccumuloFreeTextIndexer
extends AbstractAccumuloIndexer
implements FreeTextIndexer {
    private static final String TABLE_SUFFIX_TERM = "freetext_term";
    private static final String TABLE_SUFFFIX_DOC = "freetext";
    private static final Logger logger = Logger.getLogger(AccumuloFreeTextIndexer.class);
    private static final boolean IS_TERM_TABLE_TOKEN_DELETION_ENABLED = true;
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final Text EMPTY_TEXT = new Text(EMPTY_BYTES);
    private static final Value EMPTY_VALUE = new Value(EMPTY_BYTES);
    private Tokenizer tokenizer;
    private BatchWriter docTableBw;
    private BatchWriter termTableBw;
    private MultiTableBatchWriter mtbw;
    private int queryTermLimit;
    private int docTableNumPartitions;
    private Set<IRI> validPredicates;
    private Configuration conf;
    private boolean isInit = false;

    private void initInternal() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TableExistsException {
        boolean createdDocTable;
        String doctable = AccumuloFreeTextIndexer.getFreeTextDocTablename(this.conf);
        String termtable = AccumuloFreeTextIndexer.getFreeTextTermTablename(this.conf);
        this.docTableNumPartitions = ConfigUtils.getFreeTextDocNumPartitions(this.conf);
        int termTableNumPartitions = ConfigUtils.getFreeTextTermNumPartitions(this.conf);
        TableOperations tableOps = ConfigUtils.getConnector(this.conf).tableOperations();
        boolean createdTermTable = ConfigUtils.createTableIfNotExists(this.conf, termtable);
        if (createdTermTable && !ConfigUtils.useMockInstance(this.conf) && termTableNumPartitions > 0) {
            TreeSet<Text> splits = new TreeSet<Text>();
            splits.add(new Text(ColumnPrefixes.getRevTermListColFam("")));
            int numSubpartitions = (termTableNumPartitions - 1) / 2;
            if (numSubpartitions > 0) {
                int step = 26 / numSubpartitions;
                for (int i = 0; i < numSubpartitions; ++i) {
                    String nextChar = String.valueOf((char)(97 + step * i));
                    splits.add(new Text(ColumnPrefixes.getTermListColFam(nextChar)));
                    splits.add(new Text(ColumnPrefixes.getRevTermListColFam(nextChar)));
                }
            }
            tableOps.addSplits(termtable, splits);
        }
        if ((createdDocTable = ConfigUtils.createTableIfNotExists(this.conf, doctable)) && !ConfigUtils.useMockInstance(this.conf)) {
            TreeSet<Text> splits = new TreeSet<Text>();
            for (int i = 0; i < this.docTableNumPartitions; ++i) {
                splits.add(AccumuloFreeTextIndexer.genPartition(i, this.docTableNumPartitions));
            }
            tableOps.addSplits(doctable, splits);
            tableOps.setProperty(doctable, "table.bloom.key.functor", ColumnFamilyFunctor.class.getCanonicalName());
            tableOps.setProperty(doctable, "table.bloom.enabled", Boolean.TRUE.toString());
        }
        if (this.mtbw != null) {
            this.docTableBw = this.mtbw.getBatchWriter(doctable);
            this.termTableBw = this.mtbw.getBatchWriter(termtable);
        }
        this.tokenizer = ConfigUtils.getFreeTextTokenizer(this.conf);
        this.validPredicates = ConfigUtils.getFreeTextPredicates(this.conf);
        this.queryTermLimit = ConfigUtils.getFreeTextTermLimit(this.conf);
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        if (!this.isInit) {
            try {
                this.initInternal();
                this.isInit = true;
            }
            catch (AccumuloException | AccumuloSecurityException | TableExistsException | TableNotFoundException e) {
                logger.warn((Object)"Unable to initialize index.  Throwing Runtime Exception. ", e);
                throw new RuntimeException(e);
            }
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    private void storeStatement(Statement statement) throws IOException {
        String text;
        SortedSet<String> tokens;
        boolean isValidPredicate;
        Objects.requireNonNull(this.mtbw, "Freetext indexer attempting to store, but setMultiTableBatchWriter() was not set.");
        boolean bl = isValidPredicate = this.validPredicates.isEmpty() || this.validPredicates.contains(statement.getPredicate());
        if (isValidPredicate && statement.getObject() instanceof Literal && !(tokens = this.tokenizer.tokenize(text = statement.getObject().stringValue().toLowerCase())).isEmpty()) {
            String docContent = StatementSerializer.writeStatement(statement);
            String docId = Md5Hash.md5Base64(docContent);
            Text partition = AccumuloFreeTextIndexer.genPartition(docContent.hashCode(), this.docTableNumPartitions);
            Mutation docTableMut = new Mutation(partition);
            ArrayList<Mutation> termTableMutations = new ArrayList<Mutation>();
            Text docIdText = new Text(docId);
            docTableMut.put(ColumnPrefixes.DOCS_CF_PREFIX, docIdText, new Value(docContent.getBytes(Charsets.UTF_8)));
            docTableMut.put(ColumnPrefixes.getSubjColFam(statement), docIdText, EMPTY_VALUE);
            docTableMut.put(ColumnPrefixes.getPredColFam(statement), docIdText, EMPTY_VALUE);
            docTableMut.put(ColumnPrefixes.getObjColFam(statement), docIdText, EMPTY_VALUE);
            docTableMut.put(ColumnPrefixes.getContextColFam(statement), docIdText, EMPTY_VALUE);
            for (String token : tokens) {
                docTableMut.put(ColumnPrefixes.getTermColFam(token), docIdText, EMPTY_VALUE);
                termTableMutations.add(AccumuloFreeTextIndexer.createEmptyPutMutation(ColumnPrefixes.getTermListColFam(token)));
                termTableMutations.add(AccumuloFreeTextIndexer.createEmptyPutMutation(ColumnPrefixes.getRevTermListColFam(token)));
            }
            try {
                this.docTableBw.addMutation(docTableMut);
                this.termTableBw.addMutations(termTableMutations);
            }
            catch (MutationsRejectedException e) {
                logger.error((Object)"error adding mutation", (Throwable)e);
                throw new IOException(e);
            }
        }
    }

    public void storeStatement(RyaStatement statement) throws IOException {
        this.storeStatement(RyaToRdfConversions.convertStatement((RyaStatement)statement));
    }

    private static Mutation createEmptyPutMutation(Text row) {
        Mutation m = new Mutation(row);
        m.put(EMPTY_TEXT, EMPTY_TEXT, EMPTY_VALUE);
        return m;
    }

    private static Mutation createEmptyPutDeleteMutation(Text row) {
        Mutation m = new Mutation(row);
        m.putDelete(EMPTY_TEXT, EMPTY_TEXT);
        return m;
    }

    private static Text genPartition(int partition, int numParitions) {
        int length = Integer.toString(numParitions).length();
        return new Text(String.format("%0" + length + "d", Math.abs(partition % numParitions)));
    }

    public Set<IRI> getIndexablePredicates() {
        return this.validPredicates;
    }

    public void flush() throws IOException {
        try {
            this.mtbw.flush();
        }
        catch (MutationsRejectedException e) {
            logger.error((Object)"error flushing the batch writer", (Throwable)e);
            throw new IOException(e);
        }
    }

    public void close() throws IOException {
        try {
            if (this.mtbw != null) {
                this.mtbw.close();
            }
        }
        catch (MutationsRejectedException e) {
            logger.error((Object)"error closing the batch writer", (Throwable)e);
            throw new IOException(e);
        }
    }

    private Set<String> unrollWildcard(String string, boolean reverse) throws IOException {
        Text queryTerm;
        String t;
        Scanner termTableScan = this.getScanner(AccumuloFreeTextIndexer.getFreeTextTermTablename(this.conf));
        HashSet<String> unrolledTerms = new HashSet<String>();
        if (reverse) {
            t = StringUtils.removeStart((String)string, (String)"*").toLowerCase();
            queryTerm = ColumnPrefixes.getRevTermListColFam(t);
        } else {
            t = StringUtils.removeEnd((String)string, (String)"*").toLowerCase();
            queryTerm = ColumnPrefixes.getTermListColFam(t);
        }
        termTableScan.setRange(Range.prefix((Text)queryTerm));
        for (Map.Entry e : termTableScan) {
            String term = ColumnPrefixes.removePrefix(((Key)e.getKey()).getRow()).toString();
            if (reverse) {
                unrolledTerms.add(StringUtils.reverse((String)term));
                continue;
            }
            unrolledTerms.add(term);
        }
        if (unrolledTerms.isEmpty()) {
            unrolledTerms.add("\u0001\u0001\u0001");
        }
        return unrolledTerms;
    }

    private void unrollWildcards(SimpleNode node) throws IOException {
        if (node instanceof ASTExpression || node instanceof ASTSimpleNode) {
            for (SimpleNode n : ASTNodeUtils.getNodeIterator(node)) {
                this.unrollWildcards(n);
            }
        } else if (node instanceof ASTTerm) {
            ASTTerm term = (ASTTerm)node;
            boolean isWildTerm = term.getType().equals("WILDTERM");
            boolean isPreWildTerm = term.getType().equals("PREFIXTERM");
            if (isWildTerm || isPreWildTerm) {
                Set<String> unrolledTerms = this.unrollWildcard(term.getTerm(), isPreWildTerm);
                ASTExpression newExpression = new ASTExpression(1);
                newExpression.setType("OR");
                newExpression.setNotFlag(term.isNotFlag());
                for (String unrolledTerm : unrolledTerms) {
                    ASTTerm t = new ASTTerm(3);
                    t.setNotFlag(false);
                    t.setTerm(unrolledTerm);
                    t.setType("TERM");
                    ASTNodeUtils.pushChild(newExpression, t);
                }
                SimpleNode parent = (SimpleNode)term.jjtGetParent();
                int index = ASTNodeUtils.getChildIndex(parent, term);
                Validate.isTrue((index >= 0 ? 1 : 0) != 0, (String)"child not found in parent");
                parent.jjtAddChild(newExpression, index);
            }
        } else {
            throw new IllegalArgumentException("Node is of unknown type: " + node.getClass().getName());
        }
    }

    private Scanner getScanner(String tablename) throws IOException {
        try {
            return ConfigUtils.createScanner(tablename, this.conf);
        }
        catch (AccumuloException | AccumuloSecurityException | TableNotFoundException e) {
            logger.error((Object)("Error connecting to " + tablename));
            throw new IOException(e);
        }
    }

    @Override
    public CloseableIteration<Statement, QueryEvaluationException> queryText(String query, StatementConstraints contraints) throws IOException {
        int termCount;
        Scanner docTableScan = this.getScanner(AccumuloFreeTextIndexer.getFreeTextDocTablename(this.conf));
        SimpleNode root = AccumuloFreeTextIndexer.parseQuery(query);
        this.unrollWildcards(root);
        String unrolledQuery = ASTNodeUtils.serializeExpression(root);
        StringBuilder constrainedQuery = new StringBuilder("(" + unrolledQuery + ")");
        if (contraints.hasSubject()) {
            constrainedQuery.append(" AND ");
            constrainedQuery.append(ColumnPrefixes.getSubjColFam(contraints.getSubject().toString()).toString());
        }
        if (contraints.hasContext()) {
            constrainedQuery.append(" AND ");
            constrainedQuery.append(ColumnPrefixes.getContextColFam(contraints.getContext().toString()).toString());
        }
        if (contraints.hasPredicates()) {
            constrainedQuery.append(" AND (");
            ArrayList<String> predicates = new ArrayList<String>();
            for (IRI u : contraints.getPredicates()) {
                predicates.add(ColumnPrefixes.getPredColFam(u.stringValue()).toString());
            }
            constrainedQuery.append(StringUtils.join(predicates, (String)" OR "));
            constrainedQuery.append(")");
        }
        if ((termCount = ASTNodeUtils.termCount(root = AccumuloFreeTextIndexer.parseQuery(constrainedQuery.toString()))) > this.queryTermLimit) {
            throw new IOException("Query contains too many terms.  Term limit: " + this.queryTermLimit + ".  Term Count: " + termCount);
        }
        docTableScan.clearScanIterators();
        docTableScan.clearColumns();
        int iteratorPriority = 20;
        String iteratorName = "booleanTree";
        IteratorSetting ii = new IteratorSetting(20, "booleanTree", BooleanTreeIterator.class);
        BooleanTreeIterator.setQuery(ii, constrainedQuery.toString());
        docTableScan.addScanIterator(ii);
        docTableScan.setRange(new Range());
        return AccumuloFreeTextIndexer.getIteratorWrapper(docTableScan);
    }

    private static CloseableIteration<Statement, QueryEvaluationException> getIteratorWrapper(final Scanner s) {
        final Iterator i = s.iterator();
        return new CloseableIteration<Statement, QueryEvaluationException>(){

            public boolean hasNext() {
                return i.hasNext();
            }

            public Statement next() throws QueryEvaluationException {
                Map.Entry entry = (Map.Entry)i.next();
                Value v = (Value)entry.getValue();
                try {
                    String dataString = Text.decode((byte[])v.get(), (int)0, (int)v.getSize());
                    Statement s2 = StatementSerializer.readStatement(dataString);
                    return s2;
                }
                catch (CharacterCodingException e) {
                    logger.error((Object)"Error decoding value", (Throwable)e);
                    throw new QueryEvaluationException((Throwable)e);
                }
                catch (IOException e) {
                    logger.error((Object)"Error deserializing statement", (Throwable)e);
                    throw new QueryEvaluationException((Throwable)e);
                }
            }

            public void remove() {
                throw new UnsupportedOperationException("Remove not implemented");
            }

            public void close() throws QueryEvaluationException {
                if (s != null) {
                    s.close();
                }
            }
        };
    }

    private static SimpleNode parseQuery(String query) throws IOException {
        SimpleNode root = null;
        try {
            root = QueryParser.parse(query);
        }
        catch (ParseException e) {
            logger.error((Object)("Parser Exception on Client Side. Query: " + query), (Throwable)e);
            throw new IOException(e);
        }
        catch (TokenMgrError e) {
            logger.error((Object)("Token Manager Exception on Client Side. Query: " + query), (Throwable)e);
            throw new IOException(e);
        }
        return root;
    }

    public String getTableName() {
        return AccumuloFreeTextIndexer.getFreeTextDocTablename(this.conf);
    }

    public static List<String> getTableNames(Configuration conf) {
        Objects.requireNonNull(conf);
        return Collections.unmodifiableList(AccumuloFreeTextIndexer.makeTableNames(ConfigUtils.getTablePrefix(conf)));
    }

    public static String getFreeTextDocTablename(Configuration conf) {
        Objects.requireNonNull(conf);
        return AccumuloFreeTextIndexer.makeFreeTextDocTablename(ConfigUtils.getTablePrefix(conf));
    }

    public void setMultiTableBatchWriter(MultiTableBatchWriter writer) throws IOException {
        this.mtbw = writer;
    }

    public static String getFreeTextTermTablename(Configuration conf) {
        Objects.requireNonNull(conf);
        return AccumuloFreeTextIndexer.makeFreeTextTermTablename(ConfigUtils.getTablePrefix(conf));
    }

    public static List<String> makeTableNames(String ryaInstanceName) {
        Objects.requireNonNull(ryaInstanceName);
        return Lists.newArrayList((Object[])new String[]{AccumuloFreeTextIndexer.makeFreeTextDocTablename(ryaInstanceName), AccumuloFreeTextIndexer.makeFreeTextTermTablename(ryaInstanceName)});
    }

    public static String makeFreeTextDocTablename(String ryaInstanceName) {
        Objects.requireNonNull(ryaInstanceName);
        return ryaInstanceName + TABLE_SUFFFIX_DOC;
    }

    public static String makeFreeTextTermTablename(String ryaInstanceName) {
        Objects.requireNonNull(ryaInstanceName);
        return ryaInstanceName + TABLE_SUFFIX_TERM;
    }

    private void deleteStatement(Statement statement) throws IOException {
        String text;
        SortedSet<String> tokens;
        boolean isValidPredicate;
        Objects.requireNonNull(this.mtbw, "Freetext indexer attempting to delete, but setMultiTableBatchWriter() was not set.");
        boolean bl = isValidPredicate = this.validPredicates.isEmpty() || this.validPredicates.contains(statement.getPredicate());
        if (isValidPredicate && statement.getObject() instanceof Literal && !(tokens = this.tokenizer.tokenize(text = statement.getObject().stringValue().toLowerCase())).isEmpty()) {
            String docContent = StatementSerializer.writeStatement(statement);
            String docId = Md5Hash.md5Base64(docContent);
            Text partition = AccumuloFreeTextIndexer.genPartition(docContent.hashCode(), this.docTableNumPartitions);
            Mutation docTableMut = new Mutation(partition);
            ArrayList<Mutation> termTableMutations = new ArrayList<Mutation>();
            Text docIdText = new Text(docId);
            docTableMut.putDelete(ColumnPrefixes.DOCS_CF_PREFIX, docIdText);
            docTableMut.putDelete(ColumnPrefixes.getSubjColFam(statement), docIdText);
            docTableMut.putDelete(ColumnPrefixes.getPredColFam(statement), docIdText);
            docTableMut.putDelete(ColumnPrefixes.getObjColFam(statement), docIdText);
            docTableMut.putDelete(ColumnPrefixes.getContextColFam(statement), docIdText);
            for (String token : tokens) {
                int rowId;
                boolean doesTermExistInOtherDocs = this.doesTermExistInOtherDocs(token, rowId = Integer.parseInt(partition.toString()), docIdText);
                if (!doesTermExistInOtherDocs) {
                    termTableMutations.add(AccumuloFreeTextIndexer.createEmptyPutDeleteMutation(ColumnPrefixes.getTermListColFam(token)));
                    termTableMutations.add(AccumuloFreeTextIndexer.createEmptyPutDeleteMutation(ColumnPrefixes.getRevTermListColFam(token)));
                }
                docTableMut.putDelete(ColumnPrefixes.getTermColFam(token), docIdText);
            }
            try {
                this.docTableBw.addMutation(docTableMut);
                this.termTableBw.addMutations(termTableMutations);
            }
            catch (MutationsRejectedException e) {
                logger.error((Object)"error adding mutation", (Throwable)e);
                throw new IOException(e);
            }
        }
    }

    public void deleteStatement(RyaStatement statement) throws IOException {
        this.deleteStatement(RyaToRdfConversions.convertStatement((RyaStatement)statement));
    }

    private boolean doesTermExistInOtherDocs(String term, int currentDocId, Text docIdText) {
        try {
            String freeTextDocTableName = AccumuloFreeTextIndexer.getFreeTextDocTablename(this.conf);
            Scanner scanner = this.getScanner(freeTextDocTableName);
            String t = StringUtils.removeEnd((String)term, (String)"*").toLowerCase();
            Text queryTerm = ColumnPrefixes.getTermColFam(t);
            scanner.fetchColumnFamily(queryTerm);
            for (Map.Entry entry : scanner) {
                Text text;
                String value;
                Text columnFamily;
                String columnFamilyValue;
                Key key = (Key)entry.getKey();
                Text row = key.getRow();
                int rowId = Integer.parseInt(row.toString());
                if (rowId == currentDocId || !(columnFamilyValue = (columnFamily = key.getColumnFamily()).toString()).startsWith(ColumnPrefixes.TERM_CF_PREFIX.toString()) || !(value = (text = ColumnPrefixes.removePrefix(columnFamily)).toString()).equals(term)) continue;
                return true;
            }
        }
        catch (IOException e) {
            logger.error((Object)"Error searching for the existance of the term in other documents", (Throwable)e);
        }
        return false;
    }

    public void init() {
        Objects.requireNonNull(this.mtbw, "Freetext indexer failed to initialize temporal index, setMultiTableBatchWriter() was not set.");
        Objects.requireNonNull(this.conf, "Freetext indexer failed to initialize temporal index, setConf() was not set.");
        try {
            this.docTableBw = this.mtbw.getBatchWriter(AccumuloFreeTextIndexer.getFreeTextDocTablename(this.conf));
            this.termTableBw = this.mtbw.getBatchWriter(AccumuloFreeTextIndexer.getFreeTextTermTablename(this.conf));
        }
        catch (AccumuloException | AccumuloSecurityException | TableNotFoundException e) {
            logger.error((Object)"Unable to initialize index.  Throwing Runtime Exception. ", e);
            throw new RuntimeException(e);
        }
    }

    public void setConnector(Connector connector) {
    }

    public void destroy() {
    }

    public void purge(RdfCloudTripleStoreConfiguration configuration) {
    }

    public void dropAndDestroy() {
    }
}

