/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.accumulo.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Bytes;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.hadoop.io.Text;
import org.apache.rya.accumulo.documentIndex.TextColumn;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.api.domain.RyaType;
import org.apache.rya.api.domain.VarNameUtils;
import org.apache.rya.api.resolver.RdfToRyaConversions;
import org.apache.rya.api.resolver.RyaContext;
import org.apache.rya.api.resolver.RyaTypeResolverException;
import org.apache.rya.joinselect.AccumuloSelectivityEvalDAO;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;

public class StarQuery {
    private final List<StatementPattern> nodes;
    private final TextColumn[] nodeColumnCond;
    private String commonVarName;
    private Var commonVar;
    private Var context;
    private String contextURI = "";
    private final Map<String, Integer> varPos = Maps.newHashMap();
    private boolean isCommonVarURI = false;

    public StarQuery(List<StatementPattern> nodes) {
        this.nodes = nodes;
        if (nodes.size() == 0) {
            throw new IllegalArgumentException("Nodes cannot be empty!");
        }
        this.nodeColumnCond = new TextColumn[nodes.size()];
        Var tempContext = nodes.get(0).getContextVar();
        this.context = tempContext != null ? tempContext.clone() : new Var();
        try {
            this.init();
        }
        catch (RyaTypeResolverException e) {
            e.printStackTrace();
        }
    }

    public StarQuery(Set<StatementPattern> nodes) {
        this(Lists.newArrayList(nodes));
    }

    public int size() {
        return this.nodes.size();
    }

    public StarQuery(StarQuery other) {
        this(other.nodes);
    }

    public List<StatementPattern> getNodes() {
        return this.nodes;
    }

    public TextColumn[] getColumnCond() {
        return this.nodeColumnCond;
    }

    public boolean isCommonVarURI() {
        return this.isCommonVarURI;
    }

    public String getCommonVarName() {
        return this.commonVarName;
    }

    public Var getCommonVar() {
        return this.commonVar;
    }

    public boolean commonVarHasValue() {
        return this.commonVar.getValue() != null;
    }

    public boolean commonVarConstant() {
        return this.commonVar.isConstant();
    }

    public String getCommonVarValue() {
        if (this.commonVarHasValue()) {
            return this.commonVar.getValue().stringValue();
        }
        return null;
    }

    public Set<String> getUnCommonVars() {
        return this.varPos.keySet();
    }

    public Map<String, Integer> getVarPos() {
        return this.varPos;
    }

    public boolean hasContext() {
        return this.context.getValue() != null;
    }

    public String getContextURI() {
        return this.contextURI;
    }

    public Set<String> getBindingNames() {
        Set bindingNames = Sets.newHashSet();
        for (StatementPattern sp : this.nodes) {
            if (bindingNames.size() == 0) {
                bindingNames = sp.getBindingNames();
                continue;
            }
            bindingNames = Sets.union((Set)bindingNames, (Set)sp.getBindingNames());
        }
        return bindingNames;
    }

    public Set<String> getAssuredBindingNames() {
        Set bindingNames = Sets.newHashSet();
        for (StatementPattern sp : this.nodes) {
            if (bindingNames.size() == 0) {
                bindingNames = sp.getAssuredBindingNames();
                continue;
            }
            bindingNames = Sets.union((Set)bindingNames, (Set)sp.getAssuredBindingNames());
        }
        return bindingNames;
    }

    public CardinalityStatementPattern getMinCardSp(AccumuloSelectivityEvalDAO ase) {
        StatementPattern minSp = null;
        double cardinality = Double.MAX_VALUE;
        double tempCard = -1.0;
        for (StatementPattern sp : this.nodes) {
            try {
                tempCard = ase.getCardinality(ase.getConf(), sp);
                if (!(tempCard < cardinality)) continue;
                cardinality = tempCard;
                minSp = sp;
            }
            catch (TableNotFoundException e) {
                e.printStackTrace();
            }
        }
        return new CardinalityStatementPattern(minSp, cardinality);
    }

    public double getCardinality(AccumuloSelectivityEvalDAO ase) {
        double cardinality = Double.MAX_VALUE;
        double tempCard = -1.0;
        ase.setDenormalized(true);
        try {
            for (int i = 0; i < this.nodes.size(); ++i) {
                for (int j = i + 1; j < this.nodes.size(); ++j) {
                    tempCard = ase.getJoinSelect(ase.getConf(), (TupleExpr)this.nodes.get(i), (TupleExpr)this.nodes.get(j));
                    if (!(tempCard < cardinality)) continue;
                    cardinality = tempCard;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ase.setDenormalized(false);
        return cardinality / (double)(this.nodes.size() + 1);
    }

    public static Set<String> getCommonVars(StarQuery query, BindingSet bs) {
        HashSet starQueryVarNames = Sets.newHashSet();
        if (bs == null || bs.size() == 0) {
            return Sets.newHashSet();
        }
        Set bindingNames = bs.getBindingNames();
        starQueryVarNames.addAll(query.getUnCommonVars());
        if (!query.commonVarConstant()) {
            starQueryVarNames.add(query.getCommonVarName());
        }
        return Sets.intersection((Set)bindingNames, (Set)starQueryVarNames);
    }

    public static StarQuery getConstrainedStarQuery(StarQuery query, BindingSet bs) {
        Value v;
        if (bs.size() == 0) {
            return query;
        }
        Set bindingNames = bs.getBindingNames();
        Set<String> unCommonVarNames = query.getUnCommonVars();
        Sets.SetView intersectVar = Sets.intersection((Set)bindingNames, unCommonVarNames);
        if (!query.commonVarConstant() && (v = bs.getValue(query.getCommonVarName())) != null) {
            query.commonVar.setValue(v);
        }
        for (String s : intersectVar) {
            try {
                query.nodeColumnCond[query.varPos.get((Object)s).intValue()] = query.setValue(query.nodeColumnCond[query.varPos.get(s)], bs.getValue(s));
            }
            catch (RyaTypeResolverException e) {
                e.printStackTrace();
            }
        }
        return query;
    }

    private TextColumn setValue(TextColumn tc, Value v) throws RyaTypeResolverException {
        String cq = tc.getColumnQualifier().toString();
        String[] cqArray = cq.split("\u0000");
        if (cqArray[0].equals("subject")) {
            tc.setColumnQualifier(new Text("subject\u0000" + v.stringValue()));
            tc.setIsPrefix(false);
        } else if (cqArray[0].equals("object")) {
            RyaType objType = RdfToRyaConversions.convertValue((Value)v);
            byte[][] b1 = RyaContext.getInstance().serializeType(objType);
            byte[] b2 = Bytes.concat((byte[][])new byte[][]{"object".getBytes(StandardCharsets.UTF_8), "\u0000".getBytes(StandardCharsets.UTF_8), b1[0], b1[1]});
            tc.setColumnQualifier(new Text(b2));
            tc.setIsPrefix(false);
        } else {
            throw new IllegalStateException("Invalid direction!");
        }
        return tc;
    }

    private TextColumn nodeToTextColumn(StatementPattern node, int i) throws RyaTypeResolverException {
        RyaContext rc = RyaContext.getInstance();
        Var subjVar = node.getSubjectVar();
        Var predVar = node.getPredicateVar();
        Var objVar = node.getObjectVar();
        RyaIRI predURI = (RyaIRI)RdfToRyaConversions.convertValue((Value)node.getPredicateVar().getValue());
        if (subjVar.isConstant()) {
            if (this.commonVarConstant()) {
                this.varPos.put(objVar.getName(), i);
                return new TextColumn(new Text(predURI.getData()), new Text("object"));
            }
            return new TextColumn(new Text(predURI.getData()), new Text("subject\u0000" + subjVar.getValue().stringValue()));
        }
        if (objVar.isConstant()) {
            if (this.commonVarConstant()) {
                this.varPos.put(subjVar.getName(), i);
                return new TextColumn(new Text(predURI.getData()), new Text("subject"));
            }
            this.isCommonVarURI = true;
            RyaType objType = RdfToRyaConversions.convertValue((Value)objVar.getValue());
            byte[][] b1 = rc.serializeType(objType);
            byte[] b2 = Bytes.concat((byte[][])new byte[][]{"object".getBytes(StandardCharsets.UTF_8), "\u0000".getBytes(StandardCharsets.UTF_8), b1[0], b1[1]});
            return new TextColumn(new Text(predURI.getData()), new Text(b2));
        }
        if (subjVar.getName().equals(this.commonVarName)) {
            this.isCommonVarURI = true;
            this.varPos.put(objVar.getName(), i);
            TextColumn tc = new TextColumn(new Text(predURI.getData()), new Text("object"));
            tc.setIsPrefix(true);
            return tc;
        }
        this.varPos.put(subjVar.getName(), i);
        TextColumn tc = new TextColumn(new Text(predURI.getData()), new Text("subject"));
        tc.setIsPrefix(true);
        return tc;
    }

    private void init() throws RyaTypeResolverException {
        this.commonVar = this.getCommonVar(this.nodes);
        this.commonVarName = !this.commonVar.isConstant() ? this.commonVar.getName() : this.commonVar.getName().substring(7);
        if (this.hasContext()) {
            RyaIRI ctxtURI = (RyaIRI)RdfToRyaConversions.convertValue((Value)this.context.getValue());
            this.contextURI = ctxtURI.getData();
        }
        for (int i = 0; i < this.nodes.size(); ++i) {
            this.nodeColumnCond[i] = this.nodeToTextColumn(this.nodes.get(i), i);
        }
    }

    private Var getCommonVar(List<StatementPattern> nodes) {
        Set vars = null;
        int i = 0;
        for (StatementPattern sp : nodes) {
            if (vars == null) {
                vars = Sets.newHashSet();
                vars.add(sp.getSubjectVar());
                vars.add(sp.getObjectVar());
                continue;
            }
            HashSet tempSet = Sets.newHashSet();
            tempSet.add(sp.getSubjectVar());
            tempSet.add(sp.getObjectVar());
            vars = Sets.intersection((Set)vars, (Set)tempSet);
        }
        if (vars == null) {
            throw new NullPointerException("vars is null so the list of statement pattern nodes must be empty: nodes.size()= " + nodes.size());
        }
        if (vars.size() == 1) {
            return (Var)vars.iterator().next();
        }
        if (vars.size() > 1) {
            Var first = null;
            i = 0;
            for (Var v : vars) {
                if (++i == 1) {
                    first = v;
                    continue;
                }
                if (!v.isConstant()) continue;
                return v;
            }
            return first;
        }
        throw new IllegalStateException("No common Var!");
    }

    private static boolean isBindingsetValid(Set<String> bindings) {
        int varCount = 0;
        if (bindings.size() == 1) {
            return true;
        }
        for (String s : bindings) {
            if (!VarNameUtils.isConstant((String)s)) {
                ++varCount;
            }
            if (varCount <= 1) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidStarQuery(Collection<StatementPattern> nodes) {
        Set bindings = null;
        boolean contextSet = false;
        Var context = null;
        if (nodes.size() < 2) {
            return false;
        }
        for (StatementPattern sp : nodes) {
            Var tempContext = sp.getContextVar();
            Var predVar = sp.getPredicateVar();
            if (tempContext != null && !tempContext.isConstant()) {
                return false;
            }
            if (!contextSet) {
                context = tempContext;
                contextSet = true;
            } else {
                if (context == null && tempContext != null) {
                    return false;
                }
                if (context != null && !context.equals((Object)tempContext)) {
                    return false;
                }
            }
            if (!predVar.isConstant()) {
                return false;
            }
            if (!(bindings == null ? (bindings = sp.getBindingNames()).size() == 0 : (bindings = Sets.intersection((Set)bindings, (Set)sp.getBindingNames())).size() == 0)) continue;
            return false;
        }
        return StarQuery.isBindingsetValid(bindings);
    }

    public String toString() {
        String s = "Term conditions: \n";
        for (TextColumn element : this.nodeColumnCond) {
            s = s + element.toString() + "\n";
        }
        s = s + "Common Var: " + this.commonVar.toString() + "\n";
        s = s + "Context: " + this.contextURI;
        return s;
    }

    public class CardinalityStatementPattern {
        private final StatementPattern sp;
        private final double cardinality;

        public CardinalityStatementPattern(StatementPattern sp, double cardinality) {
            this.sp = sp;
            this.cardinality = cardinality;
        }

        public StatementPattern getSp() {
            return this.sp;
        }

        public double getCardinality() {
            return this.cardinality;
        }
    }
}

