/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.accumulo.entity;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.rya.accumulo.AccumuloRdfConfiguration;
import org.apache.rya.accumulo.AccumuloRyaDAO;
import org.apache.rya.api.RdfCloudTripleStoreConfiguration;
import org.apache.rya.api.persist.RdfEvalStatsDAO;
import org.apache.rya.api.persist.RyaDAO;
import org.apache.rya.indexing.accumulo.ConfigUtils;
import org.apache.rya.indexing.accumulo.entity.AccumuloDocIdIndexer;
import org.apache.rya.indexing.accumulo.entity.StarQuery;
import org.apache.rya.joinselect.AccumuloSelectivityEvalDAO;
import org.apache.rya.prospector.service.ProspectorServiceEvalStatsDAO;
import org.apache.rya.rdftriplestore.RdfCloudTripleStore;
import org.apache.rya.rdftriplestore.RdfCloudTripleStoreConnection;
import org.apache.rya.rdftriplestore.evaluation.ExternalBatchingIterator;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.ExternalSet;
import org.eclipse.rdf4j.sail.SailException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityTupleSet
extends ExternalSet
implements ExternalBatchingIterator {
    private static final Logger LOG = LoggerFactory.getLogger(EntityTupleSet.class);
    private StarQuery starQuery;
    private RdfCloudTripleStoreConfiguration conf;
    private Set<String> variables;
    private double cardinality = -1.0;
    private StatementPattern minSp;
    private double minCard;
    private Connector accCon = null;
    private boolean evalOptUsed = false;

    public EntityTupleSet() {
    }

    public EntityTupleSet(StarQuery sq, RdfCloudTripleStoreConfiguration conf) {
        this.starQuery = sq;
        this.conf = conf;
        this.variables = Sets.newHashSet();
        if (!this.starQuery.commonVarConstant()) {
            this.variables.add(this.starQuery.getCommonVarName());
        }
        this.variables.addAll(this.starQuery.getUnCommonVars());
        this.init();
    }

    public EntityTupleSet(StarQuery sq, RdfCloudTripleStoreConfiguration conf, boolean evalOptUsed) {
        this(sq, conf);
        this.evalOptUsed = evalOptUsed;
    }

    private void init() {
        try {
            this.accCon = ConfigUtils.getConnector((Configuration)this.conf);
        }
        catch (AccumuloException e) {
            e.printStackTrace();
        }
        catch (AccumuloSecurityException e) {
            e.printStackTrace();
        }
        try {
            if (this.conf.isUseStats().booleanValue() && this.conf.isUseSelectivity().booleanValue()) {
                ProspectorServiceEvalStatsDAO evalDao = new ProspectorServiceEvalStatsDAO(this.accCon, this.conf);
                evalDao.init();
                AccumuloSelectivityEvalDAO ase = new AccumuloSelectivityEvalDAO(this.conf, this.accCon);
                ase.setRdfEvalDAO((RdfEvalStatsDAO)evalDao);
                ase.init();
                this.cardinality = this.starQuery.getCardinality(ase);
                StarQuery.CardinalityStatementPattern csp = this.starQuery.getMinCardSp(ase);
                this.minCard = csp.getCardinality();
                this.minSp = csp.getSp();
            } else {
                this.minCard = 1.0;
                this.cardinality = 1.0;
                this.minSp = this.starQuery.getNodes().get(0);
            }
        }
        catch (Exception e) {
            LOG.warn("A problem was encountered while initializing the EntityTupleSet.", (Throwable)e);
        }
    }

    public Set<String> getBindingNames() {
        return this.starQuery.getBindingNames();
    }

    public Set<String> getAssuredBindingNames() {
        return this.starQuery.getAssuredBindingNames();
    }

    public Set<String> getVariables() {
        return this.variables;
    }

    public String getSignature() {
        return "(EntityCentric Projection)  common Var: " + this.starQuery.getCommonVarName() + "  variables: " + Joiner.on((String)", ").join(this.variables).replaceAll("\\s+", " ");
    }

    public StarQuery getStarQuery() {
        return this.starQuery;
    }

    public void setStarQuery(StarQuery sq) {
        this.starQuery = sq;
    }

    public EntityTupleSet clone() {
        StarQuery sq = new StarQuery(this.starQuery);
        return new EntityTupleSet(sq, this.conf);
    }

    public double cardinality() {
        return this.cardinality;
    }

    public double getMinSpCard() {
        return this.minCard;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bindings) throws QueryEvaluationException {
        if (this.minCard < 1000.0 && this.starQuery.size() > 2 && this.numberOfSpVars(this.minSp) == 1 && !this.starQuery.commonVarConstant()) {
            try {
                RdfCloudTripleStoreConnection conn = this.getRyaSailConnection();
                CloseableIteration sol = conn.evaluate((TupleExpr)this.minSp, null, bindings, false);
                HashSet bSet = Sets.newHashSet();
                while (sol.hasNext()) {
                    QueryBindingSet bs = new QueryBindingSet();
                    bs.addAll((BindingSet)sol.next());
                    bs.addAll(bindings);
                    bSet.add(bs);
                }
                List<StatementPattern> spList = this.starQuery.getNodes();
                spList.remove(this.minSp);
                StarQuery sq = new StarQuery(spList);
                conn.close();
                return new EntityTupleSet(sq, this.conf, true).evaluate(bSet);
            }
            catch (Exception e) {
                throw new QueryEvaluationException((Throwable)e);
            }
        }
        this.evalOptUsed = true;
        return this.evaluate(Collections.singleton(bindings));
    }

    private int numberOfSpVars(StatementPattern sp) {
        List varList = sp.getVarList();
        int varCount = 0;
        for (int i = 0; i < 3; ++i) {
            if (((Var)varList.get(i)).isConstant()) continue;
            ++varCount;
        }
        return varCount;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Collection<BindingSet> bindingset) throws QueryEvaluationException {
        CloseableIteration<BindingSet, QueryEvaluationException> closeableIteration;
        if (bindingset.size() < 2 && !this.evalOptUsed) {
            QueryBindingSet bs = new QueryBindingSet();
            if (bindingset.size() == 1) {
                bs = bindingset.iterator().next();
            }
            return this.evaluate((BindingSet)bs);
        }
        AccumuloDocIdIndexer adi = null;
        try {
            adi = new AccumuloDocIdIndexer(this.conf);
            closeableIteration = adi.queryDocIndex(this.starQuery, bindingset);
        }
        catch (Exception e) {
            try {
                throw new QueryEvaluationException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(adi);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)adi);
        return closeableIteration;
    }

    private RdfCloudTripleStoreConnection getRyaSailConnection() throws AccumuloException, AccumuloSecurityException, SailException {
        RdfCloudTripleStore store = new RdfCloudTripleStore();
        AccumuloRyaDAO crdfdao = new AccumuloRyaDAO();
        crdfdao.setConnector(this.accCon);
        AccumuloRdfConfiguration acc = new AccumuloRdfConfiguration((Configuration)this.conf);
        crdfdao.setConf(acc);
        store.setRyaDAO((RyaDAO)crdfdao);
        store.initialize();
        return (RdfCloudTripleStoreConnection)store.getConnection();
    }
}

