/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.accumulo.entity;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.rya.accumulo.AccumuloRdfConfiguration;
import org.apache.rya.api.RdfCloudTripleStoreConfiguration;
import org.apache.rya.api.domain.VarNameUtils;
import org.apache.rya.api.persist.RdfEvalStatsDAO;
import org.apache.rya.api.persist.joinselect.SelectivityEvalDAO;
import org.apache.rya.indexing.accumulo.ConfigUtils;
import org.apache.rya.indexing.accumulo.entity.EntityTupleSet;
import org.apache.rya.indexing.accumulo.entity.StarQuery;
import org.apache.rya.joinselect.AccumuloSelectivityEvalDAO;
import org.apache.rya.prospector.service.ProspectorServiceEvalStatsDAO;
import org.apache.rya.rdftriplestore.inference.DoNotExpandSP;
import org.apache.rya.rdftriplestore.utils.FixedStatementPattern;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityOptimizer
implements QueryOptimizer,
Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(EntityTupleSet.class);
    private SelectivityEvalDAO<RdfCloudTripleStoreConfiguration> eval;
    private RdfCloudTripleStoreConfiguration conf;
    private boolean isEvalDaoSet = false;

    public EntityOptimizer() {
    }

    public EntityOptimizer(RdfCloudTripleStoreConfiguration conf) {
        if (conf.isUseStats().booleanValue() && conf.isUseSelectivity().booleanValue()) {
            try {
                this.eval = new AccumuloSelectivityEvalDAO(conf, ConfigUtils.getConnector((Configuration)conf));
                ((AccumuloSelectivityEvalDAO)this.eval).setRdfEvalDAO((RdfEvalStatsDAO)new ProspectorServiceEvalStatsDAO(ConfigUtils.getConnector((Configuration)conf), conf));
                this.eval.init();
            }
            catch (AccumuloException | AccumuloSecurityException e) {
                LOG.warn("A problem was encountered while constructing the EntityOptimizer.", e);
            }
            this.isEvalDaoSet = true;
        } else {
            this.eval = null;
            this.isEvalDaoSet = true;
        }
        this.conf = conf;
    }

    public EntityOptimizer(SelectivityEvalDAO<RdfCloudTripleStoreConfiguration> eval) {
        this.eval = eval;
        this.conf = eval.getConf();
        this.isEvalDaoSet = true;
    }

    public void setConf(Configuration conf) {
        this.conf = conf instanceof RdfCloudTripleStoreConfiguration ? (RdfCloudTripleStoreConfiguration)conf : new AccumuloRdfConfiguration(conf);
        if (!this.isEvalDaoSet) {
            if (this.conf.isUseStats().booleanValue() && this.conf.isUseSelectivity().booleanValue()) {
                try {
                    this.eval = new AccumuloSelectivityEvalDAO(this.conf, ConfigUtils.getConnector((Configuration)this.conf));
                    ((AccumuloSelectivityEvalDAO)this.eval).setRdfEvalDAO((RdfEvalStatsDAO)new ProspectorServiceEvalStatsDAO(ConfigUtils.getConnector((Configuration)this.conf), this.conf));
                    this.eval.init();
                }
                catch (AccumuloException | AccumuloSecurityException e) {
                    LOG.warn("A problem was encountered while setting the Configuration for the EntityOptimizer.", e);
                }
                this.isEvalDaoSet = true;
            } else {
                this.eval = null;
                this.isEvalDaoSet = true;
            }
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit((QueryModelVisitor)new JoinVisitor());
    }

    protected class JoinVisitor
    extends AbstractQueryModelVisitor<RuntimeException> {
        protected JoinVisitor() {
        }

        public void meet(Join node) {
            try {
                if (node.getLeftArg() instanceof FixedStatementPattern && node.getRightArg() instanceof DoNotExpandSP) {
                    return;
                }
                ArrayList<TupleExpr> joinArgs = this.getJoinArgs((TupleExpr)node, new ArrayList());
                HashMultimap<String, StatementPattern> varMap = this.getVarBins(joinArgs);
                while (!varMap.keySet().isEmpty()) {
                    String s = this.getHighestPriorityKey(varMap);
                    this.constructTuple(varMap, joinArgs, s);
                }
                List<TupleExpr> filterChain = this.getFilterChain(joinArgs);
                for (TupleExpr te : joinArgs) {
                    if (te instanceof StatementPattern && te instanceof EntityTupleSet) continue;
                    te.visit((QueryModelVisitor)this);
                }
                node.replaceWith((QueryModelNode)this.getNewJoin(joinArgs, filterChain));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private List<TupleExpr> getFilterChain(List<TupleExpr> joinArgs) {
            ArrayList filterTopBottom = Lists.newArrayList();
            TupleExpr filterChainTop = null;
            TupleExpr filterChainBottom = null;
            for (int i = 0; i < joinArgs.size(); ++i) {
                if (!(joinArgs.get(i) instanceof Filter)) continue;
                if (filterChainTop == null) {
                    filterChainTop = joinArgs.remove(i);
                    --i;
                    continue;
                }
                if (filterChainBottom == null) {
                    filterChainBottom = joinArgs.remove(i);
                    ((Filter)filterChainTop).setArg(filterChainBottom);
                    --i;
                    continue;
                }
                ((Filter)filterChainBottom).setArg(joinArgs.remove(i));
                filterChainBottom = ((Filter)filterChainBottom).getArg();
                --i;
            }
            if (filterChainTop != null) {
                filterTopBottom.add(filterChainTop);
            }
            if (filterChainBottom != null) {
                filterTopBottom.add(filterChainBottom);
            }
            return filterTopBottom;
        }

        private TupleExpr getNewJoin(List<TupleExpr> joinArgs, List<TupleExpr> filterChain) {
            TupleExpr newJoin;
            if (joinArgs.size() > 1) {
                if (filterChain.size() > 0) {
                    TupleExpr tempJoin;
                    TupleExpr finalJoinArg = joinArgs.remove(0);
                    TupleExpr temp = filterChain.get(0);
                    if (joinArgs.size() > 1) {
                        tempJoin = new Join(joinArgs.remove(0), joinArgs.remove(0));
                        for (TupleExpr te : joinArgs) {
                            tempJoin = new Join(tempJoin, te);
                        }
                    } else {
                        tempJoin = joinArgs.remove(0);
                    }
                    if (filterChain.size() == 1) {
                        ((Filter)temp).setArg(tempJoin);
                    } else {
                        ((Filter)filterChain.get(1)).setArg(tempJoin);
                    }
                    newJoin = new Join(temp, finalJoinArg);
                } else {
                    newJoin = new Join(joinArgs.get(0), joinArgs.get(1));
                    joinArgs.remove(0);
                    joinArgs.remove(0);
                    for (TupleExpr te : joinArgs) {
                        newJoin = new Join(newJoin, te);
                    }
                }
            } else if (joinArgs.size() == 1) {
                if (filterChain.size() > 0) {
                    newJoin = filterChain.get(0);
                    if (filterChain.size() == 1) {
                        ((Filter)newJoin).setArg(joinArgs.get(0));
                    } else {
                        ((Filter)filterChain.get(1)).setArg(joinArgs.get(0));
                    }
                } else {
                    newJoin = joinArgs.get(0);
                }
            } else {
                throw new IllegalStateException("JoinArgs size cannot be zero.");
            }
            return newJoin;
        }

        private HashMultimap<String, StatementPattern> getVarBins(List<TupleExpr> nodes) {
            HashMultimap varMap = HashMultimap.create();
            for (QueryModelNode queryModelNode : nodes) {
                StatementPattern sp;
                if (!(queryModelNode instanceof StatementPattern) || !(sp = (StatementPattern)queryModelNode).getPredicateVar().isConstant()) continue;
                varMap.put((Object)sp.getSubjectVar().getName(), (Object)sp);
                varMap.put((Object)sp.getObjectVar().getName(), (Object)sp);
            }
            this.removeInvalidBins((HashMultimap<String, StatementPattern>)varMap, true);
            return varMap;
        }

        private void updateVarMap(HashMultimap<String, StatementPattern> varMap, Set<StatementPattern> bin) {
            for (StatementPattern sp : bin) {
                varMap.remove((Object)sp.getSubjectVar().getName(), (Object)sp);
                varMap.remove((Object)sp.getObjectVar().getName(), (Object)sp);
            }
            this.removeInvalidBins(varMap, false);
        }

        private void removeInvalidBins(HashMultimap<String, StatementPattern> varMap, boolean newMap) {
            HashSet keys = Sets.newHashSet((Iterable)varMap.keySet());
            if (newMap) {
                for (String s : keys) {
                    HashSet spSet = Sets.newHashSet((Iterable)varMap.get((Object)s));
                    if (StarQuery.isValidStarQuery(spSet)) continue;
                    for (StatementPattern sp : spSet) {
                        varMap.remove((Object)s, (Object)sp);
                    }
                }
            } else {
                for (String s : keys) {
                    HashSet spSet = Sets.newHashSet((Iterable)varMap.get((Object)s));
                    if (spSet.size() != 1) continue;
                    for (StatementPattern sp : spSet) {
                        varMap.remove((Object)s, (Object)sp);
                    }
                }
            }
        }

        private void constructTuple(HashMultimap<String, StatementPattern> varMap, List<TupleExpr> joinArgs, String binName) {
            HashSet bin = Sets.newHashSet((Iterable)varMap.get((Object)binName));
            StarQuery sq = new StarQuery(bin);
            this.updateVarMap(varMap, bin);
            for (StatementPattern sp : bin) {
                joinArgs.remove(sp);
            }
            joinArgs.add((TupleExpr)new EntityTupleSet(sq, EntityOptimizer.this.conf));
        }

        private String getHighestPriorityKey(HashMultimap<String, StatementPattern> varMap) {
            double tempPriority = -1.0;
            double priority = -1.7976931348623157E308;
            String priorityKey = "";
            Set bin = null;
            Set keys = varMap.keySet();
            for (String s : keys) {
                bin = varMap.get((Object)s);
                tempPriority = bin.size();
                tempPriority *= this.getCardinality(bin);
                tempPriority *= this.getMinCardSp(bin);
                if (VarNameUtils.isConstant((String)s)) {
                    tempPriority *= 10.0;
                }
                if (!(tempPriority > priority)) continue;
                priority = tempPriority;
                priorityKey = s;
            }
            return priorityKey;
        }

        private double getMinCardSp(Collection<StatementPattern> nodes) {
            double cardinality = Double.MAX_VALUE;
            double tempCard = -1.0;
            if (EntityOptimizer.this.eval == null) {
                return 1.0;
            }
            for (StatementPattern sp : nodes) {
                try {
                    tempCard = EntityOptimizer.this.eval.getCardinality(EntityOptimizer.this.conf, sp);
                    if (!(tempCard < cardinality)) continue;
                    cardinality = tempCard;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return cardinality;
        }

        private double getCardinality(Collection<StatementPattern> spNodes) {
            double cardinality = Double.MAX_VALUE;
            double tempCard = -1.0;
            if (EntityOptimizer.this.eval == null) {
                return 1.0;
            }
            ArrayList nodes = Lists.newArrayList(spNodes);
            AccumuloSelectivityEvalDAO ase = (AccumuloSelectivityEvalDAO)EntityOptimizer.this.eval;
            ase.setDenormalized(true);
            try {
                for (int i = 0; i < nodes.size(); ++i) {
                    for (int j = i + 1; j < nodes.size(); ++j) {
                        tempCard = ase.getJoinSelect(EntityOptimizer.this.conf, (TupleExpr)nodes.get(i), (TupleExpr)nodes.get(j));
                        if (!(tempCard < cardinality)) continue;
                        cardinality = tempCard;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ase.setDenormalized(false);
            return cardinality / (double)(nodes.size() + 1);
        }

        protected <L extends List<TupleExpr>> L getJoinArgs(TupleExpr tupleExpr, L joinArgs) {
            if (tupleExpr instanceof Join) {
                if (!(((Join)tupleExpr).getLeftArg() instanceof FixedStatementPattern) && !(((Join)tupleExpr).getRightArg() instanceof DoNotExpandSP)) {
                    Join join = (Join)tupleExpr;
                    this.getJoinArgs(join.getLeftArg(), joinArgs);
                    this.getJoinArgs(join.getRightArg(), joinArgs);
                }
            } else if (tupleExpr instanceof Filter) {
                joinArgs.add((TupleExpr)tupleExpr);
                this.getJoinArgs(((Filter)tupleExpr).getArg(), joinArgs);
            } else {
                joinArgs.add((TupleExpr)tupleExpr);
            }
            return joinArgs;
        }
    }
}

