/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.accumulo.entity;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;

public class EntityLocalityGroupSetter {
    String tablePrefix;
    Connector conn;
    Configuration conf;

    public EntityLocalityGroupSetter(String tablePrefix, Connector conn, Configuration conf) {
        this.conn = conn;
        this.tablePrefix = tablePrefix;
        this.conf = conf;
    }

    private Iterator<String> getPredicates() {
        String auths = this.conf.get("query.auth");
        BatchScanner bs = null;
        try {
            bs = this.conn.createBatchScanner(this.tablePrefix + "prospects", new Authorizations(new String[]{auths}), 10);
        }
        catch (TableNotFoundException e) {
            e.printStackTrace();
            throw new Error("Attempting to scan missing table: " + this.tablePrefix + "prospects", e);
        }
        bs.setRanges(Collections.singleton(Range.prefix((Text)new Text("predicate\u0000"))));
        final Iterator iter = bs.iterator();
        return new Iterator<String>(){
            private String next = null;
            private boolean hasNextCalled = false;
            private boolean isEmpty = false;

            @Override
            public boolean hasNext() {
                if (!this.hasNextCalled && !this.isEmpty) {
                    if (iter.hasNext()) {
                        Map.Entry temp = (Map.Entry)iter.next();
                        String row = ((Key)temp.getKey()).getRow().toString();
                        String[] rowArray = row.split("\u0000");
                        this.next = rowArray[1];
                        this.hasNextCalled = true;
                        return true;
                    }
                    this.isEmpty = true;
                    return false;
                }
                return !this.isEmpty;
            }

            @Override
            public String next() {
                if (this.hasNextCalled) {
                    this.hasNextCalled = false;
                    return this.next;
                }
                if (this.isEmpty) {
                    throw new NoSuchElementException();
                }
                if (this.hasNext()) {
                    this.hasNextCalled = false;
                    return this.next;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot delete from iterator!");
            }
        };
    }

    public void setLocalityGroups() {
        HashMap localityGroups = new HashMap();
        Iterator<String> groups = this.getPredicates();
        int i = 1;
        while (groups.hasNext()) {
            HashSet<Text> tempColumn = new HashSet<Text>();
            String temp = groups.next();
            tempColumn.add(new Text(temp));
            String groupName = "predicate" + i;
            localityGroups.put(groupName, tempColumn);
            ++i;
        }
        try {
            this.conn.tableOperations().setLocalityGroups(this.tablePrefix + "doc_partitioned_index", localityGroups);
        }
        catch (AccumuloException e) {
            e.printStackTrace();
        }
        catch (AccumuloSecurityException e) {
            e.printStackTrace();
        }
        catch (TableNotFoundException e) {
            e.printStackTrace();
        }
    }
}

