/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.accumulo.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Bytes;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.MultiTableBatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;
import org.apache.rya.accumulo.AccumuloRdfConfiguration;
import org.apache.rya.accumulo.AccumuloRdfConstants;
import org.apache.rya.accumulo.experimental.AbstractAccumuloIndexer;
import org.apache.rya.api.RdfCloudTripleStoreConfiguration;
import org.apache.rya.api.RdfCloudTripleStoreConstants;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.api.domain.RyaType;
import org.apache.rya.api.resolver.RyaContext;
import org.apache.rya.api.resolver.RyaTypeResolverException;
import org.apache.rya.api.resolver.triple.TripleRow;
import org.apache.rya.indexing.accumulo.ConfigUtils;
import org.eclipse.rdf4j.model.IRI;

public class EntityCentricIndex
extends AbstractAccumuloIndexer {
    private static final Logger logger = Logger.getLogger(EntityCentricIndex.class);
    private static final String TABLE_SUFFIX = "EntityCentricIndex";
    private static final String OBJECT = "object";
    private static final String SUBJECT = "subject";
    private AccumuloRdfConfiguration conf;
    private BatchWriter writer;
    private boolean isInit = false;

    private void initInternal() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, IOException, TableExistsException {
        ConfigUtils.createTableIfNotExists((Configuration)this.conf, this.getTableName());
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf instanceof AccumuloRdfConfiguration ? (AccumuloRdfConfiguration)conf : new AccumuloRdfConfiguration(conf);
        if (!this.isInit) {
            try {
                this.initInternal();
                this.isInit = true;
            }
            catch (AccumuloException e) {
                logger.warn((Object)"Unable to initialize index.  Throwing Runtime Exception. ", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (AccumuloSecurityException e) {
                logger.warn((Object)"Unable to initialize index.  Throwing Runtime Exception. ", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (TableNotFoundException e) {
                logger.warn((Object)"Unable to initialize index.  Throwing Runtime Exception. ", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (TableExistsException e) {
                logger.warn((Object)"Unable to initialize index.  Throwing Runtime Exception. ", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                logger.warn((Object)"Unable to initialize index.  Throwing Runtime Exception. ", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    public String getTableName() {
        return EntityCentricIndex.getTableName((Configuration)this.conf);
    }

    public static String getTableName(Configuration conf) {
        Objects.requireNonNull(conf);
        return ConfigUtils.getTablePrefix(conf) + TABLE_SUFFIX;
    }

    public static String makeTableName(String ryaInstanceName) {
        Objects.requireNonNull(ryaInstanceName);
        return ryaInstanceName + TABLE_SUFFIX;
    }

    public void setMultiTableBatchWriter(MultiTableBatchWriter writer) throws IOException {
        try {
            this.writer = writer.getBatchWriter(this.getTableName());
        }
        catch (AccumuloException e) {
            throw new IOException(e);
        }
        catch (AccumuloSecurityException e) {
            throw new IOException(e);
        }
        catch (TableNotFoundException e) {
            throw new IOException(e);
        }
    }

    public void storeStatement(RyaStatement stmt) throws IOException {
        Preconditions.checkNotNull((Object)this.writer, (Object)"BatchWriter not Set");
        try {
            for (TripleRow row : EntityCentricIndex.serializeStatement(stmt)) {
                this.writer.addMutation(EntityCentricIndex.createMutation(row));
            }
        }
        catch (MutationsRejectedException e) {
            throw new IOException(e);
        }
        catch (RyaTypeResolverException e) {
            throw new IOException(e);
        }
    }

    public void deleteStatement(RyaStatement stmt) throws IOException {
        Preconditions.checkNotNull((Object)this.writer, (Object)"BatchWriter not Set");
        try {
            for (TripleRow row : EntityCentricIndex.serializeStatement(stmt)) {
                this.writer.addMutation(this.deleteMutation(row));
            }
        }
        catch (MutationsRejectedException e) {
            throw new IOException(e);
        }
        catch (RyaTypeResolverException e) {
            throw new IOException(e);
        }
    }

    protected Mutation deleteMutation(TripleRow tripleRow) {
        Mutation m = new Mutation(new Text(tripleRow.getRow()));
        byte[] columnFamily = tripleRow.getColumnFamily();
        Text cfText = columnFamily == null ? RdfCloudTripleStoreConstants.EMPTY_TEXT : new Text(columnFamily);
        byte[] columnQualifier = tripleRow.getColumnQualifier();
        Text cqText = columnQualifier == null ? RdfCloudTripleStoreConstants.EMPTY_TEXT : new Text(columnQualifier);
        byte[] columnVisibility = tripleRow.getColumnVisibility();
        ColumnVisibility cv = columnVisibility == null ? AccumuloRdfConstants.EMPTY_CV : new ColumnVisibility(columnVisibility);
        m.putDelete(cfText, cqText, cv, tripleRow.getTimestamp().longValue());
        return m;
    }

    public static Collection<Mutation> createMutations(RyaStatement stmt) throws RyaTypeResolverException {
        ArrayList m = Lists.newArrayList();
        for (TripleRow tr : EntityCentricIndex.serializeStatement(stmt)) {
            m.add(EntityCentricIndex.createMutation(tr));
        }
        return m;
    }

    private static Mutation createMutation(TripleRow tripleRow) {
        Mutation mutation = new Mutation(new Text(tripleRow.getRow()));
        byte[] columnVisibility = tripleRow.getColumnVisibility();
        ColumnVisibility cv = columnVisibility == null ? AccumuloRdfConstants.EMPTY_CV : new ColumnVisibility(columnVisibility);
        Long timestamp = tripleRow.getTimestamp();
        byte[] value = tripleRow.getValue();
        Value v = value == null ? AccumuloRdfConstants.EMPTY_VALUE : new Value(value);
        byte[] columnQualifier = tripleRow.getColumnQualifier();
        Text cqText = columnQualifier == null ? RdfCloudTripleStoreConstants.EMPTY_TEXT : new Text(columnQualifier);
        byte[] columnFamily = tripleRow.getColumnFamily();
        Text cfText = columnFamily == null ? RdfCloudTripleStoreConstants.EMPTY_TEXT : new Text(columnFamily);
        mutation.put(cfText, cqText, cv, timestamp.longValue(), v);
        return mutation;
    }

    private static List<TripleRow> serializeStatement(RyaStatement stmt) throws RyaTypeResolverException {
        RyaIRI subject = stmt.getSubject();
        RyaIRI predicate = stmt.getPredicate();
        RyaType object = stmt.getObject();
        RyaIRI context = stmt.getContext();
        Long timestamp = stmt.getTimestamp();
        byte[] columnVisibility = stmt.getColumnVisibility();
        byte[] value = stmt.getValue();
        assert (subject != null && predicate != null && object != null);
        byte[] cf = context == null ? RdfCloudTripleStoreConstants.EMPTY_BYTES : context.getData().getBytes(StandardCharsets.UTF_8);
        byte[] subjBytes = subject.getData().getBytes(StandardCharsets.UTF_8);
        byte[] predBytes = predicate.getData().getBytes(StandardCharsets.UTF_8);
        byte[][] objBytes = RyaContext.getInstance().serializeType(object);
        return Lists.newArrayList((Object[])new TripleRow[]{new TripleRow(subjBytes, predBytes, Bytes.concat((byte[][])new byte[][]{cf, RdfCloudTripleStoreConstants.DELIM_BYTES, OBJECT.getBytes(StandardCharsets.UTF_8), RdfCloudTripleStoreConstants.DELIM_BYTES, objBytes[0], objBytes[1]}), timestamp, columnVisibility, value), new TripleRow(objBytes[0], predBytes, Bytes.concat((byte[][])new byte[][]{cf, RdfCloudTripleStoreConstants.DELIM_BYTES, SUBJECT.getBytes(StandardCharsets.UTF_8), RdfCloudTripleStoreConstants.DELIM_BYTES, subjBytes, objBytes[1]}), timestamp, columnVisibility, value)});
    }

    public static RyaStatement deserializeStatement(Key key, Value value) throws RyaTypeResolverException, IOException {
        byte[] objectBytes;
        RyaIRI subject;
        assert (key != null);
        assert (value != null);
        byte[] entityBytes = key.getRowData().toArray();
        byte[] predicateBytes = key.getColumnFamilyData().toArray();
        byte[] data = key.getColumnQualifierData().toArray();
        long timestamp = key.getTimestamp();
        byte[] columnVisibility = key.getColumnVisibilityData().toArray();
        byte[] valueBytes = value.get();
        int split = Bytes.indexOf((byte[])data, (byte[])RdfCloudTripleStoreConstants.DELIM_BYTES);
        byte[] columnFamily = Arrays.copyOf(data, split);
        byte[] edgeBytes = Arrays.copyOfRange(data, split + RdfCloudTripleStoreConstants.DELIM_BYTES.length, data.length);
        split = Bytes.indexOf((byte[])edgeBytes, (byte[])RdfCloudTripleStoreConstants.DELIM_BYTES);
        String otherNodeVar = new String(Arrays.copyOf(edgeBytes, split), StandardCharsets.UTF_8);
        byte[] otherNodeBytes = Arrays.copyOfRange(edgeBytes, split + RdfCloudTripleStoreConstants.DELIM_BYTES.length, edgeBytes.length);
        split = Bytes.indexOf((byte[])otherNodeBytes, (byte[])RdfCloudTripleStoreConstants.TYPE_DELIM_BYTES);
        byte[] otherNodeData = Arrays.copyOf(otherNodeBytes, split);
        byte[] typeBytes = Arrays.copyOfRange(otherNodeBytes, split, otherNodeBytes.length);
        RyaIRI predicate = new RyaIRI(new String(predicateBytes, StandardCharsets.UTF_8));
        RyaIRI context = null;
        switch (otherNodeVar) {
            case "subject": {
                subject = new RyaIRI(new String(otherNodeData, StandardCharsets.UTF_8));
                objectBytes = Bytes.concat((byte[][])new byte[][]{entityBytes, typeBytes});
                break;
            }
            case "object": {
                subject = new RyaIRI(new String(entityBytes, StandardCharsets.UTF_8));
                objectBytes = Bytes.concat((byte[][])new byte[][]{otherNodeData, typeBytes});
                break;
            }
            default: {
                throw new IOException("Failed to deserialize entity-centric index row. Expected 'subject' or 'object', encountered: '" + otherNodeVar + "'");
            }
        }
        RyaType object = RyaContext.getInstance().deserialize(objectBytes);
        if (columnFamily != null && columnFamily.length > 0) {
            context = new RyaIRI(new String(columnFamily, StandardCharsets.UTF_8));
        }
        return new RyaStatement(subject, predicate, object, context, null, columnVisibility, valueBytes, Long.valueOf(timestamp));
    }

    public static RyaType getRyaType(Key key, Value value) throws RyaTypeResolverException, IOException {
        assert (key != null);
        assert (value != null);
        byte[] entityBytes = key.getRowData().toArray();
        byte[] data = key.getColumnQualifierData().toArray();
        int split = Bytes.indexOf((byte[])data, (byte[])RdfCloudTripleStoreConstants.DELIM_BYTES);
        byte[] edgeBytes = Arrays.copyOfRange(data, split + RdfCloudTripleStoreConstants.DELIM_BYTES.length, data.length);
        split = Bytes.indexOf((byte[])edgeBytes, (byte[])RdfCloudTripleStoreConstants.DELIM_BYTES);
        String otherNodeVar = new String(Arrays.copyOf(edgeBytes, split), StandardCharsets.UTF_8);
        byte[] otherNodeBytes = Arrays.copyOfRange(edgeBytes, split + RdfCloudTripleStoreConstants.DELIM_BYTES.length, edgeBytes.length);
        split = Bytes.indexOf((byte[])otherNodeBytes, (byte[])RdfCloudTripleStoreConstants.TYPE_DELIM_BYTES);
        byte[] typeBytes = Arrays.copyOfRange(otherNodeBytes, split, otherNodeBytes.length);
        RyaIRI type = null;
        switch (otherNodeVar) {
            case "subject": {
                byte[] objectBytes = Bytes.concat((byte[][])new byte[][]{entityBytes, typeBytes});
                RyaType object = RyaContext.getInstance().deserialize(objectBytes);
                type = object;
                break;
            }
            case "object": {
                RyaIRI subject;
                type = subject = new RyaIRI(new String(entityBytes, StandardCharsets.UTF_8));
                break;
            }
            default: {
                throw new IOException("Failed to deserialize entity-centric index row. Expected 'subject' or 'object', encountered: '" + otherNodeVar + "'");
            }
        }
        return type;
    }

    public void init() {
    }

    public void setConnector(Connector connector) {
    }

    public void destroy() {
    }

    public void purge(RdfCloudTripleStoreConfiguration configuration) {
    }

    public void dropAndDestroy() {
    }

    public Set<IRI> getIndexablePredicates() {
        return null;
    }
}

