/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.accumulo.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Sets;
import com.google.common.primitives.Bytes;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.rya.accumulo.AccumuloRdfConfiguration;
import org.apache.rya.accumulo.documentIndex.DocumentIndexIntersectingIterator;
import org.apache.rya.api.RdfCloudTripleStoreConfiguration;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.api.domain.RyaType;
import org.apache.rya.api.resolver.RyaContext;
import org.apache.rya.api.resolver.RyaToRdfConversions;
import org.apache.rya.api.resolver.RyaTypeResolverException;
import org.apache.rya.indexing.DocIdIndexer;
import org.apache.rya.indexing.accumulo.ConfigUtils;
import org.apache.rya.indexing.accumulo.entity.EntityCentricIndex;
import org.apache.rya.indexing.accumulo.entity.StarQuery;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.query.algebra.helpers.StatementPatternCollector;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.sparql.SPARQLParser;

public class AccumuloDocIdIndexer
implements DocIdIndexer {
    private BatchScanner bs;
    private final AccumuloRdfConfiguration conf;

    public AccumuloDocIdIndexer(RdfCloudTripleStoreConfiguration conf) throws AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((boolean)(conf instanceof RdfCloudTripleStoreConfiguration), (Object)"conf must be isntance of RdfCloudTripleStoreConfiguration");
        this.conf = (AccumuloRdfConfiguration)conf;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> queryDocIndex(String sparqlQuery, Collection<BindingSet> constraints) throws TableNotFoundException, QueryEvaluationException {
        SPARQLParser parser = new SPARQLParser();
        ParsedQuery pq1 = null;
        try {
            pq1 = parser.parseQuery(sparqlQuery, null);
        }
        catch (MalformedQueryException e) {
            e.printStackTrace();
            throw new QueryEvaluationException("Malformed query. query=" + sparqlQuery, (Throwable)e);
        }
        TupleExpr te1 = pq1.getTupleExpr();
        List spList1 = StatementPatternCollector.process((QueryModelNode)te1);
        if (StarQuery.isValidStarQuery(spList1)) {
            StarQuery sq1 = new StarQuery(spList1);
            return this.queryDocIndex(sq1, constraints);
        }
        throw new IllegalArgumentException("Invalid star query!");
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> queryDocIndex(StarQuery query, Collection<BindingSet> constraints) throws TableNotFoundException, QueryEvaluationException {
        HashSet unCommonVarNames;
        Set<Object> commonVarNames;
        final StarQuery starQ = query;
        final Iterator<BindingSet> bs = constraints.iterator();
        Iterator<BindingSet> bs2 = constraints.iterator();
        if (bs2.hasNext()) {
            BindingSet currBs = bs2.next();
            commonVarNames = StarQuery.getCommonVars(query, currBs);
            unCommonVarNames = Sets.difference((Set)currBs.getBindingNames(), (Set)commonVarNames);
        } else {
            commonVarNames = Sets.newHashSet();
            unCommonVarNames = Sets.newHashSet();
        }
        if (commonVarNames.size() == 1 && !query.commonVarConstant() && commonVarNames.contains(query.getCommonVarName())) {
            final HashMultimap map = HashMultimap.create();
            String commonVar = starQ.getCommonVarName();
            HashSet ranges = Sets.newHashSet();
            while (bs.hasNext()) {
                BindingSet currentBs = bs.next();
                if (currentBs.getBinding(commonVar) == null) continue;
                String row = currentBs.getBinding(commonVar).getValue().stringValue();
                ranges.add(new Range((CharSequence)row));
                map.put((Object)row, (Object)currentBs);
            }
            final BatchScanner scan = this.runQuery(starQ, ranges);
            final Iterator intersections = scan.iterator();
            return new CloseableIteration<BindingSet, QueryEvaluationException>(){
                private QueryBindingSet currentSolutionBs = null;
                private boolean hasNextCalled = false;
                private boolean isEmpty = false;
                private Iterator<BindingSet> inputSet = new ArrayList().iterator();
                private BindingSet currentBs;
                private Key key;

                public boolean hasNext() throws QueryEvaluationException {
                    if (!this.hasNextCalled && !this.isEmpty) {
                        while (this.inputSet.hasNext() || intersections.hasNext()) {
                            if (!this.inputSet.hasNext()) {
                                this.key = (Key)((Map.Entry)intersections.next()).getKey();
                                this.inputSet = map.get((Object)this.key.getRow().toString()).iterator();
                            }
                            this.currentBs = this.inputSet.next();
                            this.currentSolutionBs = AccumuloDocIdIndexer.this.deserializeKey(this.key, starQ, this.currentBs, unCommonVarNames);
                            if (this.currentSolutionBs.size() != unCommonVarNames.size() + starQ.getUnCommonVars().size() + 1) continue;
                            this.hasNextCalled = true;
                            return true;
                        }
                        this.isEmpty = true;
                        return false;
                    }
                    return !this.isEmpty;
                }

                public BindingSet next() throws QueryEvaluationException {
                    if (this.hasNextCalled) {
                        this.hasNextCalled = false;
                    } else {
                        if (this.isEmpty) {
                            throw new NoSuchElementException();
                        }
                        if (this.hasNext()) {
                            this.hasNextCalled = false;
                        } else {
                            throw new NoSuchElementException();
                        }
                    }
                    return this.currentSolutionBs;
                }

                public void remove() throws QueryEvaluationException {
                    throw new UnsupportedOperationException();
                }

                public void close() throws QueryEvaluationException {
                    scan.close();
                }
            };
        }
        return new CloseableIteration<BindingSet, QueryEvaluationException>(){
            private Iterator<Map.Entry<Key, org.apache.accumulo.core.data.Value>> intersections = null;
            private QueryBindingSet currentSolutionBs = null;
            private boolean hasNextCalled = false;
            private boolean isEmpty = false;
            private boolean init = false;
            private BindingSet currentBs;
            private StarQuery sq = new StarQuery(starQ);
            private final Set<Range> emptyRangeSet = Sets.newHashSet();
            private BatchScanner scan;

            public void remove() throws QueryEvaluationException {
                throw new UnsupportedOperationException();
            }

            public BindingSet next() throws QueryEvaluationException {
                if (this.hasNextCalled) {
                    this.hasNextCalled = false;
                } else {
                    if (this.isEmpty) {
                        throw new NoSuchElementException();
                    }
                    if (this.hasNext()) {
                        this.hasNextCalled = false;
                    } else {
                        throw new NoSuchElementException();
                    }
                }
                return this.currentSolutionBs;
            }

            public boolean hasNext() throws QueryEvaluationException {
                if (!this.init) {
                    if (this.intersections == null && bs.hasNext()) {
                        this.currentBs = (BindingSet)bs.next();
                        this.sq = StarQuery.getConstrainedStarQuery(this.sq, this.currentBs);
                        this.scan = AccumuloDocIdIndexer.this.runQuery(this.sq, this.emptyRangeSet);
                        this.intersections = this.scan.iterator();
                    } else if (this.intersections == null && !bs.hasNext()) {
                        this.currentBs = new QueryBindingSet();
                        this.scan = AccumuloDocIdIndexer.this.runQuery(starQ, this.emptyRangeSet);
                        this.intersections = this.scan.iterator();
                    }
                    this.init = true;
                }
                if (!this.hasNextCalled && !this.isEmpty) {
                    while (this.intersections.hasNext() || bs.hasNext()) {
                        if (!this.intersections.hasNext()) {
                            this.scan.close();
                            this.currentBs = (BindingSet)bs.next();
                            this.sq = StarQuery.getConstrainedStarQuery(this.sq, this.currentBs);
                            this.scan = AccumuloDocIdIndexer.this.runQuery(this.sq, this.emptyRangeSet);
                            this.intersections = this.scan.iterator();
                        }
                        if (!this.intersections.hasNext()) continue;
                        this.currentSolutionBs = AccumuloDocIdIndexer.this.deserializeKey(this.intersections.next().getKey(), this.sq, this.currentBs, unCommonVarNames);
                        if (this.sq.commonVarConstant() && this.currentSolutionBs.size() == unCommonVarNames.size() + this.sq.getUnCommonVars().size()) {
                            this.hasNextCalled = true;
                            return true;
                        }
                        if (this.currentSolutionBs.size() != unCommonVarNames.size() + this.sq.getUnCommonVars().size() + 1) continue;
                        this.hasNextCalled = true;
                        return true;
                    }
                    this.isEmpty = true;
                    return false;
                }
                return !this.isEmpty;
            }

            public void close() throws QueryEvaluationException {
                this.scan.close();
            }
        };
    }

    private QueryBindingSet deserializeKey(Key key, StarQuery sq, BindingSet currentBs, Set<String> unCommonVar) {
        QueryBindingSet currentSolutionBs = new QueryBindingSet();
        Text row = key.getRow();
        Text cq = key.getColumnQualifier();
        String[] cqArray = cq.toString().split("\u001d\u001e");
        boolean commonVarSet = false;
        if (sq.commonVarConstant()) {
            commonVarSet = true;
        }
        if (!commonVarSet && sq.isCommonVarURI()) {
            RyaIRI rIRI = new RyaIRI(row.toString());
            currentSolutionBs.addBinding(sq.getCommonVarName(), RyaToRdfConversions.convertValue((RyaType)rIRI));
            commonVarSet = true;
        }
        for (String s : sq.getUnCommonVars()) {
            Value v;
            byte[] object;
            byte[] cqBytes = cqArray[sq.getVarPos().get(s)].getBytes(StandardCharsets.UTF_8);
            int firstIndex = Bytes.indexOf((byte[])cqBytes, (byte)0);
            int secondIndex = Bytes.lastIndexOf((byte[])cqBytes, (byte)0);
            int typeIndex = Bytes.indexOf((byte[])cqBytes, (byte)1);
            String tripleComponent = new String(Arrays.copyOfRange(cqBytes, firstIndex + 1, secondIndex), StandardCharsets.UTF_8);
            byte[] cqContent = Arrays.copyOfRange(cqBytes, secondIndex + 1, typeIndex);
            byte[] objType = Arrays.copyOfRange(cqBytes, typeIndex, cqBytes.length);
            if (tripleComponent.equals("object")) {
                object = Bytes.concat((byte[][])new byte[][]{cqContent, objType});
                v = null;
                try {
                    v = RyaToRdfConversions.convertValue((RyaType)RyaContext.getInstance().deserialize(object));
                }
                catch (RyaTypeResolverException e) {
                    e.printStackTrace();
                }
                currentSolutionBs.addBinding(s, v);
                continue;
            }
            if (tripleComponent.equals("subject")) {
                if (!commonVarSet) {
                    object = Bytes.concat((byte[][])new byte[][]{row.getBytes(), objType});
                    v = null;
                    try {
                        v = RyaToRdfConversions.convertValue((RyaType)RyaContext.getInstance().deserialize(object));
                    }
                    catch (RyaTypeResolverException e) {
                        e.printStackTrace();
                    }
                    currentSolutionBs.addBinding(sq.getCommonVarName(), v);
                    commonVarSet = true;
                }
                RyaIRI rIRI = new RyaIRI(new String(cqContent, StandardCharsets.UTF_8));
                currentSolutionBs.addBinding(s, RyaToRdfConversions.convertValue((RyaType)rIRI));
                continue;
            }
            throw new IllegalArgumentException("Invalid row.");
        }
        for (String s : unCommonVar) {
            currentSolutionBs.addBinding(s, currentBs.getValue(s));
        }
        return currentSolutionBs;
    }

    private BatchScanner runQuery(StarQuery query, Collection<Range> ranges) throws QueryEvaluationException {
        try {
            String authsStr;
            if (ranges.size() == 0) {
                String rangeText = query.getCommonVarValue();
                Range r = rangeText != null ? new Range(new Text(query.getCommonVarValue())) : new Range();
                ranges = Collections.singleton(r);
            }
            Connector accCon = ConfigUtils.getConnector((Configuration)this.conf);
            IteratorSetting is = new IteratorSetting(30, "fii", DocumentIndexIntersectingIterator.class);
            DocumentIndexIntersectingIterator.setColumnFamilies(is, query.getColumnCond());
            if (query.hasContext()) {
                DocumentIndexIntersectingIterator.setContext(is, query.getContextURI());
            }
            Authorizations auths = (authsStr = this.conf.get("query.auth")) == null || authsStr.isEmpty() ? new Authorizations() : new Authorizations(new String[]{authsStr});
            this.bs = accCon.createBatchScanner(EntityCentricIndex.getTableName((Configuration)this.conf), auths, 15);
            this.bs.addScanIterator(is);
            this.bs.setRanges(ranges);
            return this.bs;
        }
        catch (AccumuloException | AccumuloSecurityException | TableNotFoundException e) {
            throw new QueryEvaluationException(e);
        }
    }

    @Override
    public void close() throws IOException {
    }
}

