/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.accumulo;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.MultiTableBatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.client.mock.MockInstance;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.log4j.Logger;
import org.apache.rya.accumulo.AccumuloRdfConfiguration;
import org.apache.rya.accumulo.utils.ConnectorFactory;
import org.apache.rya.api.RdfCloudTripleStoreConfiguration;
import org.apache.rya.indexing.FilterFunctionOptimizer;
import org.apache.rya.indexing.accumulo.entity.EntityCentricIndex;
import org.apache.rya.indexing.accumulo.entity.EntityOptimizer;
import org.apache.rya.indexing.accumulo.freetext.AccumuloFreeTextIndexer;
import org.apache.rya.indexing.accumulo.freetext.LuceneTokenizer;
import org.apache.rya.indexing.accumulo.freetext.Tokenizer;
import org.apache.rya.indexing.accumulo.temporal.AccumuloTemporalIndexer;
import org.apache.rya.indexing.entity.EntityIndexOptimizer;
import org.apache.rya.indexing.entity.update.mongo.MongoEntityIndexer;
import org.apache.rya.indexing.external.PrecomputedJoinIndexer;
import org.apache.rya.indexing.mongodb.freetext.MongoFreeTextIndexer;
import org.apache.rya.indexing.mongodb.temporal.MongoTemporalIndexer;
import org.apache.rya.indexing.pcj.matching.PCJOptimizer;
import org.apache.rya.indexing.statement.metadata.matching.StatementMetadataOptimizer;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public class ConfigUtils {
    private static final Logger logger = Logger.getLogger(ConfigUtils.class);
    @Deprecated
    public static final String CLOUDBASE_TBL_PREFIX = "query.tblprefix";
    @Deprecated
    public static final String CLOUDBASE_INSTANCE = "sc.cloudbase.instancename";
    @Deprecated
    public static final String CLOUDBASE_ZOOKEEPERS = "sc.cloudbase.zookeepers";
    @Deprecated
    public static final String CLOUDBASE_USER = "sc.cloudbase.username";
    @Deprecated
    public static final String CLOUDBASE_PASSWORD = "sc.cloudbase.password";
    @Deprecated
    public static final String CLOUDBASE_AUTHS = "query.auth";
    public static final String CLOUDBASE_WRITER_MAX_WRITE_THREADS = "sc.cloudbase.writer.maxwritethreads";
    public static final String CLOUDBASE_WRITER_MAX_LATENCY = "sc.cloudbase.writer.maxlatency";
    public static final String CLOUDBASE_WRITER_MAX_MEMORY = "sc.cloudbase.writer.maxmemory";
    public static final String FREE_TEXT_QUERY_TERM_LIMIT = "sc.freetext.querytermlimit";
    public static final String USE_FREETEXT = "sc.use_freetext";
    public static final String USE_TEMPORAL = "sc.use_temporal";
    public static final String USE_ENTITY = "sc.use_entity";
    public static final String USE_PCJ = "sc.use_pcj";
    public static final String USE_OPTIMAL_PCJ = "sc.use.optimal.pcj";
    public static final String USE_PCJ_UPDATER_INDEX = "sc.use.updater";
    public static final String FLUO_APP_NAME = "rya.indexing.pcj.fluo.fluoAppName";
    public static final String USE_PCJ_FLUO_UPDATER = "rya.indexing.pcj.updater.fluo";
    public static final String PCJ_STORAGE_TYPE = "rya.indexing.pcj.storageType";
    public static final String PCJ_UPDATER_TYPE = "rya.indexing.pcj.updaterType";
    public static final String USE_MOCK_INSTANCE = ".useMockInstance";
    public static final String NUM_PARTITIONS = "sc.cloudbase.numPartitions";
    private static final int WRITER_MAX_WRITE_THREADS = 1;
    private static final long WRITER_MAX_LATNECY = Long.MAX_VALUE;
    private static final long WRITER_MAX_MEMORY = 10000L;
    public static final String DISPLAY_QUERY_PLAN = "query.printqueryplan";
    public static final String FREETEXT_PREDICATES_LIST = "sc.freetext.predicates";
    public static final String FREETEXT_DOC_NUM_PARTITIONS = "sc.freetext.numPartitions.text";
    public static final String FREETEXT_TERM_NUM_PARTITIONS = "sc.freetext.numPartitions.term";
    public static final String TOKENIZER_CLASS = "sc.freetext.tokenizer.class";
    public static final String GEO_PREDICATES_LIST = "sc.geo.predicates";
    public static final String TEMPORAL_PREDICATES_LIST = "sc.temporal.predicates";
    public static final String USE_MONGO = "sc.useMongo";

    public static boolean isDisplayQueryPlan(Configuration conf) {
        return conf.getBoolean(DISPLAY_QUERY_PLAN, false);
    }

    private static String getStringCheckSet(Configuration conf, String key) {
        String value = conf.get(key);
        Objects.requireNonNull(value, key + " not set");
        return value;
    }

    public static boolean createTableIfNotExists(Configuration conf, String tablename) throws AccumuloException, AccumuloSecurityException, TableExistsException {
        TableOperations tops = ConfigUtils.getConnector(conf).tableOperations();
        if (!tops.exists(tablename)) {
            logger.info((Object)("Creating table: " + tablename));
            tops.create(tablename);
            return true;
        }
        return false;
    }

    public static String getTablePrefix(Configuration conf) {
        String tablePrefix = conf.get(CLOUDBASE_TBL_PREFIX);
        Objects.requireNonNull(tablePrefix, "Configuration key: query.tblprefix not set.  Cannot generate table name.");
        return tablePrefix;
    }

    public static int getFreeTextTermLimit(Configuration conf) {
        return conf.getInt(FREE_TEXT_QUERY_TERM_LIMIT, 100);
    }

    public static Set<IRI> getFreeTextPredicates(Configuration conf) {
        return ConfigUtils.getPredicates(conf, FREETEXT_PREDICATES_LIST);
    }

    public static Set<IRI> getGeoPredicates(Configuration conf) {
        return ConfigUtils.getPredicates(conf, GEO_PREDICATES_LIST);
    }

    public static Set<IRI> getTemporalPredicates(Configuration conf) {
        return ConfigUtils.getPredicates(conf, TEMPORAL_PREDICATES_LIST);
    }

    protected static Set<IRI> getPredicates(Configuration conf, String confName) {
        String[] validPredicateStrings = conf.getStrings(confName, new String[0]);
        HashSet<IRI> predicates = new HashSet<IRI>();
        for (String prediateString : validPredicateStrings) {
            predicates.add(SimpleValueFactory.getInstance().createIRI(prediateString));
        }
        return predicates;
    }

    public static Tokenizer getFreeTextTokenizer(Configuration conf) {
        Class c = conf.getClass(TOKENIZER_CLASS, LuceneTokenizer.class, Tokenizer.class);
        return (Tokenizer)ReflectionUtils.newInstance((Class)c, (Configuration)conf);
    }

    public static BatchWriter createDefaultBatchWriter(String tablename, Configuration conf) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        Long DEFAULT_MAX_MEMORY = ConfigUtils.getWriterMaxMemory(conf);
        Long DEFAULT_MAX_LATENCY = ConfigUtils.getWriterMaxLatency(conf);
        Integer DEFAULT_MAX_WRITE_THREADS = ConfigUtils.getWriterMaxWriteThreads(conf);
        Connector connector = ConfigUtils.getConnector(conf);
        return connector.createBatchWriter(tablename, DEFAULT_MAX_MEMORY.longValue(), DEFAULT_MAX_LATENCY.longValue(), DEFAULT_MAX_WRITE_THREADS.intValue());
    }

    public static MultiTableBatchWriter createMultitableBatchWriter(Configuration conf) throws AccumuloException, AccumuloSecurityException {
        Long DEFAULT_MAX_MEMORY = ConfigUtils.getWriterMaxMemory(conf);
        Long DEFAULT_MAX_LATENCY = ConfigUtils.getWriterMaxLatency(conf);
        Integer DEFAULT_MAX_WRITE_THREADS = ConfigUtils.getWriterMaxWriteThreads(conf);
        Connector connector = ConfigUtils.getConnector(conf);
        return connector.createMultiTableBatchWriter(DEFAULT_MAX_MEMORY.longValue(), DEFAULT_MAX_LATENCY.longValue(), DEFAULT_MAX_WRITE_THREADS.intValue());
    }

    public static Scanner createScanner(String tablename, Configuration conf) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        Connector connector = ConfigUtils.getConnector(conf);
        Authorizations auths = ConfigUtils.getAuthorizations(conf);
        return connector.createScanner(tablename, auths);
    }

    public static BatchScanner createBatchScanner(String tablename, Configuration conf) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        Connector connector = ConfigUtils.getConnector(conf);
        Authorizations auths = ConfigUtils.getAuthorizations(conf);
        Integer numThreads = null;
        numThreads = conf instanceof RdfCloudTripleStoreConfiguration ? ((RdfCloudTripleStoreConfiguration)conf).getNumThreads() : Integer.valueOf(conf.getInt("query.numthreads", 2));
        return connector.createBatchScanner(tablename, auths, numThreads.intValue());
    }

    public static int getWriterMaxWriteThreads(Configuration conf) {
        return conf.getInt(CLOUDBASE_WRITER_MAX_WRITE_THREADS, 1);
    }

    public static long getWriterMaxLatency(Configuration conf) {
        return conf.getLong(CLOUDBASE_WRITER_MAX_LATENCY, Long.MAX_VALUE);
    }

    public static long getWriterMaxMemory(Configuration conf) {
        return conf.getLong(CLOUDBASE_WRITER_MAX_MEMORY, 10000L);
    }

    public static String getUsername(JobContext job) {
        return ConfigUtils.getUsername(job.getConfiguration());
    }

    public static String getUsername(Configuration conf) {
        return new AccumuloRdfConfiguration(conf).getUsername();
    }

    public static Authorizations getAuthorizations(JobContext job) {
        return ConfigUtils.getAuthorizations(job.getConfiguration());
    }

    public static Authorizations getAuthorizations(Configuration conf) {
        String authString = conf.get(CLOUDBASE_AUTHS, "");
        if (authString.isEmpty()) {
            return new Authorizations();
        }
        return new Authorizations(authString.split(","));
    }

    public static Instance getInstance(JobContext job) {
        return ConfigUtils.getInstance(job.getConfiguration());
    }

    public static Instance getInstance(Configuration conf) {
        AccumuloRdfConfiguration accConf = new AccumuloRdfConfiguration(conf);
        String instanceName = accConf.getInstanceName();
        String zoookeepers = accConf.getZookeepers();
        if (ConfigUtils.useMockInstance(conf)) {
            return new MockInstance(instanceName);
        }
        return new ZooKeeperInstance(instanceName, zoookeepers);
    }

    public static String getPassword(JobContext job) {
        return ConfigUtils.getPassword(job.getConfiguration());
    }

    public static String getPassword(Configuration conf) {
        return new AccumuloRdfConfiguration(conf).getPassword();
    }

    public static Connector getConnector(JobContext job) throws AccumuloException, AccumuloSecurityException {
        return ConfigUtils.getConnector(job.getConfiguration());
    }

    public static Connector getConnector(Configuration conf) throws AccumuloException, AccumuloSecurityException {
        return ConnectorFactory.connect((AccumuloRdfConfiguration)new AccumuloRdfConfiguration(conf));
    }

    public static boolean useMockInstance(Configuration conf) {
        return new AccumuloRdfConfiguration(conf).useMockInstance();
    }

    protected static int getNumPartitions(Configuration conf) {
        return conf.getInt(NUM_PARTITIONS, 25);
    }

    public static int getFreeTextDocNumPartitions(Configuration conf) {
        return conf.getInt(FREETEXT_DOC_NUM_PARTITIONS, ConfigUtils.getNumPartitions(conf));
    }

    public static int getFreeTextTermNumPartitions(Configuration conf) {
        return conf.getInt(FREETEXT_TERM_NUM_PARTITIONS, ConfigUtils.getNumPartitions(conf));
    }

    public static boolean getUseFreeText(Configuration conf) {
        return conf.getBoolean(USE_FREETEXT, false);
    }

    public static boolean getUseTemporal(Configuration conf) {
        return conf.getBoolean(USE_TEMPORAL, false);
    }

    public static boolean getUseEntity(Configuration conf) {
        return conf.getBoolean(USE_ENTITY, false);
    }

    public static boolean getUsePCJ(Configuration conf) {
        return conf.getBoolean(USE_PCJ, false);
    }

    public static boolean getUseOptimalPCJ(Configuration conf) {
        return conf.getBoolean(USE_OPTIMAL_PCJ, false);
    }

    public static boolean getUsePcjUpdaterIndex(Configuration conf) {
        return conf.getBoolean(USE_PCJ_UPDATER_INDEX, false);
    }

    public Optional<String> getFluoAppName(Configuration conf) {
        return Optional.fromNullable((Object)conf.get(FLUO_APP_NAME));
    }

    public static void setUseMongo(Configuration conf, boolean useMongo) {
        conf.setBoolean(USE_MONGO, useMongo);
    }

    public static boolean getUseMongo(Configuration conf) {
        return conf.getBoolean(USE_MONGO, false);
    }

    public static void setIndexers(RdfCloudTripleStoreConfiguration conf) {
        ArrayList indexList = Lists.newArrayList();
        ArrayList optimizers = Lists.newArrayList();
        boolean useFilterIndex = false;
        if (ConfigUtils.getUseMongo((Configuration)conf)) {
            if (ConfigUtils.getUseFreeText((Configuration)conf)) {
                indexList.add(MongoFreeTextIndexer.class.getName());
                useFilterIndex = true;
            }
            if (ConfigUtils.getUseEntity((Configuration)conf)) {
                indexList.add(MongoEntityIndexer.class.getName());
                optimizers.add(EntityIndexOptimizer.class.getName());
            }
            if (ConfigUtils.getUseTemporal((Configuration)conf)) {
                indexList.add(MongoTemporalIndexer.class.getName());
                useFilterIndex = true;
            }
            if (ConfigUtils.getUsePCJ((Configuration)conf) && ConfigUtils.getUseOptimalPCJ((Configuration)conf)) {
                conf.setPcjOptimizer(PCJOptimizer.class);
            }
        } else {
            if (ConfigUtils.getUsePCJ((Configuration)conf) || ConfigUtils.getUseOptimalPCJ((Configuration)conf)) {
                conf.setPcjOptimizer(PCJOptimizer.class);
            }
            if (ConfigUtils.getUsePcjUpdaterIndex((Configuration)conf)) {
                indexList.add(PrecomputedJoinIndexer.class.getName());
            }
            if (ConfigUtils.getUseFreeText((Configuration)conf)) {
                indexList.add(AccumuloFreeTextIndexer.class.getName());
                useFilterIndex = true;
            }
            if (ConfigUtils.getUseTemporal((Configuration)conf)) {
                indexList.add(AccumuloTemporalIndexer.class.getName());
                useFilterIndex = true;
            }
            if (ConfigUtils.getUseEntity((Configuration)conf)) {
                indexList.add(EntityCentricIndex.class.getName());
                optimizers.add(EntityOptimizer.class.getName());
            }
        }
        if (useFilterIndex) {
            optimizers.add(FilterFunctionOptimizer.class.getName());
        }
        if (conf.getUseStatementMetadata()) {
            optimizers.add(StatementMetadataOptimizer.class.getName());
        }
        conf.setStrings("ac.additional.indexers", indexList.toArray(new String[0]));
        conf.setStrings("query.optimizers", optimizers.toArray(new String[0]));
    }
}

