/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.accumulo;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.rya.accumulo.AbstractAccumuloRdfConfigurationBuilder;
import org.apache.rya.accumulo.AccumuloRdfConfiguration;
import org.apache.rya.api.domain.RyaIRI;

public class AccumuloIndexingConfiguration
extends AccumuloRdfConfiguration {
    private AccumuloIndexingConfiguration() {
    }

    public static AccumuloIndexingConfigBuilder builder() {
        return new AccumuloIndexingConfigBuilder();
    }

    public static AccumuloIndexingConfiguration fromProperties(Properties props) {
        return AccumuloIndexingConfigBuilder.fromProperties(props);
    }

    public void setUseEntity(boolean useEntity) {
        this.setBoolean("sc.use_entity", useEntity);
    }

    public boolean getUseEntity() {
        return this.getBoolean("sc.use_entity", false);
    }

    public void setUseTemporal(boolean useTemporal) {
        this.setBoolean("sc.use_temporal", useTemporal);
    }

    public boolean getUseTemporal() {
        return this.getBoolean("sc.use_temporal", false);
    }

    public boolean getUseFreetext() {
        return this.getBoolean("sc.use_freetext", false);
    }

    public void setUseFreetext(boolean useFreetext) {
        this.setBoolean("sc.use_freetext", useFreetext);
    }

    public boolean getUsePCJUpdater() {
        return this.getBoolean("sc.use.updater", false);
    }

    public void setUsePCJUpdater(boolean usePCJUpdater) {
        this.setBoolean("sc.use.updater", usePCJUpdater);
        if (usePCJUpdater) {
            this.set("rya.indexing.pcj.storageType", "ACCUMULO");
            this.set("rya.indexing.pcj.updaterType", "FLUO");
        }
    }

    public void setFluoAppUpdaterName(String fluoAppName) {
        Preconditions.checkNotNull((Object)fluoAppName, (Object)"Fluo app name cannot be null.");
        this.setUsePCJUpdater(true);
        this.set("rya.indexing.pcj.fluo.fluoAppName", fluoAppName);
    }

    public String getFluoAppUpdaterName() {
        return this.get("rya.indexing.pcj.fluo.fluoAppName");
    }

    public void setUsePCJ(boolean usePCJ) {
        this.setBoolean("sc.use_pcj", usePCJ);
    }

    public boolean getUsePCJ() {
        return this.getBoolean("sc.use_pcj", false);
    }

    public void setUseOptimalPCJ(boolean useOptimalPCJ) {
        this.setBoolean("sc.use.optimal.pcj", useOptimalPCJ);
    }

    public boolean getUseOptimalPCJ() {
        return this.getBoolean("sc.use.optimal.pcj", false);
    }

    public void setAccumuloFreeTextPredicates(String[] predicates) {
        Preconditions.checkNotNull((Object)predicates, (Object)"Freetext predicates cannot be null.");
        this.setStrings("sc.freetext.predicates", predicates);
    }

    public String[] getAccumuloFreeTextPredicates() {
        return this.getStrings("sc.freetext.predicates");
    }

    public void setAccumuloTemporalPredicates(String[] predicates) {
        Preconditions.checkNotNull((Object)predicates, (Object)"Freetext predicates cannot be null.");
        this.setStrings("sc.temporal.predicates", predicates);
    }

    public String[] getAccumuloTemporalPredicates() {
        return this.getStrings("sc.temporal.predicates");
    }

    private static Set<RyaIRI> getPropURIFromStrings(String ... props) {
        HashSet<RyaIRI> properties = new HashSet<RyaIRI>();
        if (props != null) {
            for (String prop : props) {
                if (!StringUtils.isNotBlank((CharSequence)prop)) continue;
                properties.add(new RyaIRI(prop));
            }
        }
        return properties;
    }

    public static class AccumuloIndexingConfigBuilder
    extends AbstractAccumuloRdfConfigurationBuilder<AccumuloIndexingConfigBuilder, AccumuloIndexingConfiguration> {
        private String fluoAppName;
        private boolean useFreetext = false;
        private boolean useTemporal = false;
        private boolean useEntity = false;
        private boolean useMetadata = false;
        private String[] freetextPredicates;
        private String[] temporalPredicates;
        private boolean usePcj = false;
        private boolean useOptimalPcj = false;
        private String[] pcjs = new String[0];
        private Set<RyaIRI> metadataProps = new HashSet<RyaIRI>();
        private static final String USE_FREETEXT = "use.freetext";
        private static final String USE_TEMPORAL = "use.temporal";
        private static final String USE_ENTITY = "use.entity";
        private static final String FLUO_APP_NAME = "fluo.app.name";
        private static final String USE_PCJ = "use.pcj";
        private static final String USE_OPTIMAL_PCJ = "use.optimal.pcj";
        private static final String TEMPORAL_PREDICATES = "temporal.predicates";
        private static final String FREETEXT_PREDICATES = "freetext.predicates";
        private static final String PCJ_TABLES = "pcj.tables";
        private static final String USE_STATEMENT_METADATA = "use.metadata";
        private static final String STATEMENT_METADATA_PROPERTIES = "metadata.properties";

        public static AccumuloIndexingConfiguration fromProperties(Properties props) {
            Preconditions.checkNotNull((Object)props);
            try {
                AccumuloIndexingConfigBuilder builder = ((AccumuloIndexingConfigBuilder)((AccumuloIndexingConfigBuilder)((AccumuloIndexingConfigBuilder)((AccumuloIndexingConfigBuilder)((AccumuloIndexingConfigBuilder)((AccumuloIndexingConfigBuilder)((AccumuloIndexingConfigBuilder)((AccumuloIndexingConfigBuilder)((AccumuloIndexingConfigBuilder)((AccumuloIndexingConfigBuilder)((AccumuloIndexingConfigBuilder)((AccumuloIndexingConfigBuilder)((AccumuloIndexingConfigBuilder)new AccumuloIndexingConfigBuilder().setAuths(props.getProperty("accumulo.auths", ""))).setRyaPrefix(props.getProperty("accumulo.rya.prefix", "rya_"))).setVisibilities(props.getProperty("accumulo.visibilities", ""))).setUseInference(AccumuloIndexingConfigBuilder.getBoolean((String)props.getProperty("use.inference", "false")))).setDisplayQueryPlan(AccumuloIndexingConfigBuilder.getBoolean((String)props.getProperty("use.display.plan", "true")))).setAccumuloUser(props.getProperty("accumulo.user"))).setAccumuloInstance(props.getProperty("accumulo.instance"))).setAccumuloZooKeepers(props.getProperty("accumulo.zookeepers"))).setAccumuloPassword(props.getProperty("accumulo.password"))).setUseMockAccumulo(AccumuloIndexingConfigBuilder.getBoolean((String)props.getProperty("use.mock", "false")))).setUseAccumuloPrefixHashing(AccumuloIndexingConfigBuilder.getBoolean((String)props.getProperty("use.prefix.hashing", "false")))).setUseCompositeCardinality(AccumuloIndexingConfigBuilder.getBoolean((String)props.getProperty("use.count.stats", "false")))).setUseJoinSelectivity(AccumuloIndexingConfigBuilder.getBoolean((String)props.getProperty("use.join.selectivity", "false")))).setUseAccumuloFreetextIndex(AccumuloIndexingConfigBuilder.getBoolean((String)props.getProperty(USE_FREETEXT, "false"))).setUseAccumuloTemporalIndex(AccumuloIndexingConfigBuilder.getBoolean((String)props.getProperty(USE_TEMPORAL, "false"))).setUseAccumuloEntityIndex(AccumuloIndexingConfigBuilder.getBoolean((String)props.getProperty(USE_ENTITY, "false"))).setAccumuloFreeTextPredicates(StringUtils.split((String)props.getProperty(FREETEXT_PREDICATES), (String)",")).setAccumuloTemporalPredicates(StringUtils.split((String)props.getProperty(TEMPORAL_PREDICATES), (String)",")).setUsePcj(AccumuloIndexingConfigBuilder.getBoolean((String)props.getProperty(USE_PCJ, "false"))).setUseOptimalPcj(AccumuloIndexingConfigBuilder.getBoolean((String)props.getProperty(USE_OPTIMAL_PCJ, "false"))).setPcjTables(StringUtils.split((String)props.getProperty(PCJ_TABLES), (String)",")).setPcjUpdaterFluoAppName(props.getProperty(FLUO_APP_NAME)).setUseStatementMetadata(AccumuloIndexingConfigBuilder.getBoolean((String)props.getProperty(USE_STATEMENT_METADATA))).setStatementMetadataProperties(AccumuloIndexingConfiguration.getPropURIFromStrings(StringUtils.split((String)props.getProperty(STATEMENT_METADATA_PROPERTIES), (String)",")));
                return builder.build();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public AccumuloIndexingConfigBuilder setUseAccumuloFreetextIndex(boolean useFreeText) {
            this.useFreetext = useFreeText;
            return this;
        }

        public AccumuloIndexingConfigBuilder setUseAccumuloTemporalIndex(boolean useTemporal) {
            this.useTemporal = useTemporal;
            return this;
        }

        public AccumuloIndexingConfigBuilder setUseAccumuloEntityIndex(boolean useEntity) {
            this.useEntity = useEntity;
            return this;
        }

        public AccumuloIndexingConfigBuilder setPcjUpdaterFluoAppName(String fluoAppName) {
            this.fluoAppName = fluoAppName;
            return this;
        }

        public AccumuloIndexingConfigBuilder setAccumuloFreeTextPredicates(String ... predicates) {
            this.freetextPredicates = predicates;
            return this;
        }

        public AccumuloIndexingConfigBuilder setAccumuloTemporalPredicates(String ... predicates) {
            this.temporalPredicates = predicates;
            return this;
        }

        public AccumuloIndexingConfigBuilder setUsePcj(boolean usePcj) {
            this.usePcj = usePcj;
            return this;
        }

        public AccumuloIndexingConfigBuilder setUseOptimalPcj(boolean useOptimalPcj) {
            this.useOptimalPcj = useOptimalPcj;
            return this;
        }

        public AccumuloIndexingConfigBuilder setPcjTables(String ... pcjs) {
            this.pcjs = pcjs;
            return this;
        }

        public AccumuloIndexingConfigBuilder setUseStatementMetadata(boolean useMetadata) {
            this.useMetadata = useMetadata;
            return this;
        }

        public AccumuloIndexingConfigBuilder setStatementMetadataProperties(Set<RyaIRI> metadataProps) {
            this.metadataProps = metadataProps;
            return this;
        }

        public AccumuloIndexingConfiguration build() {
            AccumuloIndexingConfiguration conf = this.getConf((AccumuloIndexingConfiguration)super.build());
            return conf;
        }

        private AccumuloIndexingConfiguration getConf(AccumuloIndexingConfiguration conf) {
            Preconditions.checkNotNull((Object)((Object)conf));
            if (this.fluoAppName != null) {
                conf.setFluoAppUpdaterName(this.fluoAppName);
            }
            if (this.useFreetext) {
                conf.setUseFreetext(this.useFreetext);
                if (this.freetextPredicates != null) {
                    conf.setAccumuloFreeTextPredicates(this.freetextPredicates);
                }
            }
            if (this.useTemporal) {
                conf.setUseTemporal(this.useTemporal);
                if (this.temporalPredicates != null) {
                    conf.setAccumuloTemporalPredicates(this.temporalPredicates);
                }
            }
            if (this.usePcj || this.useOptimalPcj) {
                conf.setUsePCJ(this.usePcj);
                conf.setUseOptimalPCJ(this.useOptimalPcj);
                if (this.pcjs.length > 1 || this.pcjs.length == 1 && this.pcjs[0] != null) {
                    conf.setPcjTables(Lists.newArrayList((Object[])this.pcjs));
                }
            }
            if (this.useMetadata) {
                conf.setUseStatementMetadata(this.useMetadata);
                conf.setStatementMetadataProperties(this.metadataProps);
            }
            conf.setBoolean("sc.use_entity", this.useEntity);
            return conf;
        }

        protected AccumuloIndexingConfigBuilder confBuilder() {
            return this;
        }

        protected AccumuloIndexingConfiguration createConf() {
            return new AccumuloIndexingConfiguration();
        }
    }
}

