/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.rya.indexing.IndexingExpr;
import org.apache.rya.indexing.IteratorFactory;
import org.apache.rya.indexing.SearchFunction;
import org.apache.rya.indexing.StatementConstraints;
import org.apache.rya.indexing.TemporalIndexer;
import org.apache.rya.indexing.TemporalInstantRfc3339;
import org.apache.rya.indexing.TemporalInterval;
import org.apache.rya.indexing.external.tupleSet.ExternalTupleSet;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.joda.time.DateTime;

public class TemporalTupleSet
extends ExternalTupleSet {
    private static final long serialVersionUID = 1L;
    private static final ValueFactory VF = SimpleValueFactory.getInstance();
    private final Configuration conf;
    private final TemporalIndexer temporalIndexer;
    private final IndexingExpr filterInfo;

    public TemporalTupleSet(IndexingExpr filterInfo, TemporalIndexer temporalIndexer) {
        this.filterInfo = filterInfo;
        this.temporalIndexer = temporalIndexer;
        this.conf = temporalIndexer.getConf();
    }

    @Override
    public Set<String> getBindingNames() {
        return this.filterInfo.getBindingNames();
    }

    @Override
    public TemporalTupleSet clone() {
        return new TemporalTupleSet(this.filterInfo, this.temporalIndexer);
    }

    public double cardinality() {
        return 0.0;
    }

    @Override
    public String getSignature() {
        return "(TemporalTuple Projection) variables: " + Joiner.on((String)", ").join(this.getBindingNames()).replaceAll("\\s+", " ");
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TemporalTupleSet)) {
            return false;
        }
        TemporalTupleSet arg = (TemporalTupleSet)((Object)other);
        return this.filterInfo.equals(arg.filterInfo);
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 31 * result + this.filterInfo.hashCode();
        return result;
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bindings) throws QueryEvaluationException {
        IRI funcURI = this.filterInfo.getFunction();
        SearchFunction searchFunction = new TemporalSearchFunctionFactory(this.conf, this.temporalIndexer).getSearchFunction(funcURI);
        if (this.filterInfo.getArguments().length > 1) {
            throw new IllegalArgumentException("Index functions do not support more than two arguments.");
        }
        String queryText = ((Value)this.filterInfo.getArguments()[0]).stringValue();
        return IteratorFactory.getIterator(this.filterInfo.getSpConstraint(), bindings, queryText, searchFunction);
    }

    public static class TemporalSearchFunctionFactory {
        private final Map<IRI, SearchFunction> SEARCH_FUNCTION_MAP = Maps.newHashMap();
        private final TemporalIndexer temporalIndexer;
        private final SearchFunction TEMPORAL_InstantAfterInstant = new SearchFunction(){

            @Override
            public CloseableIteration<Statement, QueryEvaluationException> performSearch(String searchTerms, StatementConstraints contraints) throws QueryEvaluationException {
                TemporalInstantRfc3339 queryInstant = new TemporalInstantRfc3339(DateTime.parse((String)searchTerms));
                return temporalIndexer.queryInstantAfterInstant(queryInstant, contraints);
            }

            public String toString() {
                return "TEMPORAL_InstantAfterInstant";
            }
        };
        private final SearchFunction TEMPORAL_InstantBeforeInstant = new SearchFunction(){

            @Override
            public CloseableIteration<Statement, QueryEvaluationException> performSearch(String searchTerms, StatementConstraints contraints) throws QueryEvaluationException {
                TemporalInstantRfc3339 queryInstant = new TemporalInstantRfc3339(DateTime.parse((String)searchTerms));
                return temporalIndexer.queryInstantBeforeInstant(queryInstant, contraints);
            }

            public String toString() {
                return "TEMPORAL_InstantBeforeInstant";
            }
        };
        private final SearchFunction TEMPORAL_InstantEqualsInstant = new SearchFunction(){

            @Override
            public CloseableIteration<Statement, QueryEvaluationException> performSearch(String searchTerms, StatementConstraints contraints) throws QueryEvaluationException {
                TemporalInstantRfc3339 queryInstant = new TemporalInstantRfc3339(DateTime.parse((String)searchTerms));
                return temporalIndexer.queryInstantEqualsInstant(queryInstant, contraints);
            }

            public String toString() {
                return "TEMPORAL_InstantEqualsInstant";
            }
        };
        private final SearchFunction TEMPORAL_InstantAfterInterval = new SearchFunction(){

            @Override
            public CloseableIteration<Statement, QueryEvaluationException> performSearch(String searchTerms, StatementConstraints contraints) throws QueryEvaluationException {
                TemporalInterval queryInterval = TemporalInstantRfc3339.parseInterval(searchTerms);
                return temporalIndexer.queryInstantAfterInterval(queryInterval, contraints);
            }

            public String toString() {
                return "TEMPORAL_InstantAfterInterval";
            }
        };
        private final SearchFunction TEMPORAL_InstantBeforeInterval = new SearchFunction(){

            @Override
            public CloseableIteration<Statement, QueryEvaluationException> performSearch(String searchTerms, StatementConstraints contraints) throws QueryEvaluationException {
                TemporalInterval queryInterval = TemporalInstantRfc3339.parseInterval(searchTerms);
                return temporalIndexer.queryInstantBeforeInterval(queryInterval, contraints);
            }

            public String toString() {
                return "TEMPORAL_InstantBeforeInterval";
            }
        };
        private final SearchFunction TEMPORAL_InstantInsideInterval = new SearchFunction(){

            @Override
            public CloseableIteration<Statement, QueryEvaluationException> performSearch(String searchTerms, StatementConstraints contraints) throws QueryEvaluationException {
                TemporalInterval queryInterval = TemporalInstantRfc3339.parseInterval(searchTerms);
                return temporalIndexer.queryInstantInsideInterval(queryInterval, contraints);
            }

            public String toString() {
                return "TEMPORAL_InstantInsideInterval";
            }
        };
        private final SearchFunction TEMPORAL_InstantHasBeginningInterval = new SearchFunction(){

            @Override
            public CloseableIteration<Statement, QueryEvaluationException> performSearch(String searchTerms, StatementConstraints contraints) throws QueryEvaluationException {
                TemporalInterval queryInterval = TemporalInstantRfc3339.parseInterval(searchTerms);
                return temporalIndexer.queryInstantHasBeginningInterval(queryInterval, contraints);
            }

            public String toString() {
                return "TEMPORAL_InstantHasBeginningInterval";
            }
        };
        private final SearchFunction TEMPORAL_InstantHasEndInterval = new SearchFunction(){

            @Override
            public CloseableIteration<Statement, QueryEvaluationException> performSearch(String searchTerms, StatementConstraints contraints) throws QueryEvaluationException {
                TemporalInterval queryInterval = TemporalInstantRfc3339.parseInterval(searchTerms);
                return temporalIndexer.queryInstantHasEndInterval(queryInterval, contraints);
            }

            public String toString() {
                return "TEMPORAL_InstantHasEndInterval";
            }
        };

        public TemporalSearchFunctionFactory(Configuration conf, TemporalIndexer temporalIndexer) {
            String TEMPORAL_NS = "tag:rya-rdf.org,2015:temporal#";
            this.SEARCH_FUNCTION_MAP.put(VF.createIRI("tag:rya-rdf.org,2015:temporal#after"), this.TEMPORAL_InstantAfterInstant);
            this.SEARCH_FUNCTION_MAP.put(VF.createIRI("tag:rya-rdf.org,2015:temporal#before"), this.TEMPORAL_InstantBeforeInstant);
            this.SEARCH_FUNCTION_MAP.put(VF.createIRI("tag:rya-rdf.org,2015:temporal#equals"), this.TEMPORAL_InstantEqualsInstant);
            this.SEARCH_FUNCTION_MAP.put(VF.createIRI("tag:rya-rdf.org,2015:temporal#beforeInterval"), this.TEMPORAL_InstantBeforeInterval);
            this.SEARCH_FUNCTION_MAP.put(VF.createIRI("tag:rya-rdf.org,2015:temporal#afterInterval"), this.TEMPORAL_InstantAfterInterval);
            this.SEARCH_FUNCTION_MAP.put(VF.createIRI("tag:rya-rdf.org,2015:temporal#insideInterval"), this.TEMPORAL_InstantInsideInterval);
            this.SEARCH_FUNCTION_MAP.put(VF.createIRI("tag:rya-rdf.org,2015:temporal#hasBeginningInterval"), this.TEMPORAL_InstantHasBeginningInterval);
            this.SEARCH_FUNCTION_MAP.put(VF.createIRI("tag:rya-rdf.org,2015:temporal#hasEndInterval"), this.TEMPORAL_InstantHasEndInterval);
            this.temporalIndexer = temporalIndexer;
        }

        public SearchFunction getSearchFunction(IRI searchFunction) {
            SearchFunction geoFunc = null;
            try {
                geoFunc = this.getSearchFunctionInternal(searchFunction);
            }
            catch (QueryEvaluationException e) {
                e.printStackTrace();
            }
            return geoFunc;
        }

        private SearchFunction getSearchFunctionInternal(IRI searchFunction) throws QueryEvaluationException {
            SearchFunction sf = this.SEARCH_FUNCTION_MAP.get(searchFunction);
            if (sf != null) {
                return sf;
            }
            throw new QueryEvaluationException("Unknown Search Function: " + searchFunction.stringValue());
        }
    }
}

