/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing;

import java.io.UnsupportedEncodingException;
import org.apache.rya.indexing.TemporalInstant;

public class TemporalInterval
implements Comparable<TemporalInterval> {
    private final TemporalInstant hasBeginning;
    private final TemporalInstant hasEnd;
    public static final String DELIMITER = "/";

    public TemporalInterval(TemporalInstant hasBeginning, TemporalInstant hasEnd) {
        if (hasBeginning != null && hasEnd != null && 0 < hasBeginning.compareTo(hasEnd)) {
            throw new IllegalArgumentException("The Beginning instance must not compare greater than the end.");
        }
        this.hasBeginning = hasBeginning;
        this.hasEnd = hasEnd;
    }

    public TemporalInstant getHasBeginning() {
        return this.hasBeginning;
    }

    public TemporalInstant getHasEnd() {
        return this.hasEnd;
    }

    public boolean equals(Object other) {
        return other instanceof TemporalInterval && this.compareTo((TemporalInterval)other) == 0;
    }

    @Override
    public int compareTo(TemporalInterval other) {
        int compBegins = this.hasBeginning.compareTo(other.hasBeginning);
        if (0 == compBegins) {
            return this.hasEnd.compareTo(other.hasEnd);
        }
        return compBegins;
    }

    public int hashCode() {
        if (this.hasBeginning == null) {
            if (this.hasEnd == null) {
                return 0;
            }
            return this.hasEnd.hashCode();
        }
        return TemporalInterval.hashboth(this.hasBeginning.hashCode(), this.hasEnd.hashCode());
    }

    protected static int hashboth(int i1, int i2) {
        return i1 + i2;
    }

    public byte[] getAsKeyBeginning() {
        try {
            return (this.hasBeginning.getAsKeyString() + DELIMITER + this.hasEnd.getAsKeyString()).getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("while converting key string to ascii bytes", e);
        }
    }

    public byte[] getAsKeyEnd() {
        try {
            return (this.hasEnd.getAsKeyString() + DELIMITER + this.hasBeginning.getAsKeyString()).getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("while converting key string to ascii bytes", e);
        }
    }

    public String getAsPair() {
        return "[" + this.hasBeginning.getAsReadable() + "," + this.hasEnd.getAsReadable() + "]";
    }

    public String toString() {
        return this.getAsPair();
    }
}

