/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.rya.indexing.TemporalInstant;
import org.apache.rya.indexing.TemporalInterval;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class TemporalInstantRfc3339
implements TemporalInstant {
    private static final long serialVersionUID = -7790000399142290309L;
    private final DateTime dateTime;
    public static final DateTimeFormatter FORMATTER = ISODateTimeFormat.dateTimeNoMillis();
    public static final Pattern PATTERN = Pattern.compile("\\[(.*)\\,(.*)\\].*");
    private static final TemporalInstant MINIMUM = new TemporalInstantRfc3339(new DateTime(Long.MIN_VALUE));
    private static final TemporalInstant MAXIMUM = new TemporalInstantRfc3339(new DateTime(Long.MAX_VALUE));

    public TemporalInstantRfc3339(int year, int month, int day, int hour, int minute, int second) {
        this.dateTime = new DateTime(year, month, day, hour, minute, second, DateTimeZone.UTC);
    }

    public TemporalInstantRfc3339(DateTime datetime) {
        this.dateTime = datetime;
    }

    public static TemporalInterval parseInterval(String dateTimeInterval) {
        Matcher matcher = PATTERN.matcher(dateTimeInterval);
        if (matcher.find()) {
            return new TemporalInterval(new TemporalInstantRfc3339(new DateTime((Object)matcher.group(1))), new TemporalInstantRfc3339(new DateTime((Object)matcher.group(2))));
        }
        throw new IllegalArgumentException("Can't parse interval, expecting '[ISO8601dateTime1,ISO8601dateTime2]', actual: " + dateTimeInterval);
    }

    @Override
    public int compareTo(TemporalInstant that) {
        return this.getAsKeyString().compareTo(that.getAsKeyString());
    }

    @Override
    public byte[] getAsKeyBytes() {
        return StringUtils.getBytesUtf8((String)this.getAsKeyString());
    }

    @Override
    public String getAsKeyString() {
        return this.dateTime.withZone(DateTimeZone.UTC).toString(FORMATTER);
    }

    @Override
    public String getAsReadable(DateTimeZone dateTimeZone) {
        return this.dateTime.withZone(dateTimeZone).toString(FORMATTER);
    }

    @Override
    public String getAsReadable() {
        return this.dateTime.toString(FORMATTER);
    }

    public String toString() {
        return this.getAsReadable();
    }

    @Override
    public DateTime getAsDateTime() {
        return this.dateTime;
    }

    public static TemporalInstant getMinimumInstance() {
        return MINIMUM;
    }

    public static TemporalInstant getMaximumInstance() {
        return MAXIMUM;
    }

    @Override
    public int hashCode() {
        return this.getAsKeyString().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TemporalInstantRfc3339 other = (TemporalInstantRfc3339)obj;
        return this.getAsKeyString().equals(other.getAsKeyString());
    }
}

