/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing;

import java.io.IOException;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.rya.indexing.StatementConstraints;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public class StatementSerializer {
    private static String SEP = "\u0000";
    private static final ValueFactory VF = SimpleValueFactory.getInstance();

    public static Statement readStatement(String in) throws IOException {
        String[] parts = in.split(SEP);
        if (parts.length != 4) {
            throw new IOException("Not a valid statement: " + in);
        }
        String contextString = parts[0];
        String subjectString = parts[1];
        String predicateString = parts[2];
        String objectString = parts[3];
        return StatementSerializer.readStatement(subjectString, predicateString, objectString, contextString);
    }

    public static Statement readStatement(String subjectString, String predicateString, String objectString) {
        return StatementSerializer.readStatement(subjectString, predicateString, objectString, "");
    }

    public static Statement readStatement(String subjectString, String predicateString, String objectString, String contextString) {
        Resource subject = StatementSerializer.createResource(subjectString);
        IRI predicate = VF.createIRI(predicateString);
        boolean isObjectLiteral = objectString.startsWith("\"");
        Object object = null;
        object = isObjectLiteral ? StatementSerializer.parseLiteral(objectString) : StatementSerializer.createResource(objectString);
        if (contextString == null || contextString.isEmpty()) {
            return VF.createStatement(subject, predicate, (Value)object);
        }
        IRI context = VF.createIRI(contextString);
        return VF.createStatement(subject, predicate, (Value)object, (Resource)context);
    }

    private static Resource createResource(String str) {
        if (str.startsWith("_")) {
            return VF.createBNode(str.substring(2));
        }
        return VF.createIRI(str);
    }

    private static Literal parseLiteral(String fullLiteralString) {
        Validate.notNull((Object)fullLiteralString);
        Validate.isTrue((fullLiteralString.length() > 1 ? 1 : 0) != 0);
        if (fullLiteralString.endsWith("\"")) {
            String fullLiteralWithoutQuotes = fullLiteralString.substring(1, fullLiteralString.length() - 1);
            return VF.createLiteral(fullLiteralWithoutQuotes);
        }
        int labelEnd = fullLiteralString.lastIndexOf("\"");
        String label = fullLiteralString.substring(1, labelEnd);
        String data = fullLiteralString.substring(labelEnd + 1);
        if (data.startsWith("@")) {
            String lang = data.substring(1);
            return VF.createLiteral(label, lang);
        }
        if (data.startsWith("^^<")) {
            String datatype = data.substring(3, data.length() - 1);
            IRI datatypeUri = VF.createIRI(datatype);
            return VF.createLiteral(label, datatypeUri);
        }
        return null;
    }

    public static String writeSubject(Statement statement) {
        return statement.getSubject().toString();
    }

    public static String writeObject(Statement statement) {
        return statement.getObject().toString();
    }

    public static String writePredicate(Statement statement) {
        return statement.getPredicate().toString();
    }

    public static String writeSubjectPredicate(Statement statement) {
        Validate.notNull((Object)statement);
        Validate.notNull((Object)statement.getSubject());
        Validate.notNull((Object)statement.getPredicate());
        return statement.getSubject().toString() + SEP + statement.getPredicate().toString();
    }

    public static String writeContext(Statement statement) {
        if (statement.getContext() == null) {
            return "";
        }
        return statement.getContext().toString();
    }

    public static String writeStatement(Statement statement) {
        Resource subject = statement.getSubject();
        Resource context = statement.getContext();
        IRI predicate = statement.getPredicate();
        Value object = statement.getObject();
        Validate.notNull((Object)subject);
        Validate.notNull((Object)predicate);
        Validate.notNull((Object)object);
        String s = "";
        s = context == null ? SEP + subject.toString() + SEP + predicate.toString() + SEP + object.toString() : context.toString() + SEP + subject.toString() + SEP + predicate.toString() + SEP + object.toString();
        return s;
    }

    public static String createStatementRegex(StatementConstraints contraints) {
        Resource context = contraints.getContext();
        Resource subject = contraints.getSubject();
        Set<IRI> predicates = contraints.getPredicates();
        if (context == null && subject == null && (predicates == null || predicates.isEmpty())) {
            return null;
        }
        String anyReg = "[^" + SEP + "]*";
        String contextReg = context == null ? anyReg : context.stringValue();
        String subjectReg = subject == null ? anyReg : subject.stringValue();
        String predicateReg = "";
        predicateReg = predicates == null || predicates.isEmpty() ? anyReg : "(" + StringUtils.join(predicates, (String)"|") + ")";
        return "^" + contextReg + SEP + subjectReg + SEP + predicateReg + SEP + ".*";
    }
}

