/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.rya.indexing.SearchFunction;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.query.QueryEvaluationException;

public abstract class SearchFunctionFactory {
    private static final Logger logger = Logger.getLogger(SearchFunctionFactory.class);
    private final Map<IRI, SearchFunction> SEARCH_FUNCTION_MAP = Maps.newHashMap();

    public SearchFunction getSearchFunction(IRI searchFunction) {
        SearchFunction geoFunc = null;
        try {
            geoFunc = this.getSearchFunctionInternal(searchFunction);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
        }
        return geoFunc;
    }

    private SearchFunction getSearchFunctionInternal(IRI searchFunction) throws QueryEvaluationException {
        SearchFunction sf = this.SEARCH_FUNCTION_MAP.get(searchFunction);
        if (sf != null) {
            return sf;
        }
        throw new QueryEvaluationException("Unknown Search Function: " + searchFunction.stringValue());
    }
}

