/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing;

import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.hadoop.io.Text;
import org.apache.rya.indexing.Md5Hash;
import org.apache.rya.indexing.StatementConstraints;
import org.apache.rya.indexing.StatementSerializer;
import org.apache.rya.indexing.TemporalInstant;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public class KeyParts
implements Iterable<KeyParts> {
    private static final ValueFactory VF = SimpleValueFactory.getInstance();
    private static final String CQ_S_P_AT = "spo";
    private static final String CQ_P_AT = "po";
    private static final String CQ_S_AT = "so";
    private static final String CQ_O_AT = "o";
    public static final String CQ_BEGIN = "begin";
    public static final String CQ_END = "end";
    public static final byte[] HASH_PREFIX = new byte[]{0};
    public static final byte[] HASH_PREFIX_FOLLOWING = new byte[]{1};
    public final Text cf;
    public final Text cq;
    public final Text constraintPrefix;
    final Text storeKey;
    private final TemporalInstant instant;
    private final Statement statement;
    private final boolean queryMode;

    KeyParts(Text constraintPrefix, TemporalInstant instant, String cf, String cq) {
        this.queryMode = true;
        this.storeKey = null;
        this.statement = null;
        this.constraintPrefix = constraintPrefix;
        this.instant = instant;
        this.cf = new Text(cf);
        this.cq = new Text(cq);
    }

    public org.apache.accumulo.core.data.Value getValue() {
        assert (this.statement != null);
        return new org.apache.accumulo.core.data.Value(StringUtils.getBytesUtf8((String)StatementSerializer.writeStatement(this.statement)));
    }

    public KeyParts(Statement statement, TemporalInstant instant2) {
        this.queryMode = false;
        this.storeKey = null;
        this.constraintPrefix = null;
        this.statement = statement;
        this.instant = instant2;
        this.cf = null;
        this.cq = null;
    }

    private KeyParts(Text keyText, Text cf, Text cq, Statement statement) {
        this.queryMode = false;
        this.constraintPrefix = null;
        this.statement = statement;
        this.instant = null;
        this.storeKey = keyText;
        this.cf = cf;
        this.cq = cq;
    }

    @Override
    public Iterator<KeyParts> iterator() {
        final String[] strategies = new String[]{CQ_O_AT, CQ_S_P_AT, CQ_P_AT, CQ_S_AT};
        assert (!this.queryMode) : "iterator for queryMode is not immplemented";
        if (this.queryMode) {
            return null;
        }
        return new Iterator<KeyParts>(){
            int nextStrategy = 0;

            @Override
            public boolean hasNext() {
                return this.nextStrategy < strategies.length;
            }

            @Override
            public KeyParts next() {
                assert (KeyParts.this.statement != null);
                Text keyText = new Text();
                switch (this.nextStrategy++) {
                    case 0: {
                        assert (KeyParts.CQ_O_AT.equals(strategies[0]));
                        keyText = new Text(KeyParts.this.instant.getAsKeyBytes());
                        KeyParts.appendUniqueness(KeyParts.this.statement, keyText);
                        return new KeyParts(keyText, new Text(StatementSerializer.writeContext(KeyParts.this.statement)), new Text(KeyParts.CQ_O_AT), KeyParts.this.statement);
                    }
                    case 1: {
                        assert (KeyParts.CQ_S_P_AT.equals(strategies[1]));
                        KeyParts.appendSubjectPredicate(KeyParts.this.statement, keyText);
                        KeyParts.appendInstant(KeyParts.this.instant, keyText);
                        return new KeyParts(keyText, new Text(StatementSerializer.writeContext(KeyParts.this.statement)), new Text(KeyParts.CQ_S_P_AT), KeyParts.this.statement);
                    }
                    case 2: {
                        assert (KeyParts.CQ_P_AT.equals(strategies[2]));
                        KeyParts.appendPredicate(KeyParts.this.statement, keyText);
                        KeyParts.appendInstant(KeyParts.this.instant, keyText);
                        KeyParts.appendUniqueness(KeyParts.this.statement, keyText);
                        return new KeyParts(keyText, new Text(StatementSerializer.writeContext(KeyParts.this.statement)), new Text(KeyParts.CQ_P_AT), KeyParts.this.statement);
                    }
                    case 3: {
                        assert (KeyParts.CQ_S_AT.equals(strategies[3]));
                        KeyParts.appendSubject(KeyParts.this.statement, keyText);
                        KeyParts.appendInstant(KeyParts.this.instant, keyText);
                        KeyParts.appendUniqueness(KeyParts.this.statement, keyText);
                        return new KeyParts(keyText, new Text(StatementSerializer.writeContext(KeyParts.this.statement)), new Text(KeyParts.CQ_S_AT), KeyParts.this.statement);
                    }
                }
                throw new Error("Next passed end?  No such nextStrategy=" + (this.nextStrategy - 1));
            }

            @Override
            public void remove() {
                throw new Error("Remove not Implemented.");
            }
        };
    }

    public byte[] getStoreKey() {
        assert (!this.queryMode) : "must be in store Mode, store keys are not initialized.";
        return this.storeKey.copyBytes();
    }

    public Text getQueryKey() {
        return this.getQueryKey(this.instant);
    }

    public Text getQueryKey(TemporalInstant theInstant) {
        assert (this.queryMode) : "must be in query Mode, query keys are not initialized.";
        Text keyText = new Text();
        if (this.constraintPrefix != null) {
            KeyParts.appendBytes(this.constraintPrefix.copyBytes(), keyText);
        }
        KeyParts.appendInstant(theInstant, keyText);
        return keyText;
    }

    public String toString() {
        return "KeyParts [contraintPrefix=" + KeyParts.toHumanString(this.constraintPrefix) + ", instant=" + KeyParts.toHumanString(this.instant.getAsKeyBytes()) + ", cf=" + this.cf + ", cq=" + this.cq + "]";
    }

    private static void appendSubject(Statement statement, Text keyText) {
        org.apache.accumulo.core.data.Value statementValue = new org.apache.accumulo.core.data.Value(StatementSerializer.writeSubject(statement).getBytes(StandardCharsets.UTF_8));
        byte[] hashOfValue = KeyParts.uniqueFromValueForKey(statementValue);
        KeyParts.appendBytes(HASH_PREFIX, keyText);
        KeyParts.appendBytes(hashOfValue, keyText);
    }

    private static void appendPredicate(Statement statement, Text keyText) {
        org.apache.accumulo.core.data.Value statementValue = new org.apache.accumulo.core.data.Value(StringUtils.getBytesUtf8((String)StatementSerializer.writePredicate(statement)));
        byte[] hashOfValue = KeyParts.uniqueFromValueForKey(statementValue);
        KeyParts.appendBytes(HASH_PREFIX, keyText);
        KeyParts.appendBytes(hashOfValue, keyText);
    }

    private static void appendInstant(TemporalInstant instant, Text keyText) {
        byte[] bytes = instant.getAsKeyBytes();
        KeyParts.appendBytes(bytes, keyText);
    }

    private static void appendSubjectPredicate(Statement statement, Text keyText) {
        org.apache.accumulo.core.data.Value statementValue = new org.apache.accumulo.core.data.Value(StringUtils.getBytesUtf8((String)StatementSerializer.writeSubjectPredicate(statement)));
        byte[] hashOfValue = KeyParts.uniqueFromValueForKey(statementValue);
        KeyParts.appendBytes(HASH_PREFIX, keyText);
        KeyParts.appendBytes(hashOfValue, keyText);
    }

    private static void appendBytes(byte[] bytes, Text keyText) {
        keyText.append(bytes, 0, bytes.length);
    }

    public static void appendUniqueness(Statement statement, Text keyText) {
        keyText.append(HASH_PREFIX, 0, 1);
        org.apache.accumulo.core.data.Value statementValue = new org.apache.accumulo.core.data.Value(StringUtils.getBytesUtf8((String)StatementSerializer.writeStatement(statement)));
        byte[] hashOfValue = Md5Hash.md5Binary(statementValue);
        keyText.append(hashOfValue, 0, hashOfValue.length);
    }

    private static byte[] uniqueFromValueForKey(org.apache.accumulo.core.data.Value value) {
        return Md5Hash.md5Binary(value);
    }

    public static List<KeyParts> keyPartsForQuery(TemporalInstant queryInstant, StatementConstraints contraints) {
        LinkedList<KeyParts> keys = new LinkedList<KeyParts>();
        IRI urlNull = VF.createIRI("urn:null");
        Resource currentContext = contraints.getContext();
        boolean hasSubj = contraints.hasSubject();
        if (contraints.hasPredicates()) {
            for (IRI nextPredicate : contraints.getPredicates()) {
                Text contraintPrefix = new Text();
                Statement statement = VF.createStatement((Resource)(hasSubj ? contraints.getSubject() : urlNull), nextPredicate, (Value)urlNull, contraints.getContext());
                if (hasSubj) {
                    KeyParts.appendSubjectPredicate(statement, contraintPrefix);
                } else {
                    KeyParts.appendPredicate(statement, contraintPrefix);
                }
                keys.add(new KeyParts(contraintPrefix, queryInstant, currentContext == null ? "" : currentContext.toString(), hasSubj ? CQ_S_P_AT : CQ_P_AT));
            }
        } else if (contraints.hasSubject()) {
            Text contraintPrefix = new Text();
            Statement statement = VF.createStatement(contraints.getSubject(), urlNull, (Value)urlNull);
            KeyParts.appendSubject(statement, contraintPrefix);
            keys.add(new KeyParts(contraintPrefix, queryInstant, currentContext == null ? "" : currentContext.toString(), CQ_S_AT));
        } else {
            keys.add(new KeyParts(null, queryInstant, currentContext == null ? "" : currentContext.toString(), CQ_O_AT));
        }
        return keys;
    }

    public static String toHumanString(org.apache.accumulo.core.data.Value value) {
        return KeyParts.toHumanString(value == null ? null : value.get());
    }

    public static String toHumanString(Text text) {
        return KeyParts.toHumanString(text == null ? null : text.copyBytes());
    }

    public static String toHumanString(byte[] bytes) {
        if (bytes == null) {
            return "{null}";
        }
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            if (b > 126 || b < 32) {
                sb.append("{");
                sb.append(Integer.toHexString(b & 0xFF));
                sb.append("}");
                continue;
            }
            if (b == 123 || b == 125) {
                sb.append("{");
                sb.append((char)b);
                sb.append("}");
                continue;
            }
            sb.append((char)b);
        }
        return sb.toString();
    }
}

