/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.rya.indexing.SearchFunction;
import org.apache.rya.indexing.StatementConstraints;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.impl.MapBindingSet;

public class IteratorFactory {
    public static CloseableIteration<BindingSet, QueryEvaluationException> getIterator(final StatementPattern match, final BindingSet bindings, final String queryText, final SearchFunction searchFunction) {
        return new CloseableIteration<BindingSet, QueryEvaluationException>(){
            private boolean isClosed = false;
            private CloseableIteration<Statement, QueryEvaluationException> statementIt = null;
            private String subjectBinding = match.getSubjectVar().getName();
            private String predicateBinding = match.getPredicateVar().getName();
            private String objectBinding = match.getObjectVar().getName();
            private String contextBinding = null;

            private void performQuery() throws QueryEvaluationException {
                Resource subject;
                StatementPattern parentStatement;
                Var contextVar;
                StatementConstraints contraints = new StatementConstraints();
                QueryModelNode parentNode = match.getSubjectVar().getParentNode();
                if (parentNode instanceof StatementPattern && (contextVar = (parentStatement = (StatementPattern)parentNode).getContextVar()) != null) {
                    this.contextBinding = contextVar.getName();
                    Resource context = (Resource)contextVar.getValue();
                    contraints.setContext(context);
                }
                if (match.getSubjectVar().isConstant()) {
                    subject = (Resource)match.getSubjectVar().getValue();
                    contraints.setSubject(subject);
                } else if (bindings.hasBinding(this.subjectBinding)) {
                    subject = (Resource)bindings.getValue(this.subjectBinding);
                    contraints.setSubject(subject);
                }
                if (match.getPredicateVar().isConstant()) {
                    HashSet<IRI> predicates = new HashSet<IRI>(IteratorFactory.getPredicateRestrictions(match.getPredicateVar()));
                    contraints.setPredicates(predicates);
                } else if (bindings.hasBinding(this.predicateBinding)) {
                    IRI predicateUri = (IRI)bindings.getValue(this.predicateBinding);
                    Set<IRI> predicates = Collections.singleton(predicateUri);
                    contraints.setPredicates(predicates);
                }
                this.statementIt = searchFunction.performSearch(queryText, contraints);
            }

            public boolean hasNext() throws QueryEvaluationException {
                if (this.statementIt == null) {
                    this.performQuery();
                }
                return this.statementIt.hasNext();
            }

            public BindingSet next() throws QueryEvaluationException {
                if (!this.hasNext() || this.isClosed) {
                    throw new NoSuchElementException();
                }
                Statement statment = (Statement)this.statementIt.next();
                MapBindingSet bset = new MapBindingSet();
                if (!this.subjectBinding.startsWith("-const")) {
                    bset.addBinding(this.subjectBinding, (Value)statment.getSubject());
                }
                if (!this.predicateBinding.startsWith("-const")) {
                    bset.addBinding(this.predicateBinding, (Value)statment.getPredicate());
                }
                if (!this.objectBinding.startsWith("-const")) {
                    bset.addBinding(this.objectBinding, statment.getObject());
                }
                if (this.contextBinding != null && !this.contextBinding.startsWith("-const")) {
                    bset.addBinding(this.contextBinding, (Value)statment.getContext());
                }
                for (String name : bindings.getBindingNames()) {
                    bset.addBinding(name, bindings.getValue(name));
                }
                return bset;
            }

            public void remove() throws QueryEvaluationException {
                throw new UnsupportedOperationException();
            }

            public void close() throws QueryEvaluationException {
                if (this.statementIt != null) {
                    this.statementIt.close();
                }
                this.isClosed = true;
            }
        };
    }

    public static Collection<IRI> getPredicateRestrictions(Var predicate) {
        if (predicate.hasValue()) {
            return Collections.singleton((IRI)predicate.getValue());
        }
        return Collections.emptyList();
    }
}

