/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.rya.indexing.GeoConstants;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;

public class IndexingFunctionRegistry {
    private static final ValueFactory VF = SimpleValueFactory.getInstance();
    private static final Map<IRI, FUNCTION_TYPE> SEARCH_FUNCTIONS = Maps.newHashMap();

    public static Set<IRI> getFunctions() {
        return SEARCH_FUNCTIONS.keySet();
    }

    public static Var getResultVarFromFunctionCall(IRI function, List<ValueExpr> args) {
        FUNCTION_TYPE type = SEARCH_FUNCTIONS.getOrDefault(function, FUNCTION_TYPE.NONE);
        switch (type) {
            case GEO: {
                return IndexingFunctionRegistry.findBinaryResultVar(args);
            }
            case FREETEXT: {
                return IndexingFunctionRegistry.findLiteralResultVar(args);
            }
            case TEMPORAL: {
                return IndexingFunctionRegistry.findBinaryResultVar(args);
            }
        }
        return null;
    }

    public static FUNCTION_TYPE getFunctionType(IRI func) {
        return SEARCH_FUNCTIONS.get(func);
    }

    private static boolean isUnboundVariable(ValueExpr expr) {
        return expr instanceof Var && !((Var)expr).hasValue();
    }

    private static boolean isConstant(ValueExpr expr) {
        return expr instanceof ValueConstant || expr instanceof Var && ((Var)expr).hasValue();
    }

    private static Var findBinaryResultVar(List<ValueExpr> args) {
        if (args.size() >= 2) {
            ValueExpr arg1 = args.get(0);
            ValueExpr arg2 = args.get(1);
            if (IndexingFunctionRegistry.isUnboundVariable(arg1) && IndexingFunctionRegistry.isConstant(arg2)) {
                return (Var)arg1;
            }
            if (IndexingFunctionRegistry.isUnboundVariable(arg2) && IndexingFunctionRegistry.isConstant(arg1)) {
                return (Var)arg2;
            }
            return (Var)arg1;
        }
        return null;
    }

    private static Var findLiteralResultVar(List<ValueExpr> args) {
        if (args.size() >= 2) {
            ValueExpr arg1 = args.get(0);
            ValueExpr arg2 = args.get(1);
            if (IndexingFunctionRegistry.isUnboundVariable(arg1) && IndexingFunctionRegistry.isConstant(arg2)) {
                return (Var)arg1;
            }
        }
        return null;
    }

    static {
        String TEMPORAL_NS = "tag:rya-rdf.org,2015:temporal#";
        SEARCH_FUNCTIONS.put(VF.createIRI(TEMPORAL_NS + "after"), FUNCTION_TYPE.TEMPORAL);
        SEARCH_FUNCTIONS.put(VF.createIRI(TEMPORAL_NS + "before"), FUNCTION_TYPE.TEMPORAL);
        SEARCH_FUNCTIONS.put(VF.createIRI(TEMPORAL_NS + "equals"), FUNCTION_TYPE.TEMPORAL);
        SEARCH_FUNCTIONS.put(VF.createIRI(TEMPORAL_NS + "beforeInterval"), FUNCTION_TYPE.TEMPORAL);
        SEARCH_FUNCTIONS.put(VF.createIRI(TEMPORAL_NS + "afterInterval"), FUNCTION_TYPE.TEMPORAL);
        SEARCH_FUNCTIONS.put(VF.createIRI(TEMPORAL_NS + "insideInterval"), FUNCTION_TYPE.TEMPORAL);
        SEARCH_FUNCTIONS.put(VF.createIRI(TEMPORAL_NS + "hasBeginningInterval"), FUNCTION_TYPE.TEMPORAL);
        SEARCH_FUNCTIONS.put(VF.createIRI(TEMPORAL_NS + "hasEndInterval"), FUNCTION_TYPE.TEMPORAL);
        SEARCH_FUNCTIONS.put(VF.createIRI("http://rdf.useekm.com/fts#text"), FUNCTION_TYPE.FREETEXT);
        SEARCH_FUNCTIONS.put(GeoConstants.GEO_SF_EQUALS, FUNCTION_TYPE.GEO);
        SEARCH_FUNCTIONS.put(GeoConstants.GEO_SF_DISJOINT, FUNCTION_TYPE.GEO);
        SEARCH_FUNCTIONS.put(GeoConstants.GEO_SF_INTERSECTS, FUNCTION_TYPE.GEO);
        SEARCH_FUNCTIONS.put(GeoConstants.GEO_SF_TOUCHES, FUNCTION_TYPE.GEO);
        SEARCH_FUNCTIONS.put(GeoConstants.GEO_SF_WITHIN, FUNCTION_TYPE.GEO);
        SEARCH_FUNCTIONS.put(GeoConstants.GEO_SF_CONTAINS, FUNCTION_TYPE.GEO);
        SEARCH_FUNCTIONS.put(GeoConstants.GEO_SF_OVERLAPS, FUNCTION_TYPE.GEO);
        SEARCH_FUNCTIONS.put(GeoConstants.GEO_SF_CROSSES, FUNCTION_TYPE.GEO);
        SEARCH_FUNCTIONS.put(GeoConstants.GEO_SF_NEAR, FUNCTION_TYPE.GEO);
    }

    public static enum FUNCTION_TYPE {
        GEO,
        TEMPORAL,
        FREETEXT,
        NONE;

    }
}

