/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;

public class IndexingExpr {
    private final IRI function;
    private final Object[] arguments;
    private final StatementPattern spConstraint;

    public IndexingExpr(IRI function, StatementPattern spConstraint, Object ... arguments) {
        this.function = function;
        this.arguments = arguments;
        this.spConstraint = spConstraint;
    }

    public IRI getFunction() {
        return this.function;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public StatementPattern getSpConstraint() {
        return this.spConstraint;
    }

    public Set<String> getBindingNames() {
        HashSet bindings = Sets.newHashSet();
        for (Var v : this.spConstraint.getVarList()) {
            if (v.isConstant()) continue;
            bindings.add(v.getName());
        }
        return bindings;
    }

    public boolean equals(Object other) {
        if (!(other instanceof IndexingExpr)) {
            return false;
        }
        IndexingExpr arg = (IndexingExpr)other;
        return this.function.equals((Object)arg.function) && this.spConstraint.equals((Object)arg.spConstraint) && this.arguments.equals(arg.arguments);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.function.hashCode();
        result = 31 * result + this.spConstraint.hashCode();
        result = 31 * result + this.arguments.hashCode();
        return result;
    }
}

