/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.IndexPlanValidator;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.rya.indexing.IndexPlanValidator.IndexListPruner;
import org.apache.rya.indexing.external.tupleSet.ExternalTupleSet;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;

public class VarConstantIndexListPruner
implements IndexListPruner {
    private Map<String, Integer> queryConstantMap;
    private int querySpCount;
    private int queryFilterCount;

    public VarConstantIndexListPruner(TupleExpr te) {
        ConstantCollector cc = new ConstantCollector();
        te.visit((QueryModelVisitor)cc);
        this.queryConstantMap = cc.getConstantMap();
        this.querySpCount = cc.getSpCount();
        this.queryFilterCount = cc.getFilterCount();
    }

    @Override
    public List<ExternalTupleSet> getRelevantIndices(List<ExternalTupleSet> indexList) {
        ArrayList<ExternalTupleSet> relIndexSet = new ArrayList<ExternalTupleSet>();
        for (ExternalTupleSet e : indexList) {
            if (!this.isRelevant((TupleExpr)e.getTupleExpr())) continue;
            relIndexSet.add(e);
        }
        return relIndexSet;
    }

    private boolean isRelevant(TupleExpr index) {
        ConstantCollector cc = new ConstantCollector();
        index.visit((QueryModelVisitor)cc);
        Map<String, Integer> indexConstantMap = cc.getConstantMap();
        int indexSpCount = cc.getSpCount();
        int indexFilterCount = cc.getFilterCount();
        Set<String> indexConstants = indexConstantMap.keySet();
        if (indexSpCount > this.querySpCount || indexFilterCount > this.queryFilterCount || !Sets.intersection(indexConstants, this.queryConstantMap.keySet()).equals(indexConstants)) {
            return false;
        }
        for (String s : indexConstants) {
            if (indexConstantMap.get(s) <= this.queryConstantMap.get(s)) continue;
            return false;
        }
        return true;
    }

    private static class ConstantCollector
    extends AbstractQueryModelVisitor<RuntimeException> {
        private Map<String, Integer> constantMap = Maps.newHashMap();
        private int spCount = 0;
        private int filterCount = 0;

        private ConstantCollector() {
        }

        public void meet(StatementPattern node) throws RuntimeException {
            ++this.spCount;
            super.meet(node);
        }

        public void meet(Filter node) throws RuntimeException {
            ++this.filterCount;
            super.meet(node);
        }

        public void meet(Var node) throws RuntimeException {
            if (node.isConstant()) {
                String key = node.getValue().toString();
                if (this.constantMap.containsKey(key)) {
                    int count = this.constantMap.get(key);
                    this.constantMap.put(key, ++count);
                } else {
                    this.constantMap.put(key, 1);
                }
            }
        }

        public void meet(ValueConstant node) throws RuntimeException {
            String key = node.getValue().toString();
            if (this.constantMap.containsKey(key)) {
                int count = this.constantMap.get(key);
                this.constantMap.put(key, ++count);
            } else {
                this.constantMap.put(key, 1);
            }
        }

        public Map<String, Integer> getConstantMap() {
            return this.constantMap;
        }

        public int getSpCount() {
            return this.spCount;
        }

        public int getFilterCount() {
            return this.filterCount;
        }
    }
}

