/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.IndexPlanValidator;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.rya.indexing.external.tupleSet.ExternalTupleSet;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;

public class ValidIndexCombinationGenerator {
    private Set<String> invalidCombos = Sets.newTreeSet();
    private Set<QueryModelNode> spFilterSet;

    public ValidIndexCombinationGenerator(TupleExpr query) {
        SpFilterCollector sfc = new SpFilterCollector();
        query.visit((QueryModelVisitor)sfc);
        this.spFilterSet = sfc.getSpFilterSet();
    }

    public ValidIndexCombinationGenerator(List<QueryModelNode> qNodes) {
        this.spFilterSet = Sets.newHashSet(qNodes);
    }

    public Iterator<List<ExternalTupleSet>> getValidIndexCombos(List<ExternalTupleSet> indexSet) {
        Collections.shuffle(indexSet);
        final List<ExternalTupleSet> list = indexSet;
        final Iterator<List<Integer>> iter = this.getValidCombos(list);
        return new Iterator<List<ExternalTupleSet>>(){
            private List<ExternalTupleSet> next = null;
            private List<Integer> nextCombo = null;
            private boolean hasNextCalled = false;
            private boolean isEmpty = false;

            @Override
            public boolean hasNext() {
                if (!this.hasNextCalled && !this.isEmpty) {
                    if (!iter.hasNext()) {
                        this.isEmpty = true;
                        return false;
                    }
                    this.nextCombo = (List)iter.next();
                    ArrayList indexCombo = Lists.newArrayList();
                    for (Integer i : this.nextCombo) {
                        indexCombo.add(list.get(i));
                    }
                    this.next = indexCombo;
                    this.hasNextCalled = true;
                    return true;
                }
                return !this.isEmpty;
            }

            @Override
            public List<ExternalTupleSet> next() {
                if (this.hasNextCalled) {
                    this.hasNextCalled = false;
                    return this.next;
                }
                if (this.isEmpty) {
                    throw new NoSuchElementException();
                }
                if (this.hasNext()) {
                    this.hasNextCalled = false;
                    return this.next;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot delete from iterator!");
            }
        };
    }

    private Iterator<List<Integer>> getValidCombos(List<ExternalTupleSet> indexList) {
        final List<ExternalTupleSet> list = indexList;
        int indexSize = list.size();
        final Iterator<List<Integer>> iter = this.getCombos(indexSize);
        return new Iterator<List<Integer>>(){
            private List<Integer> next = null;
            private boolean hasNextCalled = false;
            private boolean isEmpty = false;

            @Override
            public boolean hasNext() {
                if (!this.hasNextCalled && !this.isEmpty) {
                    while (iter.hasNext()) {
                        List tempNext = (List)iter.next();
                        if (!ValidIndexCombinationGenerator.this.isValid(tempNext, list)) continue;
                        this.next = tempNext;
                        this.hasNextCalled = true;
                        return true;
                    }
                    this.isEmpty = true;
                    return false;
                }
                return !this.isEmpty;
            }

            @Override
            public List<Integer> next() {
                if (this.hasNextCalled) {
                    this.hasNextCalled = false;
                    return this.next;
                }
                if (this.isEmpty) {
                    throw new NoSuchElementException();
                }
                if (this.hasNext()) {
                    this.hasNextCalled = false;
                    return this.next;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot delete from iterator!");
            }
        };
    }

    private Iterator<List<Integer>> getCombos(int indexListSize) {
        final int indexSize = indexListSize;
        final int maxSubListSize = this.spFilterSet.size() / 2;
        return new Iterator<List<Integer>>(){
            private List<Integer> next = null;
            private boolean hasNextCalled = false;
            private boolean isEmpty = false;
            private int subListSize = Math.min(maxSubListSize, indexSize) + 1;
            Iterator<List<Integer>> subList = null;

            @Override
            public boolean hasNext() {
                if (!this.hasNextCalled && !this.isEmpty) {
                    if (this.subList != null && this.subList.hasNext()) {
                        this.next = this.subList.next();
                        this.hasNextCalled = true;
                        return true;
                    }
                    --this.subListSize;
                    if (this.subListSize == 0) {
                        this.isEmpty = true;
                        return false;
                    }
                    this.subList = ValidIndexCombinationGenerator.this.getCombos(this.subListSize, indexSize);
                    if (this.subList == null) {
                        throw new IllegalStateException("Combos cannot be null!");
                    }
                    this.next = this.subList.next();
                    this.hasNextCalled = true;
                    return true;
                }
                return !this.isEmpty;
            }

            @Override
            public List<Integer> next() {
                if (this.hasNextCalled) {
                    this.hasNextCalled = false;
                    return this.next;
                }
                if (this.isEmpty) {
                    throw new NoSuchElementException();
                }
                if (this.hasNext()) {
                    this.hasNextCalled = false;
                    return this.next;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot delete from iterator!");
            }
        };
    }

    private Iterator<List<Integer>> getCombos(int subListSize, int indexListSize) {
        if (subListSize > indexListSize) {
            throw new IllegalArgumentException("Sublist size must be less than or equal to list size!");
        }
        final int subSize = subListSize;
        final int indexSize = indexListSize;
        return new Iterator<List<Integer>>(){
            private List<Integer> next = null;
            private List<Integer> tempList = Lists.newArrayList();
            private boolean calledHasNext = false;
            private boolean isEmpty = false;

            @Override
            public boolean hasNext() {
                if (!this.calledHasNext && !this.isEmpty) {
                    if (this.next == null) {
                        for (int i = 0; i < subSize; ++i) {
                            this.tempList.add(i);
                        }
                        this.next = this.tempList;
                        this.calledHasNext = true;
                        return true;
                    }
                    this.next = ValidIndexCombinationGenerator.this.getNext(this.next, indexSize - 1);
                    if (this.next == null) {
                        this.isEmpty = true;
                        return false;
                    }
                    this.calledHasNext = true;
                    return true;
                }
                return !this.isEmpty;
            }

            @Override
            public List<Integer> next() {
                if (this.calledHasNext) {
                    this.calledHasNext = false;
                    return this.next;
                }
                if (this.isEmpty) {
                    throw new NoSuchElementException();
                }
                if (this.hasNext()) {
                    this.calledHasNext = false;
                    return this.next;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private List<Integer> getNext(List<Integer> prev, int maxInt) {
        int i;
        ArrayList returnList = Lists.newArrayList();
        int size = prev.size();
        int incrementPos = -1;
        int incrementVal = 0;
        for (i = 0; i < size; ++i) {
            if (prev.get(size - (i + 1)) == maxInt - i) continue;
            incrementPos = size - (i + 1);
            break;
        }
        if (incrementPos == -1) {
            return null;
        }
        incrementVal = prev.get(incrementPos);
        for (i = 0; i < incrementPos; ++i) {
            returnList.add(prev.get(i));
        }
        for (int j = incrementPos; j < size; ++j) {
            returnList.add(++incrementVal);
        }
        return returnList;
    }

    private boolean isValid(List<Integer> combo, List<ExternalTupleSet> indexList) {
        String s1 = Joiner.on((String)"\u0000").join(combo).trim();
        if (this.invalidCombos.contains(s1)) {
            return false;
        }
        int valid = this.indicesDisjoint(combo, indexList);
        if (valid >= 0) {
            int i;
            String s2 = "";
            for (i = 0; i < valid + 1; ++i) {
                s2 = s2.length() == 0 ? s2 + combo.get(i) : s2 + "\u0000" + combo.get(i);
            }
            this.invalidCombos.add(s2);
            for (i = valid + 1; i < combo.size(); ++i) {
                s2 = s2 + "\u0000" + combo.get(i);
                this.invalidCombos.add(s2);
            }
            return false;
        }
        return true;
    }

    private int indicesDisjoint(List<Integer> combo, List<ExternalTupleSet> indexList) {
        HashSet indexNodes = Sets.newHashSet();
        int j = 0;
        for (Integer i : combo) {
            Projection temp = indexList.get(i).getTupleExpr();
            SpFilterCollector spf = new SpFilterCollector();
            temp.visit((QueryModelVisitor)spf);
            Set<QueryModelNode> tempNodes = spf.getSpFilterSet();
            if (Sets.intersection((Set)indexNodes, tempNodes).size() == 0) {
                if ((indexNodes = Sets.union((Set)indexNodes, tempNodes)).size() > this.spFilterSet.size()) {
                    return j;
                }
            } else {
                return j;
            }
            ++j;
        }
        return -1;
    }

    private static class SpFilterCollector
    extends AbstractQueryModelVisitor<RuntimeException> {
        private Set<QueryModelNode> spFilterSet = Sets.newHashSet();

        private SpFilterCollector() {
        }

        public Set<QueryModelNode> getSpFilterSet() {
            return this.spFilterSet;
        }

        public void meet(StatementPattern node) {
            this.spFilterSet.add((QueryModelNode)node);
        }

        public void meet(Filter node) {
            this.spFilterSet.add((QueryModelNode)node.getCondition());
            node.getArg().visit((QueryModelVisitor)this);
        }
    }
}

