/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.IndexPlanValidator;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.rya.indexing.external.tupleSet.ExternalTupleSet;
import org.apache.rya.rdftriplestore.inference.DoNotExpandSP;
import org.apache.rya.rdftriplestore.utils.FixedStatementPattern;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;

public class TupleReArranger {
    private static Map<Join, List<List<TupleExpr>>> joinArgs;
    private static Map<Join, List<Filter>> filterArgs;

    public static Iterator<TupleExpr> getPlans(Iterator<TupleExpr> indexPlans) {
        final Iterator<TupleExpr> iter = indexPlans;
        return new Iterator<TupleExpr>(){
            private TupleExpr next = null;
            private boolean hasNextCalled = false;
            private boolean isEmpty = false;
            Iterator<TupleExpr> tuples = null;

            @Override
            public boolean hasNext() {
                if (!this.hasNextCalled && !this.isEmpty) {
                    if (this.tuples != null && this.tuples.hasNext()) {
                        this.next = this.tuples.next();
                        this.hasNextCalled = true;
                        return true;
                    }
                    if (iter.hasNext()) {
                        this.tuples = TupleReArranger.getTupleReOrderings((TupleExpr)iter.next()).iterator();
                        if (this.tuples == null) {
                            throw new IllegalStateException("Plans cannot be null!");
                        }
                        this.next = this.tuples.next();
                        this.hasNextCalled = true;
                        return true;
                    }
                    this.isEmpty = true;
                    return false;
                }
                return !this.isEmpty;
            }

            @Override
            public TupleExpr next() {
                if (this.hasNextCalled) {
                    this.hasNextCalled = false;
                    return this.next;
                }
                if (this.isEmpty) {
                    throw new NoSuchElementException();
                }
                if (this.hasNext()) {
                    this.hasNextCalled = false;
                    return this.next;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot delete from iterator!");
            }
        };
    }

    public static List<TupleExpr> getTupleReOrderings(TupleExpr te) {
        joinArgs = Maps.newHashMap();
        filterArgs = Maps.newHashMap();
        NodeCollector nc = new NodeCollector();
        te.visit((QueryModelVisitor)nc);
        joinArgs = nc.getPerms();
        ArrayList joins = Lists.newArrayList(joinArgs.keySet());
        return TupleReArranger.getPlans(TupleReArranger.getReOrderings(joins), te);
    }

    private static List<TupleExpr> getPlans(List<Map<Join, List<TupleExpr>>> reOrderings, TupleExpr te) {
        ArrayList queryPlans = Lists.newArrayList();
        PermInserter pm = new PermInserter();
        for (Map<Join, List<TupleExpr>> order : reOrderings) {
            TupleExpr clone = te.clone();
            pm.setReOrderMap(order);
            clone.visit((QueryModelVisitor)pm);
            queryPlans.add(clone);
        }
        return queryPlans;
    }

    private static List<Map<Join, List<TupleExpr>>> getReOrderings(List<Join> joins) {
        HashMap reOrder = Maps.newHashMap();
        ArrayList reOrderings = Lists.newArrayList();
        TupleReArranger.getReOrderings(joins, reOrder, reOrderings);
        return reOrderings;
    }

    private static void getReOrderings(List<Join> joins, Map<Join, List<TupleExpr>> reOrder, List<Map<Join, List<TupleExpr>>> reOrderings) {
        if (joins.isEmpty()) {
            reOrderings.add(reOrder);
            return;
        }
        ArrayList joinsCopy = Lists.newArrayList(joins);
        Join join = (Join)joinsCopy.remove(0);
        List<List<TupleExpr>> joinArgPerms = joinArgs.get(join);
        for (List<TupleExpr> tupList : joinArgPerms) {
            HashMap newReOrder = Maps.newHashMap(reOrder);
            newReOrder.put(join, tupList);
            TupleReArranger.getReOrderings(joinsCopy, newReOrder, reOrderings);
        }
    }

    private static List<TupleExpr> getFilterChain(List<Filter> filters) {
        ArrayList filterTopBottom = Lists.newArrayList();
        Filter filterChainTop = null;
        Filter filterChainBottom = null;
        for (Filter filter : filters) {
            if (filterChainTop == null) {
                filterChainTop = filter.clone();
                continue;
            }
            if (filterChainBottom == null) {
                filterChainBottom = filter.clone();
                filterChainTop.setArg((TupleExpr)filterChainBottom);
                continue;
            }
            Filter newFilter = filter.clone();
            filterChainBottom.setArg((TupleExpr)newFilter);
            filterChainBottom = newFilter;
        }
        if (filterChainTop != null) {
            filterTopBottom.add(filterChainTop);
        }
        if (filterChainBottom != null) {
            filterTopBottom.add(filterChainBottom);
        }
        return filterTopBottom;
    }

    private static TupleExpr getNewJoin(List<TupleExpr> args, List<TupleExpr> filterChain) {
        TupleExpr newJoin;
        ArrayList joinArgs = Lists.newArrayList(args);
        if (joinArgs.size() > 1) {
            if (filterChain.size() > 0) {
                TupleExpr tempJoin;
                TupleExpr finalJoinArg = ((TupleExpr)joinArgs.remove(0)).clone();
                TupleExpr temp = filterChain.get(0);
                if (joinArgs.size() > 1) {
                    tempJoin = new Join(((TupleExpr)joinArgs.remove(0)).clone(), ((TupleExpr)joinArgs.remove(0)).clone());
                    for (TupleExpr te : joinArgs) {
                        tempJoin = new Join(tempJoin, te.clone());
                    }
                } else {
                    tempJoin = ((TupleExpr)joinArgs.remove(0)).clone();
                }
                if (filterChain.size() == 1) {
                    ((Filter)temp).setArg(tempJoin);
                } else {
                    ((Filter)filterChain.get(1)).setArg(tempJoin);
                }
                newJoin = new Join(temp, finalJoinArg);
            } else {
                newJoin = new Join(((TupleExpr)joinArgs.remove(0)).clone(), ((TupleExpr)joinArgs.remove(0)).clone());
                for (TupleExpr te : joinArgs) {
                    newJoin = new Join(newJoin, te.clone());
                }
            }
        } else if (joinArgs.size() == 1) {
            if (filterChain.size() > 0) {
                newJoin = filterChain.get(0);
                if (filterChain.size() == 1) {
                    ((Filter)newJoin).setArg(((TupleExpr)joinArgs.get(0)).clone());
                } else {
                    ((Filter)filterChain.get(1)).setArg(((TupleExpr)joinArgs.get(0)).clone());
                }
            } else {
                newJoin = ((TupleExpr)joinArgs.get(0)).clone();
            }
        } else {
            throw new IllegalStateException("JoinArgs size cannot be zero.");
        }
        return newJoin;
    }

    private static class PermInserter
    extends AbstractQueryModelVisitor<RuntimeException> {
        private Map<Join, List<TupleExpr>> reOrderMap = Maps.newHashMap();

        private PermInserter() {
        }

        public void setReOrderMap(Map<Join, List<TupleExpr>> reOrderMap) {
            this.reOrderMap = reOrderMap;
        }

        public void meet(Join node) {
            List<TupleExpr> reOrder = this.reOrderMap.get(node);
            if (reOrder != null) {
                ArrayList filterList = Lists.newArrayList((Iterable)((Iterable)filterArgs.get(node)));
                node.replaceWith((QueryModelNode)TupleReArranger.getNewJoin(reOrder, TupleReArranger.getFilterChain(filterList)));
                for (TupleExpr te : reOrder) {
                    if (te instanceof StatementPattern || te instanceof ExternalTupleSet) continue;
                    te.visit((QueryModelVisitor)this);
                }
            }
            super.meet(node);
        }
    }

    private static class NodeCollector
    extends AbstractQueryModelVisitor<RuntimeException> {
        private static List<Filter> filterList;

        private NodeCollector() {
        }

        public Map<Join, List<List<TupleExpr>>> getPerms() {
            return joinArgs;
        }

        public void meet(Join node) {
            filterList = Lists.newArrayList();
            List<Object> args = Lists.newArrayList();
            args = NodeCollector.getJoinArgs((TupleExpr)node, (List<TupleExpr>)args);
            ArrayList argPerms = Lists.newArrayList((Iterable)Collections2.permutations((Collection)args));
            joinArgs.put(node, argPerms);
            filterArgs.put(node, filterList);
            for (TupleExpr tupleExpr : args) {
                if (tupleExpr instanceof StatementPattern || tupleExpr instanceof ExternalTupleSet) continue;
                tupleExpr.visit((QueryModelVisitor)this);
            }
        }

        private static List<TupleExpr> getJoinArgs(TupleExpr tupleExpr, List<TupleExpr> joinArgs) {
            if (tupleExpr instanceof Join) {
                if (!(((Join)tupleExpr).getLeftArg() instanceof FixedStatementPattern) && !(((Join)tupleExpr).getRightArg() instanceof DoNotExpandSP)) {
                    Join join = (Join)tupleExpr;
                    NodeCollector.getJoinArgs(join.getLeftArg(), joinArgs);
                    NodeCollector.getJoinArgs(join.getRightArg(), joinArgs);
                }
            } else if (tupleExpr instanceof Filter) {
                filterList.add((Filter)tupleExpr);
                NodeCollector.getJoinArgs(((Filter)tupleExpr).getArg(), joinArgs);
            } else {
                joinArgs.add(tupleExpr);
            }
            return joinArgs;
        }
    }
}

