/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.IndexPlanValidator;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.rya.indexing.IndexPlanValidator.IndexTupleGenerator;
import org.apache.rya.indexing.external.tupleSet.ExternalTupleSet;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;

public class TupleExecutionPlanGenerator
implements IndexTupleGenerator {
    @Override
    public Iterator<TupleExpr> getPlans(Iterator<TupleExpr> indexPlans) {
        final Iterator<TupleExpr> iter = indexPlans;
        return new Iterator<TupleExpr>(){
            private TupleExpr next = null;
            private boolean hasNextCalled = false;
            private boolean isEmpty = false;
            Iterator<TupleExpr> tuples = null;

            @Override
            public boolean hasNext() {
                if (!this.hasNextCalled && !this.isEmpty) {
                    if (this.tuples != null && this.tuples.hasNext()) {
                        this.next = this.tuples.next();
                        this.hasNextCalled = true;
                        return true;
                    }
                    if (iter.hasNext()) {
                        this.tuples = TupleExecutionPlanGenerator.this.getPlans((TupleExpr)iter.next()).iterator();
                        if (this.tuples == null) {
                            throw new IllegalStateException("Plans cannot be null!");
                        }
                        this.next = this.tuples.next();
                        this.hasNextCalled = true;
                        return true;
                    }
                    this.isEmpty = true;
                    return false;
                }
                return !this.isEmpty;
            }

            @Override
            public TupleExpr next() {
                if (this.hasNextCalled) {
                    this.hasNextCalled = false;
                    return this.next;
                }
                if (this.isEmpty) {
                    throw new NoSuchElementException();
                }
                if (this.hasNext()) {
                    this.hasNextCalled = false;
                    return this.next;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot delete from iterator!");
            }
        };
    }

    private List<TupleExpr> getPlans(TupleExpr te) {
        NodeCollector nc = new NodeCollector();
        te.visit((QueryModelVisitor)nc);
        Set<QueryModelNode> nodeSet = nc.getNodeSet();
        List<Filter> filterList = nc.getFilterSet();
        Projection projection = nc.getProjection().clone();
        ArrayList queryPlans = Lists.newArrayList();
        Collection plans = Collections2.permutations(nodeSet);
        for (List p : plans) {
            if (p.size() == 0) {
                throw new IllegalArgumentException("Tuple must contain at least one node!");
            }
            if (p.size() == 1) {
                queryPlans.add(te);
                continue;
            }
            queryPlans.add(this.buildTuple(p, filterList, projection));
        }
        return queryPlans;
    }

    private TupleExpr buildTuple(List<QueryModelNode> nodes, List<Filter> filters, Projection projection) {
        Projection proj = projection.clone();
        Join join = null;
        join = new Join((TupleExpr)nodes.get(0).clone(), (TupleExpr)nodes.get(1).clone());
        for (int i = 2; i < nodes.size(); ++i) {
            join = new Join((TupleExpr)join, (TupleExpr)nodes.get(i).clone());
        }
        if (filters.size() == 0) {
            proj.setArg((TupleExpr)join);
            return proj;
        }
        Join queryPlan = join;
        for (Filter f : filters) {
            Filter filt = f.clone();
            filt.setArg((TupleExpr)queryPlan);
            queryPlan = filt;
        }
        proj.setArg((TupleExpr)queryPlan);
        return proj;
    }

    public static class NodeCollector
    extends AbstractQueryModelVisitor<RuntimeException> {
        private final Set<QueryModelNode> nodeSet = Sets.newHashSet();
        private final List<Filter> filterSet = Lists.newArrayList();
        private Projection projection;

        public Projection getProjection() {
            return this.projection;
        }

        public Set<QueryModelNode> getNodeSet() {
            return this.nodeSet;
        }

        public List<Filter> getFilterSet() {
            return this.filterSet;
        }

        public void meet(Projection node) {
            this.projection = node;
            node.getArg().visit((QueryModelVisitor)this);
        }

        public void meetNode(QueryModelNode node) throws RuntimeException {
            if (node instanceof ExternalTupleSet || node instanceof BindingSetAssignment || node instanceof StatementPattern) {
                this.nodeSet.add(node);
            }
            super.meetNode(node);
        }

        public void meet(Filter node) {
            this.filterSet.add(node);
            node.getArg().visit((QueryModelVisitor)this);
        }
    }
}

