/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.IndexPlanValidator;

import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Set;
import org.apache.rya.api.domain.VarNameUtils;
import org.apache.rya.indexing.IndexPlanValidator.IndexedQueryPlanSelector;
import org.apache.rya.indexing.external.tupleSet.ExternalTupleSet;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;

public class ThreshholdPlanSelector
implements IndexedQueryPlanSelector {
    private TupleExpr query;
    private int queryNodeCount = 0;

    public ThreshholdPlanSelector(TupleExpr query) {
        this.query = query;
        QueryNodeCount qnc = new QueryNodeCount();
        query.visit((QueryModelVisitor)qnc);
        this.queryNodeCount = qnc.getNodeCount();
        if (this.queryNodeCount == 0) {
            throw new IllegalArgumentException("TupleExpr must contain at least one node!");
        }
    }

    @Override
    public TupleExpr getThreshholdQueryPlan(Iterator<TupleExpr> tuples, double threshhold, double indexWeight, double commonVarWeight, double extProdWeight) {
        if (threshhold < 0.0 || threshhold > 1.0) {
            throw new IllegalArgumentException("Threshhold must be between 0 and 1!");
        }
        double minCost = Double.MAX_VALUE;
        TupleExpr minTup = null;
        double tempCost = 0.0;
        TupleExpr tempTup = null;
        while (tuples.hasNext()) {
            tempTup = tuples.next();
            tempCost = this.getCost(tempTup, indexWeight, commonVarWeight, extProdWeight);
            if (tempCost < minCost) {
                minCost = tempCost;
                minTup = tempTup;
            }
            if (!(minCost <= threshhold)) continue;
            return minTup;
        }
        return minTup;
    }

    public double getCost(TupleExpr te, double indexWeight, double commonVarWeight, double dirProdWeight) {
        if (indexWeight + commonVarWeight + dirProdWeight != 1.0) {
            throw new IllegalArgumentException("Weights must sum to 1!");
        }
        if (te == null) {
            throw new IllegalArgumentException("TupleExpr cannot be null!");
        }
        QueryNodeCount qnc = new QueryNodeCount();
        te.visit((QueryModelVisitor)qnc);
        double nodeCount = qnc.getNodeCount();
        double commonJoinVars = qnc.getCommonJoinVarCount();
        double joinVars = qnc.getJoinVarCount();
        double joinCount = qnc.getJoinCount();
        double dirProdCount = qnc.getDirProdCount();
        double dirProductScale = (double)this.queryNodeCount > nodeCount ? 1.0 / ((double)this.queryNodeCount - nodeCount) : 1.0 / ((double)this.queryNodeCount - nodeCount + 1.0);
        double joinVarRatio = joinVars != 0.0 ? (joinVars - commonJoinVars) / joinVars : 0.0;
        double dirProductRatio = joinCount != 0.0 ? dirProdCount / joinCount : 0.0;
        double cost = indexWeight * (nodeCount / (double)this.queryNodeCount) + commonVarWeight * joinVarRatio + dirProdWeight * dirProductRatio * dirProductScale;
        return cost;
    }

    public static class QueryNodeCount
    extends AbstractQueryModelVisitor<RuntimeException> {
        private int nodeCount = 0;
        private int commonJoinVars = 0;
        private int joinVars = 0;
        private int joinCount = 0;
        private int dirProdCount = 0;

        public int getCommonJoinVarCount() {
            return this.commonJoinVars;
        }

        public int getJoinVarCount() {
            return this.joinVars;
        }

        public int getNodeCount() {
            return this.nodeCount;
        }

        public int getJoinCount() {
            return this.joinCount;
        }

        public int getDirProdCount() {
            return this.dirProdCount;
        }

        public void meet(Projection node) {
            node.getArg().visit((QueryModelVisitor)this);
        }

        public void meetNode(QueryModelNode node) {
            if (node instanceof ExternalTupleSet) {
                ++this.nodeCount;
                return;
            }
            super.meetNode(node);
        }

        public void meet(StatementPattern node) {
            ++this.nodeCount;
        }

        public void meet(Filter node) {
            ++this.nodeCount;
            node.getArg().visit((QueryModelVisitor)this);
        }

        public void meet(BindingSetAssignment node) {
            ++this.nodeCount;
        }

        public void meet(Join node) {
            int tempCount = 0;
            Set lNames = node.getLeftArg().getAssuredBindingNames();
            Set rNames = node.getRightArg().getAssuredBindingNames();
            for (String s : node.getLeftArg().getBindingNames()) {
                if (!VarNameUtils.isConstant((String)s)) continue;
                lNames.remove(s);
            }
            for (String s : node.getRightArg().getBindingNames()) {
                if (!VarNameUtils.isConstant((String)s)) continue;
                rNames.remove(s);
            }
            this.joinVars += Math.min(lNames.size(), rNames.size());
            tempCount = Sets.intersection((Set)lNames, (Set)rNames).size();
            if (tempCount == 0) {
                ++this.dirProdCount;
            } else {
                this.commonJoinVars += tempCount;
            }
            ++this.joinCount;
            super.meet(node);
        }
    }
}

