/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.IndexPlanValidator;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.rya.indexing.IndexPlanValidator.ExternalIndexMatcher;
import org.apache.rya.indexing.IndexPlanValidator.GeneralizedExternalProcessor;
import org.apache.rya.indexing.IndexPlanValidator.ValidIndexCombinationGenerator;
import org.apache.rya.indexing.IndexPlanValidator.VarConstantIndexListPruner;
import org.apache.rya.indexing.external.tupleSet.ExternalTupleSet;
import org.apache.rya.indexing.pcj.matching.QueryVariableNormalizer;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.TupleExpr;

public class IndexedExecutionPlanGenerator
implements ExternalIndexMatcher {
    private final TupleExpr query;
    private final List<ExternalTupleSet> normalizedIndexList;

    public IndexedExecutionPlanGenerator(TupleExpr query, List<ExternalTupleSet> indexList) {
        this.query = query;
        VarConstantIndexListPruner vci = new VarConstantIndexListPruner(query);
        this.normalizedIndexList = this.getNormalizedIndices(vci.getRelevantIndices(indexList));
    }

    public List<ExternalTupleSet> getNormalizedIndices() {
        return this.normalizedIndexList;
    }

    @Override
    public Iterator<TupleExpr> getIndexedTuples() {
        ValidIndexCombinationGenerator vic = new ValidIndexCombinationGenerator(this.query);
        final Iterator<List<ExternalTupleSet>> iter = vic.getValidIndexCombos(this.normalizedIndexList);
        return new Iterator<TupleExpr>(){
            private TupleExpr next = null;
            private boolean hasNextCalled = false;
            private boolean isEmpty = false;

            @Override
            public boolean hasNext() {
                if (!this.hasNextCalled && !this.isEmpty) {
                    while (iter.hasNext()) {
                        TupleExpr temp = GeneralizedExternalProcessor.process(IndexedExecutionPlanGenerator.this.query, (List)iter.next());
                        if (temp == null) continue;
                        this.next = temp;
                        this.hasNextCalled = true;
                        return true;
                    }
                    this.isEmpty = true;
                    return false;
                }
                return !this.isEmpty;
            }

            @Override
            public TupleExpr next() {
                if (this.hasNextCalled) {
                    this.hasNextCalled = false;
                    return this.next;
                }
                if (this.isEmpty) {
                    throw new NoSuchElementException();
                }
                if (this.hasNext()) {
                    this.hasNextCalled = false;
                    return this.next;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot delete from iterator!");
            }
        };
    }

    private List<ExternalTupleSet> getNormalizedIndices(List<ExternalTupleSet> indexSet) {
        ArrayList normalizedIndexSet = Lists.newArrayList();
        for (ExternalTupleSet e : indexSet) {
            List<TupleExpr> tupList = null;
            try {
                tupList = QueryVariableNormalizer.getNormalizedIndex(this.query, (TupleExpr)e.getTupleExpr());
            }
            catch (Exception e1) {
                e1.printStackTrace();
                throw new Error(e1);
            }
            for (TupleExpr te : tupList) {
                ExternalTupleSet tempIndex = (ExternalTupleSet)e.clone();
                tempIndex.setProjectionExpr((Projection)te);
                normalizedIndexSet.add(tempIndex);
            }
        }
        return normalizedIndexSet;
    }
}

