/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.IndexPlanValidator;

import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.rya.indexing.IndexPlanValidator.TupleValidator;
import org.apache.rya.indexing.external.tupleSet.ExternalTupleSet;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;

public class IndexPlanValidator
implements TupleValidator {
    private boolean omitCrossProd = false;

    public IndexPlanValidator(boolean omitCrossProd) {
        this.omitCrossProd = omitCrossProd;
    }

    public void setOmitCrossProd(boolean omitCrossProd) {
        this.omitCrossProd = omitCrossProd;
    }

    @Override
    public boolean isValid(TupleExpr te) {
        TupleValidateVisitor tv = new TupleValidateVisitor();
        te.visit((QueryModelVisitor)tv);
        return tv.isValid();
    }

    public int getValidTupleSize(Iterator<TupleExpr> iter) {
        int size = 0;
        while (iter.hasNext()) {
            if (!this.isValid(iter.next())) continue;
            ++size;
        }
        return size;
    }

    @Override
    public Iterator<TupleExpr> getValidTuples(Iterator<TupleExpr> tupleIter) {
        final Iterator<TupleExpr> iter = tupleIter;
        return new Iterator<TupleExpr>(){
            private TupleExpr next = null;
            private boolean hasNextCalled = false;
            private boolean isEmpty = false;

            @Override
            public boolean hasNext() {
                if (!this.hasNextCalled && !this.isEmpty) {
                    while (iter.hasNext()) {
                        TupleExpr temp = (TupleExpr)iter.next();
                        if (!IndexPlanValidator.this.isValid(temp)) continue;
                        this.next = temp;
                        this.hasNextCalled = true;
                        return true;
                    }
                    this.isEmpty = true;
                    return false;
                }
                return !this.isEmpty;
            }

            @Override
            public TupleExpr next() {
                if (this.hasNextCalled) {
                    this.hasNextCalled = false;
                    return this.next;
                }
                if (this.isEmpty) {
                    throw new NoSuchElementException();
                }
                if (this.hasNext()) {
                    this.hasNextCalled = false;
                    return this.next;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot delete from iterator!");
            }
        };
    }

    private boolean isJoinValid(Join join) {
        Set rightBindingNames;
        Set leftBindingNames = join.getLeftArg().getBindingNames();
        if (Sets.intersection((Set)leftBindingNames, (Set)(rightBindingNames = join.getRightArg().getBindingNames())).size() == 0) {
            return !this.omitCrossProd;
        }
        if (join.getRightArg() instanceof ExternalTupleSet) {
            return ((ExternalTupleSet)join.getRightArg()).supportsBindingSet(leftBindingNames);
        }
        return true;
    }

    public class TupleValidateVisitor
    extends AbstractQueryModelVisitor<RuntimeException> {
        private boolean isValid = true;

        public boolean isValid() {
            return this.isValid;
        }

        public void meet(Projection node) {
            node.getArg().visit((QueryModelVisitor)this);
        }

        public void meet(StatementPattern node) {
        }

        public void meet(BindingSetAssignment node) {
        }

        public void meet(Filter node) {
            node.getArg().visit((QueryModelVisitor)this);
        }

        public void meet(Join node) {
            if (!IndexPlanValidator.this.isJoinValid(node)) {
                this.isValid = false;
                return;
            }
            super.meet(node);
        }
    }
}

