/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.IndexPlanValidator;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.rya.indexing.external.tupleSet.ExternalTupleSet;
import org.apache.rya.indexing.pcj.matching.QueryVariableNormalizer;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.helpers.StatementPatternCollector;

public class GeneralizedExternalProcessor {
    public static TupleExpr process(TupleExpr query, List<ExternalTupleSet> indexSet) {
        boolean indexPlaced = false;
        TupleExpr rtn = query.clone();
        QueryNodeCount qnc = new QueryNodeCount();
        rtn.visit((QueryModelVisitor)qnc);
        if (qnc.getNodeCount() / 2 < indexSet.size()) {
            return null;
        }
        GeneralizedExternalProcessor.organizeBSAs((QueryModelNode)rtn);
        if (GeneralizedExternalProcessor.isTupleValid((QueryModelNode)rtn)) {
            for (ExternalTupleSet index : indexSet) {
                if (!GeneralizedExternalProcessor.isTupleValid((QueryModelNode)index.getTupleExpr())) continue;
                ExternalTupleSet eTup = (ExternalTupleSet)index.clone();
                SPBubbleDownVisitor indexVistor = new SPBubbleDownVisitor(eTup);
                rtn.visit((QueryModelVisitor)indexVistor);
                FilterBubbleManager fbmv = new FilterBubbleManager(eTup);
                rtn.visit((QueryModelVisitor)fbmv);
                SubsetEqualsVisitor subIndexVis = new SubsetEqualsVisitor(eTup, rtn);
                rtn.visit((QueryModelVisitor)subIndexVis);
                indexPlaced = subIndexVis.indexPlaced();
                if (indexPlaced) continue;
                break;
            }
            if (indexPlaced) {
                return rtn;
            }
            return null;
        }
        throw new IllegalArgumentException("Invalid Query.");
    }

    private static boolean isTupleValid(QueryModelNode node) {
        ValidQueryVisitor vqv = new ValidQueryVisitor();
        node.visit((QueryModelVisitor)vqv);
        Set<String> spVars = GeneralizedExternalProcessor.getVarNames(GeneralizedExternalProcessor.getQNodes("sp", node));
        if (vqv.isValid() && spVars.size() > 0) {
            FilterCollector fvis = new FilterCollector();
            node.visit((QueryModelVisitor)fvis);
            List<QueryModelNode> fList = fvis.getFilters();
            return fList.size() == Sets.newHashSet(fList).size() && GeneralizedExternalProcessor.getVarNames(fList).size() <= spVars.size();
        }
        return false;
    }

    private static Set<QueryModelNode> getQNodes(QueryModelNode queryNode) {
        HashSet<QueryModelNode> rtns = new HashSet<QueryModelNode>();
        StatementPatternCollector spc = new StatementPatternCollector();
        queryNode.visit((QueryModelVisitor)spc);
        rtns.addAll(spc.getStatementPatterns());
        FilterCollector fvis = new FilterCollector();
        queryNode.visit((QueryModelVisitor)fvis);
        rtns.addAll(fvis.getFilters());
        ExternalTupleCollector eVis = new ExternalTupleCollector();
        queryNode.visit((QueryModelVisitor)eVis);
        rtns.addAll(eVis.getExtTup());
        return rtns;
    }

    private static Set<QueryModelNode> getQNodes(String node, QueryModelNode queryNode) {
        if (node.equals("sp")) {
            HashSet<QueryModelNode> eSet = new HashSet<QueryModelNode>();
            StatementPatternCollector spc = new StatementPatternCollector();
            queryNode.visit((QueryModelVisitor)spc);
            List spList = spc.getStatementPatterns();
            eSet.addAll(spList);
            if (spList.size() > eSet.size()) {
                return Sets.newHashSet();
            }
            return eSet;
        }
        if (node.equals("filter")) {
            FilterCollector fvis = new FilterCollector();
            queryNode.visit((QueryModelVisitor)fvis);
            return Sets.newHashSet(fvis.getFilters());
        }
        throw new IllegalArgumentException("Invalid node type.");
    }

    private static Set<String> getVarNames(Collection<QueryModelNode> nodes) {
        HashSet nodeVarNames = Sets.newHashSet();
        for (QueryModelNode s : nodes) {
            List<String> tempVars = QueryVariableNormalizer.VarCollector.process(s);
            for (String t : tempVars) {
                nodeVarNames.add(t);
            }
        }
        return nodeVarNames;
    }

    private static void organizeBSAs(QueryModelNode node) {
        BindingSetAssignmentCollector bsac = new BindingSetAssignmentCollector();
        node.visit((QueryModelVisitor)bsac);
        if (bsac.containsBSAs()) {
            Set<QueryModelNode> bsaSet = bsac.getBindingSetAssignments();
            BindingSetAssignmentExchangeVisitor bsaev = new BindingSetAssignmentExchangeVisitor(bsaSet);
            node.visit((QueryModelVisitor)bsaev);
        }
    }

    public static class QueryNodeCount
    extends AbstractQueryModelVisitor<RuntimeException> {
        private int nodeCount = 0;

        public int getNodeCount() {
            return this.nodeCount;
        }

        public void meet(StatementPattern node) {
            ++this.nodeCount;
        }

        public void meet(Filter node) {
            ++this.nodeCount;
            node.getArg().visit((QueryModelVisitor)this);
        }
    }

    public static class BindingSetAssignmentCollector
    extends AbstractQueryModelVisitor<RuntimeException> {
        private Set<QueryModelNode> bindingSetList = Sets.newHashSet();

        public Set<QueryModelNode> getBindingSetAssignments() {
            return this.bindingSetList;
        }

        public boolean containsBSAs() {
            return this.bindingSetList.size() > 0;
        }

        public void meet(BindingSetAssignment node) {
            this.bindingSetList.add((QueryModelNode)node);
            super.meet(node);
        }
    }

    private static class BindingSetAssignmentExchangeVisitor
    extends AbstractQueryModelVisitor<RuntimeException> {
        private Set<QueryModelNode> bsas;

        public BindingSetAssignmentExchangeVisitor(Set<QueryModelNode> bsas) {
            this.bsas = bsas;
        }

        public void meet(Join queryNode) {
            if (this.bsas.size() > 0 && !(queryNode.getRightArg() instanceof BindingSetAssignment)) {
                QNodeExchanger qnev = new QNodeExchanger((QueryModelNode)queryNode.getRightArg(), this.bsas);
                queryNode.visit((QueryModelVisitor)qnev);
                queryNode.replaceChildNode((QueryModelNode)queryNode.getRightArg(), qnev.getReplaced());
                super.meet(queryNode);
            } else {
                super.meet(queryNode);
            }
        }
    }

    private static class FilterCollector
    extends AbstractQueryModelVisitor<RuntimeException> {
        private List<QueryModelNode> filterList = Lists.newArrayList();

        private FilterCollector() {
        }

        public List<QueryModelNode> getFilters() {
            return this.filterList;
        }

        public void meet(Filter node) {
            this.filterList.add((QueryModelNode)node.getCondition());
            super.meet(node);
        }
    }

    private static class ExternalTupleCollector
    extends AbstractQueryModelVisitor<RuntimeException> {
        private Set<QueryModelNode> eSet = new HashSet<QueryModelNode>();

        private ExternalTupleCollector() {
        }

        public void meetNode(QueryModelNode node) throws RuntimeException {
            if (node instanceof ExternalTupleSet) {
                this.eSet.add(node);
            }
            super.meetNode(node);
        }

        public Set<QueryModelNode> getExtTup() {
            return this.eSet;
        }
    }

    private static class ExtTupleExchangeVisitor
    extends AbstractQueryModelVisitor<RuntimeException> {
        private Set<QueryModelNode> extTuples;

        public ExtTupleExchangeVisitor(Set<QueryModelNode> extTuples) {
            this.extTuples = extTuples;
        }

        public void meet(Join queryNode) {
            if (this.extTuples.size() > 0 && !(queryNode.getRightArg() instanceof ExternalTupleSet) && !(queryNode.getRightArg() instanceof BindingSetAssignment)) {
                if (queryNode.getLeftArg() instanceof ExternalTupleSet) {
                    TupleExpr temp = queryNode.getLeftArg();
                    queryNode.setLeftArg(queryNode.getRightArg());
                    queryNode.setRightArg(temp);
                } else {
                    QNodeExchanger qnev = new QNodeExchanger((QueryModelNode)queryNode.getRightArg(), this.extTuples);
                    queryNode.visit((QueryModelVisitor)qnev);
                    queryNode.replaceChildNode((QueryModelNode)queryNode.getRightArg(), qnev.getReplaced());
                    super.meet(queryNode);
                }
            } else {
                super.meet(queryNode);
            }
        }
    }

    private static class ValidQueryVisitor
    extends AbstractQueryModelVisitor<RuntimeException> {
        private boolean isValid = true;

        private ValidQueryVisitor() {
        }

        public boolean isValid() {
            return this.isValid;
        }

        public void meet(Projection node) {
            node.getArg().visit((QueryModelVisitor)this);
        }

        public void meet(Filter node) {
            node.getArg().visit((QueryModelVisitor)this);
        }

        public void meetNode(QueryModelNode node) {
            if (!(node instanceof Join || node instanceof StatementPattern || node instanceof BindingSetAssignment || node instanceof Var)) {
                this.isValid = false;
                return;
            }
            super.meetNode(node);
        }
    }

    private static class SubsetEqualsVisitor
    extends AbstractQueryModelVisitor<RuntimeException> {
        private TupleExpr tuple;
        private QueryModelNode indexQNode;
        private ExternalTupleSet set;
        private Set<QueryModelNode> sSet = Sets.newHashSet();
        private boolean indexPlaced = false;

        public SubsetEqualsVisitor(ExternalTupleSet index, TupleExpr query) {
            this.tuple = index.getTupleExpr();
            this.set = index;
            this.indexQNode = ((Projection)this.tuple).getArg();
            this.sSet = GeneralizedExternalProcessor.getQNodes(this.indexQNode);
        }

        public boolean indexPlaced() {
            return this.indexPlaced;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void meet(Join node) {
            Set eSet = GeneralizedExternalProcessor.getQNodes((QueryModelNode)node);
            if (eSet.containsAll(this.sSet) && !(node.getRightArg() instanceof BindingSetAssignment)) {
                if (eSet.equals(this.sSet)) {
                    node.replaceWith((QueryModelNode)this.set);
                    this.indexPlaced = true;
                    return;
                }
                if (node.getLeftArg() instanceof StatementPattern && this.sSet.size() == 1) {
                    if (this.sSet.contains(node.getLeftArg())) {
                        node.setLeftArg((TupleExpr)this.set);
                        this.indexPlaced = true;
                        return;
                    } else {
                        if (!this.sSet.contains(node.getRightArg())) return;
                        node.setRightArg((TupleExpr)this.set);
                        this.indexPlaced = true;
                    }
                    return;
                } else {
                    super.meet(node);
                }
                return;
            } else {
                if (!eSet.containsAll(this.sSet)) return;
                super.meet(node);
            }
        }

        public void meet(Filter node) {
            Set eSet = GeneralizedExternalProcessor.getQNodes((QueryModelNode)node);
            if (eSet.containsAll(this.sSet)) {
                if (eSet.equals(this.sSet)) {
                    node.replaceWith((QueryModelNode)this.set);
                    this.indexPlaced = true;
                    return;
                }
                node.getArg().visit((QueryModelVisitor)this);
            }
        }

        public void meet(StatementPattern node) {
        }
    }

    private static class FilterBubbleManager
    extends AbstractQueryModelVisitor<RuntimeException> {
        private TupleExpr tuple;
        private QueryModelNode indexQNode;
        private Set<QueryModelNode> sSet = Sets.newHashSet();
        private Set<QueryModelNode> bubbledFilters = Sets.newHashSet();

        public FilterBubbleManager(ExternalTupleSet index) {
            this.tuple = index.getTupleExpr();
            this.indexQNode = ((Projection)this.tuple).getArg();
            this.sSet = GeneralizedExternalProcessor.getQNodes(this.indexQNode);
        }

        public void meet(Filter node) {
            Set eSet = GeneralizedExternalProcessor.getQNodes((QueryModelNode)node);
            Sets.SetView compSet = Sets.difference((Set)eSet, this.sSet);
            if (this.sSet.contains(node.getCondition()) && !this.bubbledFilters.contains(node.getCondition())) {
                FilterBubbleDownVisitor fbdv = new FilterBubbleDownVisitor((QueryModelNode)node.clone(), (Set<QueryModelNode>)compSet);
                node.visit((QueryModelVisitor)fbdv);
                this.bubbledFilters.add((QueryModelNode)node.getCondition());
                if (fbdv.filterPlaced()) {
                    QueryModelNode pNode = node.getParentNode();
                    TupleExpr cNode = node.getArg();
                    pNode.replaceChildNode((QueryModelNode)node, (QueryModelNode)cNode);
                    super.meetNode(pNode);
                }
                super.meet(node);
            } else {
                super.meet(node);
            }
        }
    }

    private static class FilterBubbleDownVisitor
    extends AbstractQueryModelVisitor<RuntimeException> {
        private QueryModelNode filter;
        private Set<QueryModelNode> compSet;
        private boolean filterPlaced = false;

        public FilterBubbleDownVisitor(QueryModelNode filter, Set<QueryModelNode> compSet) {
            this.filter = filter;
            this.compSet = compSet;
        }

        public boolean filterPlaced() {
            return this.filterPlaced;
        }

        public void meet(Join node) {
            if (!this.compSet.contains(node.getRightArg())) {
                if (node.getLeftArg() instanceof Join || !this.compSet.contains(node.getLeftArg())) {
                    QueryModelNode pNode = node.getParentNode();
                    ((Filter)this.filter).setArg((TupleExpr)node);
                    pNode.replaceChildNode((QueryModelNode)node, this.filter);
                    this.filterPlaced = true;
                    return;
                }
                ((Filter)this.filter).setArg(node.getRightArg());
                node.replaceChildNode((QueryModelNode)node.getRightArg(), this.filter);
                this.filterPlaced = true;
                return;
            }
            if (node.getLeftArg() instanceof StatementPattern && !this.compSet.contains(node.getLeftArg())) {
                ((Filter)this.filter).setArg(node.getLeftArg());
                node.replaceChildNode((QueryModelNode)node.getLeftArg(), this.filter);
                this.filterPlaced = true;
                return;
            }
            super.meet(node);
        }
    }

    private static class QNodeExchanger
    extends AbstractQueryModelVisitor<RuntimeException> {
        private QueryModelNode toBeReplaced;
        private QueryModelNode replacement;
        private Set<QueryModelNode> compSet;

        public QNodeExchanger(QueryModelNode replacement, Set<QueryModelNode> compSet) {
            this.replacement = replacement;
            this.toBeReplaced = replacement;
            this.compSet = compSet;
        }

        public QueryModelNode getReplaced() {
            return this.toBeReplaced;
        }

        public void meet(Join node) {
            if (this.compSet.contains(node.getRightArg())) {
                this.toBeReplaced = node.getRightArg();
                node.replaceChildNode((QueryModelNode)node.getRightArg(), this.replacement);
                return;
            }
            if (this.compSet.contains(node.getLeftArg())) {
                this.toBeReplaced = node.getLeftArg();
                node.replaceChildNode((QueryModelNode)node.getLeftArg(), this.replacement);
                return;
            }
            super.meet(node);
        }
    }

    private static class SPBubbleDownVisitor
    extends AbstractQueryModelVisitor<RuntimeException> {
        private TupleExpr tuple;
        private QueryModelNode indexQNode;
        private Set<QueryModelNode> sSet = Sets.newHashSet();

        public SPBubbleDownVisitor(ExternalTupleSet index) {
            this.tuple = index.getTupleExpr();
            this.indexQNode = ((Projection)this.tuple).getArg();
            this.sSet = GeneralizedExternalProcessor.getQNodes("sp", this.indexQNode);
        }

        public void meet(Projection node) {
            SPBubbleDownVisitor.organizeExtTuples((QueryModelNode)node);
            super.meet(node);
        }

        public void meet(Join node) {
            if (this.sSet.contains(node.getRightArg())) {
                Set eSet = GeneralizedExternalProcessor.getQNodes("sp", (QueryModelNode)node);
                Sets.SetView compSet = Sets.difference((Set)eSet, this.sSet);
                if (eSet.containsAll(this.sSet)) {
                    QNodeExchanger qne = new QNodeExchanger((QueryModelNode)node.getRightArg(), (Set<QueryModelNode>)compSet);
                    node.visit((QueryModelVisitor)qne);
                    node.replaceChildNode((QueryModelNode)node.getRightArg(), qne.getReplaced());
                    super.meet(node);
                }
                return;
            }
            if (this.sSet.contains(node.getLeftArg())) {
                Set eSet = GeneralizedExternalProcessor.getQNodes("sp", (QueryModelNode)node);
                Sets.SetView compSet = Sets.difference((Set)eSet, this.sSet);
                if (eSet.containsAll(this.sSet)) {
                    QNodeExchanger qne = new QNodeExchanger((QueryModelNode)node.getLeftArg(), (Set<QueryModelNode>)compSet);
                    node.visit((QueryModelVisitor)qne);
                    node.replaceChildNode((QueryModelNode)node.getLeftArg(), qne.getReplaced());
                    super.meet(node);
                }
                return;
            }
            super.meet(node);
        }

        private static void organizeExtTuples(QueryModelNode node) {
            ExternalTupleCollector eVis = new ExternalTupleCollector();
            node.visit((QueryModelVisitor)eVis);
            ExtTupleExchangeVisitor oev = new ExtTupleExchangeVisitor(eVis.getExtTup());
            node.visit((QueryModelVisitor)oev);
        }
    }
}

