/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.commons.lang.Validate;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import org.apache.rya.accumulo.AccumuloRdfConfiguration;
import org.apache.rya.indexing.FreeTextIndexer;
import org.apache.rya.indexing.IndexingExpr;
import org.apache.rya.indexing.IndexingFunctionRegistry;
import org.apache.rya.indexing.TemporalIndexer;
import org.apache.rya.indexing.TemporalTupleSet;
import org.apache.rya.indexing.accumulo.ConfigUtils;
import org.apache.rya.indexing.accumulo.freetext.AccumuloFreeTextIndexer;
import org.apache.rya.indexing.accumulo.freetext.FreeTextTupleSet;
import org.apache.rya.indexing.accumulo.temporal.AccumuloTemporalIndexer;
import org.apache.rya.mongodb.MongoSecondaryIndex;
import org.apache.rya.mongodb.StatefulMongoDBRdfConfiguration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.And;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.FunctionCall;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;

public class FilterFunctionOptimizer
implements QueryOptimizer,
Configurable {
    private static final Logger LOG = Logger.getLogger(FilterFunctionOptimizer.class);
    private static final ValueFactory VF = SimpleValueFactory.getInstance();
    private Configuration conf;
    private FreeTextIndexer freeTextIndexer;
    private TemporalIndexer temporalIndexer;
    private boolean init = false;

    public FilterFunctionOptimizer() {
    }

    public FilterFunctionOptimizer(AccumuloRdfConfiguration conf) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, IOException, TableExistsException, NumberFormatException, UnknownHostException {
        this.conf = conf;
        this.init();
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.init = false;
        this.init();
    }

    private synchronized void init() {
        if (!this.init) {
            if (ConfigUtils.getUseMongo(this.conf)) {
                StatefulMongoDBRdfConfiguration stateConf = (StatefulMongoDBRdfConfiguration)this.conf;
                for (MongoSecondaryIndex indexer : stateConf.getAdditionalIndexers()) {
                    if (indexer instanceof FreeTextIndexer) {
                        this.freeTextIndexer = (FreeTextIndexer)indexer;
                        continue;
                    }
                    if (!(indexer instanceof TemporalIndexer)) continue;
                    this.temporalIndexer = (TemporalIndexer)indexer;
                }
            } else {
                this.freeTextIndexer = new AccumuloFreeTextIndexer();
                this.freeTextIndexer.setConf(this.conf);
                this.temporalIndexer = new AccumuloTemporalIndexer();
                this.temporalIndexer.setConf(this.conf);
            }
            this.init = true;
        }
    }

    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        SearchVarVisitor searchVars = new SearchVarVisitor();
        tupleExpr.visit((QueryModelVisitor)searchVars);
        this.processPropertySearches(tupleExpr, searchVars.searchProperties);
    }

    private void processPropertySearches(TupleExpr tupleExpr, Collection<Var> searchProperties) {
        MatchStatementVisitor matchStatements = new MatchStatementVisitor(searchProperties);
        tupleExpr.visit((QueryModelVisitor)matchStatements);
        for (StatementPattern matchStatement : matchStatements.matchStatements) {
            Var subject = matchStatement.getSubjectVar();
            if (subject.hasValue() && !(subject.getValue() instanceof Resource)) {
                throw new IllegalArgumentException("Query error: Found " + subject.getValue() + ", expected an IRI or BNode");
            }
            Validate.isTrue((subject.hasValue() || subject.getName() != null ? 1 : 0) != 0);
            Validate.isTrue((!matchStatement.getObjectVar().hasValue() && matchStatement.getObjectVar().getName() != null ? 1 : 0) != 0);
            this.buildQuery(tupleExpr, matchStatement);
        }
    }

    private void buildQuery(TupleExpr tupleExpr, StatementPattern matchStatement) {
        LeftJoin leftJoin;
        if (matchStatement.getParentNode() instanceof LeftJoin && (leftJoin = (LeftJoin)matchStatement.getParentNode()).getRightArg() == matchStatement && leftJoin.getCondition() == null) {
            matchStatement.getParentNode().replaceWith((QueryModelNode)new Join(leftJoin.getLeftArg(), leftJoin.getRightArg()));
        }
        FilterFunction fVisitor = new FilterFunction(matchStatement.getObjectVar().getName());
        tupleExpr.visit((QueryModelVisitor)fVisitor);
        ArrayList results = Lists.newArrayList();
        for (int i = 0; i < fVisitor.func.size(); ++i) {
            results.add(new IndexingExpr((IRI)fVisitor.func.get(i), matchStatement, Arrays.stream((Object[])fVisitor.args.get(i)).toArray()));
        }
        this.removeMatchedPattern(tupleExpr, matchStatement, new IndexerExprReplacer(results));
    }

    private void removeMatchedPattern(TupleExpr tupleExpr, StatementPattern pattern, TupleExprReplacer replacer) {
        List<TupleExpr> indexTuples = replacer.createReplacement((TupleExpr)pattern);
        if (indexTuples.size() > 1) {
            VarExchangeVisitor vev = new VarExchangeVisitor(pattern);
            tupleExpr.visit((QueryModelVisitor)vev);
            Join join = new Join(indexTuples.remove(0), indexTuples.remove(0));
            for (TupleExpr geo : indexTuples) {
                join = new Join((TupleExpr)join, geo);
            }
            pattern.replaceWith((QueryModelNode)join);
        } else if (indexTuples.size() == 1) {
            pattern.replaceWith((QueryModelNode)indexTuples.get(0));
            pattern.setParentNode(null);
        } else {
            throw new IllegalStateException("Must have at least one replacement for matched StatementPattern.");
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    private static class VarExchangeVisitor
    extends AbstractQueryModelVisitor<RuntimeException> {
        private final StatementPattern exchangeVar;

        public VarExchangeVisitor(StatementPattern sp) {
            this.exchangeVar = sp;
        }

        public void meet(Join node) {
            TupleExpr lNode = node.getLeftArg();
            if (lNode instanceof StatementPattern) {
                this.exchangeVar.replaceWith((QueryModelNode)lNode);
                node.setLeftArg((TupleExpr)this.exchangeVar);
            } else {
                super.meet(node);
            }
        }
    }

    private class IndexerExprReplacer
    implements TupleExprReplacer {
        private final List<IndexingExpr> indxExpr;
        private final IndexingFunctionRegistry.FUNCTION_TYPE type;

        public IndexerExprReplacer(List<IndexingExpr> indxExpr) {
            this.indxExpr = indxExpr;
            IRI func = indxExpr.get(0).getFunction();
            this.type = IndexingFunctionRegistry.getFunctionType(func);
        }

        @Override
        public List<TupleExpr> createReplacement(TupleExpr org) {
            ArrayList indexTuples = Lists.newArrayList();
            switch (this.type) {
                case FREETEXT: {
                    for (IndexingExpr indx : this.indxExpr) {
                        indexTuples.add(new FreeTextTupleSet(indx, FilterFunctionOptimizer.this.freeTextIndexer));
                    }
                    break;
                }
                case TEMPORAL: {
                    for (IndexingExpr indx : this.indxExpr) {
                        indexTuples.add(new TemporalTupleSet(indx, FilterFunctionOptimizer.this.temporalIndexer));
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect type!");
                }
            }
            return indexTuples;
        }
    }

    private static interface TupleExprReplacer {
        public List<TupleExpr> createReplacement(TupleExpr var1);
    }

    private class FilterFunction
    extends AbstractEnhanceVisitor {
        public FilterFunction(String matchVar) {
            super(matchVar);
        }

        public void meet(FunctionCall call) {
            IRI fnUri = VF.createIRI(call.getURI());
            Var resultVar = IndexingFunctionRegistry.getResultVarFromFunctionCall(fnUri, call.getArgs());
            if (resultVar != null && resultVar.getName().equals(this.matchVar)) {
                this.addFilter(VF.createIRI(call.getURI()), this.extractArguments(this.matchVar, call));
                if (call.getParentNode() instanceof Filter || call.getParentNode() instanceof And || call.getParentNode() instanceof LeftJoin) {
                    call.replaceWith((QueryModelNode)new ValueConstant((Value)VF.createLiteral(true)));
                } else {
                    throw new IllegalArgumentException("Query error: Found " + call + " as part of an expression that is too complex");
                }
            }
        }

        private Value[] extractArguments(String matchName, FunctionCall call) {
            Value[] args = new Value[call.getArgs().size() - 1];
            int argI = 0;
            for (int i = 0; i != call.getArgs().size(); ++i) {
                ValueExpr arg = (ValueExpr)call.getArgs().get(i);
                if (argI == i && arg instanceof Var && matchName.equals(((Var)arg).getName())) continue;
                if (arg instanceof ValueConstant) {
                    args[argI] = ((ValueConstant)arg).getValue();
                } else if (arg instanceof Var && ((Var)arg).hasValue()) {
                    args[argI] = ((Var)arg).getValue();
                } else {
                    throw new IllegalArgumentException("Query error: Found " + arg + ", expected a Literal, BNode or URI");
                }
                ++argI;
            }
            return args;
        }

        public void meet(Filter filter) {
            filter.getArg().visit((QueryModelVisitor)this);
            filter.getCondition().visit((QueryModelVisitor)this);
        }
    }

    private abstract class AbstractEnhanceVisitor
    extends AbstractQueryModelVisitor<RuntimeException> {
        final String matchVar;
        List<IRI> func = Lists.newArrayList();
        List<Value[]> args = Lists.newArrayList();

        public AbstractEnhanceVisitor(String matchVar) {
            this.matchVar = matchVar;
        }

        protected void addFilter(IRI uri, Value[] values) {
            this.func.add(uri);
            this.args.add(values);
        }
    }

    private static class MatchStatementVisitor
    extends AbstractQueryModelVisitor<RuntimeException> {
        private final Collection<Var> propertyVars;
        private final Collection<Var> usedVars = new ArrayList<Var>();
        private final List<StatementPattern> matchStatements = new ArrayList<StatementPattern>();

        public MatchStatementVisitor(Collection<Var> propertyVars) {
            this.propertyVars = propertyVars;
        }

        public void meet(StatementPattern statement) {
            Var object = statement.getObjectVar();
            if (this.propertyVars.contains(object)) {
                if (this.usedVars.contains(object)) {
                    throw new IllegalArgumentException("Illegal search, variable is used multiple times as object: " + object.getName());
                }
                this.usedVars.add(object);
                this.matchStatements.add(statement);
            }
        }
    }

    private static class SearchVarVisitor
    extends AbstractQueryModelVisitor<RuntimeException> {
        private final Collection<Var> searchProperties = new ArrayList<Var>();

        private SearchVarVisitor() {
        }

        public void meet(FunctionCall fn) {
            IRI fun = VF.createIRI(fn.getURI());
            Var result = IndexingFunctionRegistry.getResultVarFromFunctionCall(fun, fn.getArgs());
            if (result != null && !this.searchProperties.contains(result)) {
                this.searchProperties.add(result);
            }
        }
    }
}

