/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.client.mongo;

import com.mongodb.MongoClient;
import com.mongodb.MongoException;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.rya.api.client.InstanceDoesNotExistException;
import org.apache.rya.api.client.InstanceExists;
import org.apache.rya.api.client.RyaClientException;
import org.apache.rya.api.client.Uninstall;
import org.apache.rya.api.client.mongo.MongoInstanceExists;

@DefaultAnnotation(value={NonNull.class})
public class MongoUninstall
implements Uninstall {
    private final MongoClient adminClient;
    private final InstanceExists instanceExists;

    public MongoUninstall(MongoClient adminClient, MongoInstanceExists instanceExists) {
        this.adminClient = Objects.requireNonNull(adminClient);
        this.instanceExists = Objects.requireNonNull(instanceExists);
    }

    public void uninstall(String ryaInstanceName) throws InstanceDoesNotExistException, RyaClientException {
        Objects.requireNonNull(ryaInstanceName);
        try {
            if (!this.instanceExists.exists(ryaInstanceName)) {
                throw new InstanceDoesNotExistException("The database '" + ryaInstanceName + "' does not exist.");
            }
            this.adminClient.getDatabase(ryaInstanceName).drop();
        }
        catch (MongoException e) {
            throw new RyaClientException("Failed to uninstall '" + ryaInstanceName + "' " + e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

