/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.client.mongo;

import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.hadoop.conf.Configuration;
import org.apache.rya.api.client.InstanceDoesNotExistException;
import org.apache.rya.api.client.InstanceExists;
import org.apache.rya.api.client.LoadStatements;
import org.apache.rya.api.client.RyaClientException;
import org.apache.rya.api.client.mongo.MongoConnectionDetails;
import org.apache.rya.api.client.mongo.MongoInstanceExists;
import org.apache.rya.api.persist.RyaDAOException;
import org.apache.rya.mongodb.MongoDBRdfConfiguration;
import org.apache.rya.rdftriplestore.inference.InferenceEngineException;
import org.apache.rya.sail.config.RyaSailFactory;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DefaultAnnotation(value={NonNull.class})
public class MongoLoadStatements
implements LoadStatements {
    private static final Logger log = LoggerFactory.getLogger(MongoLoadStatements.class);
    private final MongoConnectionDetails connectionDetails;
    private final InstanceExists instanceExists;

    public MongoLoadStatements(MongoConnectionDetails connectionDetails, MongoInstanceExists instanceExists) {
        this.connectionDetails = Objects.requireNonNull(connectionDetails);
        this.instanceExists = Objects.requireNonNull(instanceExists);
    }

    public void loadStatements(String ryaInstanceName, Iterable<? extends Statement> statements) throws InstanceDoesNotExistException, RyaClientException {
        Objects.requireNonNull(ryaInstanceName);
        Objects.requireNonNull(statements);
        if (!this.instanceExists.exists(ryaInstanceName)) {
            throw new InstanceDoesNotExistException(String.format("There is no Rya instance named '%s'.", ryaInstanceName));
        }
        Sail sail = null;
        SailRepositoryConnection sailRepoConn = null;
        try {
            MongoDBRdfConfiguration ryaConf = this.connectionDetails.build(ryaInstanceName);
            sail = RyaSailFactory.getInstance((Configuration)ryaConf);
            SailRepository sailRepo = new SailRepository(sail);
            sailRepoConn = sailRepo.getConnection();
            sailRepoConn = sailRepo.getConnection();
            sailRepoConn.add(statements, new Resource[0]);
        }
        catch (AccumuloException | AccumuloSecurityException | RyaDAOException | InferenceEngineException | SailException e) {
            throw new RyaClientException("Could not load statements into Rya because of a problem while creating the Sail object.", e);
        }
        catch (RepositoryException e) {
            throw new RyaClientException("Could not load the statements into Rya.", (Throwable)e);
        }
        finally {
            if (sailRepoConn != null) {
                try {
                    sailRepoConn.close();
                }
                catch (RepositoryException e) {
                    log.error("Couldn't close the SailRepositoryConnection object.", (Throwable)e);
                }
            }
            if (sail != null) {
                try {
                    sail.shutDown();
                }
                catch (SailException e) {
                    log.error("Couldn't close the Sail object.", (Throwable)e);
                }
            }
        }
    }
}

