/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.client.mongo;

import com.mongodb.MongoClient;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.rya.api.client.ListInstances;
import org.apache.rya.api.client.RyaClientException;

@DefaultAnnotation(value={NonNull.class})
public class MongoListInstances
implements ListInstances {
    private final MongoClient adminClient;

    public MongoListInstances(MongoClient adminClient) {
        this.adminClient = Objects.requireNonNull(adminClient);
    }

    public List<String> listInstances() throws RyaClientException {
        ArrayList<String> ryaInstances = new ArrayList<String>();
        block0: for (String db : this.adminClient.listDatabaseNames()) {
            for (String collection : this.adminClient.getDatabase(db).listCollectionNames()) {
                if (!collection.equals("instance_details")) continue;
                ryaInstances.add(db);
                continue block0;
            }
        }
        return ryaInstances;
    }
}

