/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.client.mongo;

import com.mongodb.MongoClient;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.rya.api.client.InstanceExists;

@DefaultAnnotation(value={NonNull.class})
public class MongoInstanceExists
implements InstanceExists {
    private final MongoClient adminClient;

    public MongoInstanceExists(MongoClient adminClient) {
        this.adminClient = Objects.requireNonNull(adminClient);
    }

    public boolean exists(String instanceName) {
        Objects.requireNonNull(instanceName);
        for (String dbName : this.adminClient.listDatabaseNames()) {
            if (!dbName.equals(instanceName)) continue;
            return true;
        }
        return false;
    }
}

