/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.client.mongo;

import com.google.common.base.Optional;
import com.mongodb.MongoClient;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.hadoop.conf.Configuration;
import org.apache.rya.api.RdfCloudTripleStoreConfiguration;
import org.apache.rya.api.client.Install;
import org.apache.rya.api.client.InstanceExists;
import org.apache.rya.api.client.RyaClientException;
import org.apache.rya.api.client.mongo.MongoConnectionDetails;
import org.apache.rya.api.client.mongo.MongoInstanceExists;
import org.apache.rya.api.instance.RyaDetails;
import org.apache.rya.api.instance.RyaDetailsRepository;
import org.apache.rya.api.persist.RyaDAOException;
import org.apache.rya.indexing.accumulo.ConfigUtils;
import org.apache.rya.mongodb.MongoDBRdfConfiguration;
import org.apache.rya.mongodb.instance.MongoRyaInstanceDetailsRepository;
import org.apache.rya.rdftriplestore.inference.InferenceEngineException;
import org.apache.rya.sail.config.RyaSailFactory;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DefaultAnnotation(value={NonNull.class})
public class MongoInstall
implements Install {
    private static final Logger log = LoggerFactory.getLogger(MongoInstall.class);
    private final MongoConnectionDetails connectionDetails;
    private final MongoClient adminClient;
    private final InstanceExists instanceExists;

    public MongoInstall(MongoConnectionDetails connectionDetails, MongoClient adminClient, MongoInstanceExists instanceExists) {
        this.connectionDetails = Objects.requireNonNull(connectionDetails);
        this.adminClient = Objects.requireNonNull(adminClient);
        this.instanceExists = Objects.requireNonNull(instanceExists);
    }

    public void install(String instanceName, Install.InstallConfiguration installConfig) throws Install.DuplicateInstanceNameException, RyaClientException {
        RyaDetails ryaDetails;
        Objects.requireNonNull(instanceName);
        Objects.requireNonNull(installConfig);
        if (this.instanceExists.exists(instanceName)) {
            throw new Install.DuplicateInstanceNameException("An instance of Rya has already been installed to this Rya storage with the name '" + instanceName + "'. Try again with a different name.");
        }
        try {
            ryaDetails = this.initializeRyaDetails(instanceName, installConfig);
        }
        catch (RyaDetailsRepository.AlreadyInitializedException e) {
            throw new Install.DuplicateInstanceNameException("An instance of Rya has already been installed to this Rya storage with the name '" + instanceName + "'. Try again with a different name.");
        }
        catch (RyaDetailsRepository.RyaDetailsRepositoryException e) {
            throw new RyaClientException("The RyaDetails couldn't be initialized. Details: " + e.getMessage(), (Throwable)e);
        }
        MongoDBRdfConfiguration ryaConfig = MongoInstall.makeRyaConfig(this.connectionDetails, ryaDetails);
        try {
            Sail ryaSail = RyaSailFactory.getInstance((Configuration)ryaConfig);
            ryaSail.shutDown();
        }
        catch (AccumuloException | AccumuloSecurityException | RyaDAOException | InferenceEngineException e) {
            throw new RyaClientException("Could not initialize all of the tables for the new Rya instance. This instance may be left in a bad state.", e);
        }
        catch (SailException e) {
            throw new RyaClientException("Problem shutting down the Sail object used to install Rya.", (Throwable)e);
        }
    }

    private String getVersion() {
        return "" + this.getClass().getPackage().getImplementationVersion();
    }

    private RyaDetails initializeRyaDetails(String instanceName, Install.InstallConfiguration installConfig) throws RyaDetailsRepository.AlreadyInitializedException, RyaDetailsRepository.RyaDetailsRepositoryException {
        MongoRyaInstanceDetailsRepository detailsRepo = new MongoRyaInstanceDetailsRepository(this.adminClient, instanceName);
        if (installConfig.getFluoPcjAppName().isPresent()) {
            log.warn("Mongo does not have fluo support, use ignoring the configured fluo application name: " + (String)installConfig.getFluoPcjAppName().get());
        }
        RyaDetails.PCJIndexDetails.Builder pcjDetailsBuilder = RyaDetails.PCJIndexDetails.builder().setEnabled(Boolean.valueOf(installConfig.isPcjIndexEnabled()));
        RyaDetails details = RyaDetails.builder().setRyaInstanceName(instanceName).setRyaVersion(this.getVersion()).setTemporalIndexDetails(new RyaDetails.TemporalIndexDetails(installConfig.isTemporalIndexEnabled())).setFreeTextDetails(new RyaDetails.FreeTextIndexDetails(installConfig.isFreeTextIndexEnabled())).setEntityCentricIndexDetails(new RyaDetails.EntityCentricIndexDetails(false)).setPCJIndexDetails(pcjDetailsBuilder).setProspectorDetails(new RyaDetails.ProspectorDetails(Optional.absent())).setJoinSelectivityDetails(new RyaDetails.JoinSelectivityDetails(Optional.absent())).build();
        detailsRepo.initialize(details);
        return details;
    }

    private static MongoDBRdfConfiguration makeRyaConfig(MongoConnectionDetails connectionDetails, RyaDetails ryaDetails) {
        MongoDBRdfConfiguration conf = connectionDetails.build(ryaDetails.getRyaInstanceName());
        conf.setBoolean("sc.use_pcj", ryaDetails.getPCJIndexDetails().isEnabled());
        if (ryaDetails.getEntityCentricIndexDetails().isEnabled()) {
            log.warn("The install configuration says to enable Entity Centric indexing, but Mongo RYA does not support that feature. Ignoring this configuration.");
        }
        conf.setBoolean("sc.use_entity", false);
        conf.setBoolean("sc.use_freetext", ryaDetails.getFreeTextIndexDetails().isEnabled());
        conf.setBoolean("sc.use_temporal", ryaDetails.getTemporalIndexDetails().isEnabled());
        ConfigUtils.setIndexers((RdfCloudTripleStoreConfiguration)conf);
        return conf;
    }
}

