/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.client.mongo;

import com.google.common.base.Optional;
import com.mongodb.MongoClient;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.rya.api.client.GetInstanceDetails;
import org.apache.rya.api.client.InstanceDoesNotExistException;
import org.apache.rya.api.client.InstanceExists;
import org.apache.rya.api.client.RyaClientException;
import org.apache.rya.api.client.mongo.MongoInstanceExists;
import org.apache.rya.api.instance.RyaDetails;
import org.apache.rya.api.instance.RyaDetailsRepository;
import org.apache.rya.mongodb.instance.MongoRyaInstanceDetailsRepository;

@DefaultAnnotation(value={NonNull.class})
public class MongoGetInstanceDetails
implements GetInstanceDetails {
    private final MongoClient adminClient;
    private final InstanceExists instanceExists;

    public MongoGetInstanceDetails(MongoClient adminClient, MongoInstanceExists instanceExists) {
        this.adminClient = Objects.requireNonNull(adminClient);
        this.instanceExists = Objects.requireNonNull(instanceExists);
    }

    public Optional<RyaDetails> getDetails(String ryaInstanceName) throws InstanceDoesNotExistException, RyaClientException {
        Objects.requireNonNull(ryaInstanceName);
        if (!this.instanceExists.exists(ryaInstanceName)) {
            throw new InstanceDoesNotExistException(String.format("There is no Rya instance named '%s'.", ryaInstanceName));
        }
        MongoRyaInstanceDetailsRepository detailsRepo = new MongoRyaInstanceDetailsRepository(this.adminClient, ryaInstanceName);
        try {
            return Optional.of((Object)detailsRepo.getRyaInstanceDetails());
        }
        catch (RyaDetailsRepository.NotInitializedException e) {
            return Optional.absent();
        }
        catch (RyaDetailsRepository.RyaDetailsRepositoryException e) {
            throw new RyaClientException("Could not fetch the Rya instance's details.", (Throwable)e);
        }
    }
}

