/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.client.mongo;

import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Objects;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.hadoop.conf.Configuration;
import org.apache.rya.api.client.ExecuteSparqlQuery;
import org.apache.rya.api.client.InstanceDoesNotExistException;
import org.apache.rya.api.client.InstanceExists;
import org.apache.rya.api.client.RyaClientException;
import org.apache.rya.api.client.mongo.MongoConnectionDetails;
import org.apache.rya.api.client.mongo.MongoInstanceExists;
import org.apache.rya.api.persist.RyaDAOException;
import org.apache.rya.mongodb.MongoDBRdfConfiguration;
import org.apache.rya.rdftriplestore.inference.InferenceEngineException;
import org.apache.rya.sail.config.RyaSailFactory;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DefaultAnnotation(value={NonNull.class})
public class MongoExecuteSparqlQuery
implements ExecuteSparqlQuery {
    private static final Logger log = LoggerFactory.getLogger(MongoExecuteSparqlQuery.class);
    private final MongoConnectionDetails connectionDetails;
    private final InstanceExists instanceExists;
    private Sail sail = null;
    private SailRepositoryConnection sailRepoConn = null;

    public MongoExecuteSparqlQuery(MongoConnectionDetails connectionDetails, MongoInstanceExists instanceExists) {
        this.connectionDetails = Objects.requireNonNull(connectionDetails);
        this.instanceExists = Objects.requireNonNull(instanceExists);
    }

    public TupleQueryResult executeSparqlQuery(String ryaInstanceName, String sparqlQuery) throws InstanceDoesNotExistException, RyaClientException {
        Objects.requireNonNull(ryaInstanceName);
        Objects.requireNonNull(sparqlQuery);
        if (!this.instanceExists.exists(ryaInstanceName)) {
            throw new InstanceDoesNotExistException(String.format("There is no Rya instance named '%s'.", ryaInstanceName));
        }
        try {
            MongoDBRdfConfiguration ryaConf = this.connectionDetails.build(ryaInstanceName);
            this.sail = RyaSailFactory.getInstance((Configuration)ryaConf);
            SailRepository sailRepo = new SailRepository(this.sail);
            this.sailRepoConn = sailRepo.getConnection();
            TupleQuery tupleQuery = this.sailRepoConn.prepareTupleQuery(QueryLanguage.SPARQL, sparqlQuery);
            return tupleQuery.evaluate();
        }
        catch (AccumuloException | AccumuloSecurityException | RyaDAOException | InferenceEngineException | SailException e) {
            throw new RyaClientException("Could not create the Sail object used to query the RYA instance.", e);
        }
        catch (MalformedQueryException | QueryEvaluationException | RepositoryException e) {
            throw new RyaClientException("Could not execute the SPARQL query.", e);
        }
    }

    public void close() throws IOException {
        if (this.sailRepoConn != null) {
            try {
                this.sailRepoConn.close();
            }
            catch (RepositoryException e) {
                log.error("Couldn't close the SailRepositoryConnection object.", (Throwable)e);
            }
        }
        if (this.sail != null) {
            try {
                this.sail.shutDown();
            }
            catch (SailException e) {
                log.error("Couldn't close the Sail object.", (Throwable)e);
            }
        }
    }
}

