/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.client.mongo;

import com.mongodb.MongoClient;
import java.util.Objects;
import org.apache.rya.api.client.DeletePCJ;
import org.apache.rya.api.client.InstanceDoesNotExistException;
import org.apache.rya.api.client.InstanceExists;
import org.apache.rya.api.client.RyaClientException;
import org.apache.rya.api.client.mongo.MongoInstanceExists;
import org.apache.rya.indexing.pcj.storage.PrecomputedJoinStorage;
import org.apache.rya.indexing.pcj.storage.mongo.MongoPcjStorage;

public class MongoDeletePCJ
implements DeletePCJ {
    private final InstanceExists instanceExists;
    private final MongoClient mongoClient;

    public MongoDeletePCJ(MongoClient mongoClient, MongoInstanceExists instanceExists) {
        this.mongoClient = Objects.requireNonNull(mongoClient);
        this.instanceExists = Objects.requireNonNull(instanceExists);
    }

    public void deletePCJ(String ryaInstanceName, String pcjId) throws InstanceDoesNotExistException, RyaClientException {
        Objects.requireNonNull(ryaInstanceName);
        Objects.requireNonNull(pcjId);
        if (!this.instanceExists.exists(ryaInstanceName)) {
            throw new InstanceDoesNotExistException(String.format("There is no Rya instance named '%s'.", ryaInstanceName));
        }
        try (MongoPcjStorage pcjStore = new MongoPcjStorage(this.mongoClient, ryaInstanceName);){
            pcjStore.dropPcj(pcjId);
        }
        catch (PrecomputedJoinStorage.PCJStorageException e) {
            throw new RyaClientException("Unable to drop PCJ : " + pcjId, (Throwable)e);
        }
    }
}

