/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.client.mongo;

import com.google.common.collect.Sets;
import com.mongodb.MongoClient;
import java.util.Objects;
import java.util.Set;
import org.apache.rya.api.client.CreatePCJ;
import org.apache.rya.api.client.InstanceDoesNotExistException;
import org.apache.rya.api.client.InstanceExists;
import org.apache.rya.api.client.RyaClientException;
import org.apache.rya.api.client.mongo.MongoInstanceExists;
import org.apache.rya.indexing.pcj.storage.PrecomputedJoinStorage;
import org.apache.rya.indexing.pcj.storage.mongo.MongoPcjStorage;

public class MongoCreatePCJ
implements CreatePCJ {
    private final InstanceExists instanceExists;
    private final MongoClient mongoClient;

    public MongoCreatePCJ(MongoClient mongoClient, MongoInstanceExists instanceExists) {
        this.mongoClient = Objects.requireNonNull(mongoClient);
        this.instanceExists = Objects.requireNonNull(instanceExists);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String createPCJ(String ryaInstanceName, String sparql, Set<CreatePCJ.ExportStrategy> strategies) throws InstanceDoesNotExistException, RyaClientException {
        Objects.requireNonNull(ryaInstanceName);
        Objects.requireNonNull(sparql);
        if (!this.instanceExists.exists(ryaInstanceName)) {
            throw new InstanceDoesNotExistException(String.format("There is no Rya instance named '%s'.", ryaInstanceName));
        }
        try (MongoPcjStorage pcjStore = new MongoPcjStorage(this.mongoClient, ryaInstanceName);){
            String string = pcjStore.createPcj(sparql);
            return string;
        }
        catch (PrecomputedJoinStorage.PCJStorageException e) {
            throw new RyaClientException("Unable to create PCJ for: " + sparql, (Throwable)e);
        }
    }

    public String createPCJ(String instanceName, String sparql) throws InstanceDoesNotExistException, RyaClientException {
        return this.createPCJ(instanceName, sparql, Sets.newHashSet((Object[])new CreatePCJ.ExportStrategy[]{CreatePCJ.ExportStrategy.RYA}));
    }
}

