/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.client.mongo;

import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import org.apache.rya.mongodb.MongoDBRdfConfiguration;

@DefaultAnnotation(value={NonNull.class})
public class MongoConnectionDetails {
    private final Optional<String> username;
    private final Optional<char[]> password;
    private final String hostname;
    private final int port;

    public MongoConnectionDetails(String hostname, int port, Optional<String> username, Optional<char[]> password) {
        this.hostname = Objects.requireNonNull(hostname);
        this.port = port;
        this.username = Objects.requireNonNull(username);
        this.password = Objects.requireNonNull(password);
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public Optional<String> getUsername() {
        return this.username;
    }

    public Optional<char[]> getPassword() {
        return this.password;
    }

    public MongoDBRdfConfiguration build(String ryaInstanceName) {
        MongoDBRdfConfiguration conf = new MongoDBRdfConfiguration();
        conf.setBoolean("sc.useMongo", true);
        conf.setMongoHostname(this.hostname);
        conf.setMongoPort("" + this.port);
        conf.setMongoDBName(ryaInstanceName);
        if (this.username.isPresent()) {
            conf.setMongoUser(this.username.get());
        }
        if (this.password.isPresent()) {
            conf.setMongoPassword(new String(this.password.get()));
        }
        conf.setTablePrefix("rya");
        return conf;
    }
}

