/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.client.mongo;

import com.google.common.base.Preconditions;
import com.mongodb.MongoClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.hadoop.conf.Configuration;
import org.apache.rya.api.client.BatchUpdatePCJ;
import org.apache.rya.api.client.InstanceDoesNotExistException;
import org.apache.rya.api.client.InstanceExists;
import org.apache.rya.api.client.PCJDoesNotExistException;
import org.apache.rya.api.client.RyaClientException;
import org.apache.rya.api.client.mongo.MongoConnectionDetails;
import org.apache.rya.api.client.mongo.MongoInstanceExists;
import org.apache.rya.api.instance.RyaDetails;
import org.apache.rya.api.instance.RyaDetailsRepository;
import org.apache.rya.api.instance.RyaDetailsUpdater;
import org.apache.rya.api.model.VisibilityBindingSet;
import org.apache.rya.api.persist.RyaDAOException;
import org.apache.rya.indexing.pcj.storage.PcjMetadata;
import org.apache.rya.indexing.pcj.storage.PrecomputedJoinStorage;
import org.apache.rya.indexing.pcj.storage.mongo.MongoPcjStorage;
import org.apache.rya.mongodb.MongoDBRdfConfiguration;
import org.apache.rya.mongodb.instance.MongoRyaInstanceDetailsRepository;
import org.apache.rya.rdftriplestore.inference.InferenceEngineException;
import org.apache.rya.sail.config.RyaSailFactory;
import org.eclipse.rdf4j.query.AbstractTupleQueryResultHandler;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoBatchUpdatePCJ
implements BatchUpdatePCJ {
    private static final Logger log = LoggerFactory.getLogger(MongoBatchUpdatePCJ.class);
    private final MongoConnectionDetails connectionDetails;
    private final MongoClient mongoClient;
    private final InstanceExists instanceExists;

    public MongoBatchUpdatePCJ(MongoConnectionDetails connectionDetails, MongoClient mongoClient, MongoInstanceExists instanceExists) {
        this.connectionDetails = Objects.requireNonNull(connectionDetails);
        this.mongoClient = Objects.requireNonNull(mongoClient);
        this.instanceExists = Objects.requireNonNull(instanceExists);
    }

    public void batchUpdate(String ryaInstanceName, String pcjId) throws InstanceDoesNotExistException, PCJDoesNotExistException, RyaClientException {
        Objects.requireNonNull(ryaInstanceName);
        Objects.requireNonNull(pcjId);
        Preconditions.checkState((boolean)this.instanceExists.exists(ryaInstanceName), (Object)("The instance: " + ryaInstanceName + " does not exist."));
        this.verifyPCJState(ryaInstanceName, pcjId, this.mongoClient);
        this.updatePCJResults(ryaInstanceName, pcjId, this.mongoClient);
        this.updatePCJMetadata(ryaInstanceName, pcjId, this.mongoClient);
    }

    private void verifyPCJState(String ryaInstanceName, String pcjId, MongoClient client) throws RyaClientException {
        try {
            MongoRyaInstanceDetailsRepository detailsRepo = new MongoRyaInstanceDetailsRepository(client, ryaInstanceName);
            RyaDetails ryaDetails = detailsRepo.getRyaInstanceDetails();
            if (!ryaDetails.getPCJIndexDetails().isEnabled()) {
                throw new RyaClientException("PCJs are not enabled for the Rya instance named '" + ryaInstanceName + "'.");
            }
            if (!ryaDetails.getPCJIndexDetails().getPCJDetails().containsKey((Object)pcjId)) {
                throw new PCJDoesNotExistException("The PCJ with id '" + pcjId + "' does not exist within Rya instance '" + ryaInstanceName + "'.");
            }
        }
        catch (RyaDetailsRepository.NotInitializedException e) {
            throw new InstanceDoesNotExistException("No RyaDetails are initialized for the Rya instance named '" + ryaInstanceName + "'.", (Throwable)e);
        }
        catch (RyaDetailsRepository.RyaDetailsRepositoryException e) {
            throw new RyaClientException("Could not fetch the RyaDetails for the Rya instance named '" + ryaInstanceName + "'.", (Throwable)e);
        }
    }

    private void updatePCJResults(String ryaInstanceName, String pcjId, MongoClient client) throws InstanceDoesNotExistException, PCJDoesNotExistException, RyaClientException {
        Sail sail = null;
        SailConnection sailConn = null;
        try (MongoPcjStorage pcjStorage = new MongoPcjStorage(client, ryaInstanceName);){
            sail = this.connectToRya(ryaInstanceName);
            SailRepository sailRepo = new SailRepository(sail);
            SailRepositoryConnection sailRepoConn = sailRepo.getConnection();
            try {
                pcjStorage.purge(pcjId);
            }
            catch (PrecomputedJoinStorage.PCJStorageException e) {
                throw new RyaClientException("Could not batch update PCJ with ID '" + pcjId + "' because the old results could not be purged from it.", (Throwable)e);
            }
            PcjMetadata metadata = pcjStorage.getPcjMetadata(pcjId);
            String sparql = metadata.getSparql();
            sailConn = sail.getConnection();
            TupleQuery tupleQuery = sailRepoConn.prepareTupleQuery(QueryLanguage.SPARQL, sparql);
            final ArrayList batch = new ArrayList(1000);
            tupleQuery.evaluate((TupleQueryResultHandler)new AbstractTupleQueryResultHandler((PrecomputedJoinStorage)pcjStorage, pcjId){
                final /* synthetic */ PrecomputedJoinStorage val$pcjStorage;
                final /* synthetic */ String val$pcjId;
                {
                    this.val$pcjStorage = precomputedJoinStorage;
                    this.val$pcjId = string;
                }

                public void handleSolution(BindingSet bindingSet) throws TupleQueryResultHandlerException {
                    VisibilityBindingSet result = new VisibilityBindingSet(bindingSet, "");
                    log.warn("Visibility information on the binding set is lost during a batch update.  This can create data leaks.");
                    batch.add(result);
                    if (batch.size() == 1000) {
                        try {
                            this.val$pcjStorage.addResults(this.val$pcjId, (Collection)batch);
                        }
                        catch (PrecomputedJoinStorage.PCJStorageException e) {
                            throw new TupleQueryResultHandlerException("Fail to batch load new results into the PCJ with ID '" + this.val$pcjId + "'.", (Throwable)e);
                        }
                        batch.clear();
                    }
                }
            });
            if (!batch.isEmpty()) {
                pcjStorage.addResults(pcjId, batch);
                batch.clear();
            }
        }
        catch (PrecomputedJoinStorage.PCJStorageException | MalformedQueryException | QueryEvaluationException | TupleQueryResultHandlerException | RepositoryException | SailException e) {
            throw new RyaClientException("Fail to batch load new results into the PCJ with ID '" + pcjId + "'.", e);
        }
        finally {
            if (sailConn != null) {
                try {
                    sailConn.close();
                }
                catch (SailException e) {
                    log.warn(e.getMessage(), (Throwable)e);
                }
            }
            if (sail != null) {
                try {
                    sail.shutDown();
                }
                catch (SailException e) {
                    log.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private Sail connectToRya(String ryaInstanceName) throws RyaClientException {
        try {
            MongoDBRdfConfiguration ryaConf = this.connectionDetails.build(ryaInstanceName);
            return RyaSailFactory.getInstance((Configuration)ryaConf);
        }
        catch (AccumuloException | AccumuloSecurityException | RyaDAOException | InferenceEngineException | SailException e) {
            throw new RyaClientException("Could not connect to the Rya instance named '" + ryaInstanceName + "'.", e);
        }
    }

    private void updatePCJMetadata(String ryaInstanceName, final String pcjId, MongoClient client) throws RyaClientException {
        try {
            MongoRyaInstanceDetailsRepository detailsRepo = new MongoRyaInstanceDetailsRepository(client, ryaInstanceName);
            new RyaDetailsUpdater((RyaDetailsRepository)detailsRepo).update(new RyaDetailsUpdater.RyaDetailsMutator(){

                public RyaDetails mutate(RyaDetails originalDetails) throws RyaDetailsUpdater.RyaDetailsMutator.CouldNotApplyMutationException {
                    RyaDetails.PCJIndexDetails.PCJDetails originalPCJDetails = (RyaDetails.PCJIndexDetails.PCJDetails)originalDetails.getPCJIndexDetails().getPCJDetails().get((Object)pcjId);
                    RyaDetails.PCJIndexDetails.PCJDetails.Builder mutatedPCJDetails = RyaDetails.PCJIndexDetails.PCJDetails.builder((RyaDetails.PCJIndexDetails.PCJDetails)originalPCJDetails).setUpdateStrategy(RyaDetails.PCJIndexDetails.PCJDetails.PCJUpdateStrategy.BATCH).setLastUpdateTime(new Date());
                    RyaDetails.Builder builder = RyaDetails.builder((RyaDetails)originalDetails);
                    builder.getPCJIndexDetails().addPCJDetails(mutatedPCJDetails);
                    return builder.build();
                }
            });
        }
        catch (RyaDetailsRepository.RyaDetailsRepositoryException | RyaDetailsUpdater.RyaDetailsMutator.CouldNotApplyMutationException e) {
            throw new RyaClientException("Could not update the PCJ's metadata.", e);
        }
    }
}

