/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.client.accumulo;

import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.fluo.api.client.FluoClient;
import org.apache.fluo.api.client.FluoFactory;
import org.apache.fluo.api.config.FluoConfiguration;
import org.apache.fluo.api.config.SimpleConfiguration;

@DefaultAnnotation(value={NonNull.class})
public class FluoClientFactory {
    public FluoClient connect(String username, String password, String instanceName, String zookeeperHostnames, String fluoAppName) {
        Objects.requireNonNull(username);
        Objects.requireNonNull(password);
        Objects.requireNonNull(instanceName);
        Objects.requireNonNull(zookeeperHostnames);
        Objects.requireNonNull(fluoAppName);
        FluoConfiguration fluoConfig = new FluoConfiguration();
        fluoConfig.setApplicationName(fluoAppName);
        fluoConfig.setInstanceZookeepers(zookeeperHostnames + "/fluo");
        fluoConfig.setAccumuloZookeepers(zookeeperHostnames);
        fluoConfig.setAccumuloInstance(instanceName);
        fluoConfig.setAccumuloUser(username);
        fluoConfig.setAccumuloPassword(password);
        return FluoFactory.newClient((SimpleConfiguration)fluoConfig);
    }
}

